/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.ParDebug;
import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;
import charm.debug.inspect.GenericElement;
import charm.debug.inspect.GenericType;
import charm.debug.inspect.InspectedElement;
import charm.debug.inspect.Inspector;
import charm.debug.inspect.JTreeVisitor;
import charm.debug.inspect.SuperClassElement;
import charm.debug.inspect.VariableElement;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.ByteBuffer;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class InspectPanel
extends JPanel
implements ActionListener {
    private JScrollPane scroll;
    private JTree tree;
    int pe;

    public InspectPanel() {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(100, 100));
        this.scroll = new JScrollPane();
        this.add(this.scroll);
    }

    public void clear() {
        this.scroll.setViewportView(new JLabel(""));
    }

    public void load(String s) {
        this.scroll.setViewportView(new JLabel(s));
    }

    public void load(int pe, long location, GenericType type) {
        this.pe = pe;
        System.out.println("location = " + (int)location + ", " + (int)(location >>> 32));
        PList list = ParDebug.server.getPList("converse/memory/data", pe, (int)location, (int)(location >>> 32));
        if (list == null) {
            System.out.println("list is null!");
        }
        PList cur = (PList)list.elementAt(0);
        int size = ((PNative)cur.elementNamed("size")).getIntValue(0);
        System.out.println("Got memory data size = " + size);
        if (size > 0) {
            ByteBuffer buf = null;
            PAbstract info = cur.elementNamed("value");
            if (info != null) {
                buf = ByteBuffer.wrap(((PString)info).getBytes()).order(Inspector.getByteOrder());
            }
            String request2 = "info symbol 0x";
            request2 = Inspector.is64bit() ? request2 + Long.toHexString(buf.getLong()) : request2 + Integer.toHexString(buf.getInt());
            String result = ParDebug.infoCommand(request2 = request2 + "\n");
            if (result.startsWith("vtable for")) {
                String strtype = result.substring(10, result.indexOf(43)).trim();
                GenericType gt = Inspector.getTypeCreate(strtype);
                this.load(new SuperClassElement(gt, 0), buf);
            } else {
                buf.rewind();
                for (int i = 0; i < size; ++i) {
                    System.out.print("0x" + Integer.toHexString(buf.get()) + " ");
                }
            }
        }
    }

    public void load(GenericElement type, ByteBuffer buf) {
        JTreeVisitor jtv = new JTreeVisitor(buf, type.getName());
        jtv.visit(type);
        this.tree = (JTree)jtv.getResult();
        this.tree.getSelectionModel().setSelectionMode(1);
        this.scroll.setViewportView(this.tree);
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Follow pointer");
        menuItem.setActionCommand("dereference");
        menuItem.addActionListener(this);
        popup.add(menuItem);
        PopupListener popupListener = new PopupListener(popup);
        this.tree.addMouseListener(popupListener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("dereference")) {
            DefaultMutableTreeNode obj = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            InspectedElement el = (InspectedElement)obj.getUserObject();
            if (el.value == null) {
                return;
            }
            long location = Long.parseLong(el.value.substring(el.value.indexOf("0x") + 2), 16);
            if (location > 0L) {
                PList list = ParDebug.server.getPList("converse/memory/data", this.pe, (int)location, (int)(location >>> 32));
                if (list == null) {
                    System.out.println("list is null!");
                }
                PList cur = (PList)list.elementAt(0);
                int size = ((PNative)cur.elementNamed("size")).getIntValue(0);
                System.out.println("Got memory data size = " + size);
                if (size > 0) {
                    ByteBuffer buf = null;
                    PAbstract info = cur.elementNamed("value");
                    if (info != null) {
                        buf = ByteBuffer.wrap(((PString)info).getBytes()).order(Inspector.getByteOrder());
                    }
                    JTreeVisitor jtv = new JTreeVisitor(buf, el.e.getType().getName());
                    if (el.e.getPointer() > 1) {
                        VariableElement vel = new VariableElement(el.e.getType(), null, el.e.getType().pointerSize(), el.e.getPointer() + el.e.getType().getPointer() - 1, 0);
                        obj.add(new DefaultMutableTreeNode(new InspectedElement(vel, "0x0")));
                    } else {
                        jtv.visit(el.e.getType());
                        obj.add(jtv.top);
                    }
                }
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            System.out.println("MouseEvent: " + e);
            TreePath tp = InspectPanel.this.tree.getPathForLocation(e.getX(), e.getY());
            if (tp != null) {
                DefaultMutableTreeNode obj = (DefaultMutableTreeNode)tp.getLastPathComponent();
                if (!(obj.getUserObject() instanceof InspectedElement)) {
                    return;
                }
                InspectedElement el = (InspectedElement)obj.getUserObject();
                System.out.println(el);
                if (e.isPopupTrigger() && el.isPointer() && obj.isLeaf()) {
                    InspectPanel.this.tree.setSelectionPath(tp);
                    this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }
}

