/* DEFS: message OutlierStatsMessage{
double stats[];
}
;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_OutlierStatsMessage::operator new(size_t s){
  return OutlierStatsMessage::alloc(__idx, s, 0, 0);
}
void *CMessage_OutlierStatsMessage::operator new(size_t s, int* sz){
  return OutlierStatsMessage::alloc(__idx, s, sz, 0);
}
void *CMessage_OutlierStatsMessage::operator new(size_t s, int* sz,const int pb){
  return OutlierStatsMessage::alloc(__idx, s, sz, pb);
}
void *CMessage_OutlierStatsMessage::operator new(size_t s, int sz0) {
  int sizes[1];
  sizes[0] = sz0;
  return OutlierStatsMessage::alloc(__idx, s, sizes, 0);
}
void *CMessage_OutlierStatsMessage::operator new(size_t s, int sz0, const int p) {
  int sizes[1];
  sizes[0] = sz0;
  return OutlierStatsMessage::alloc(__idx, s, sizes, p);
}
void* CMessage_OutlierStatsMessage::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  int offsets[2];
  offsets[0] = ALIGN8(sz);
  if(sizes==0)
    offsets[1] = offsets[0];
  else
    offsets[1] = offsets[0] + ALIGN8(sizeof(double)*sizes[0]);
  OutlierStatsMessage *newmsg = (OutlierStatsMessage *) CkAllocMsg(msgnum, offsets[1], pb);
  newmsg->stats = (double *) ((char *)newmsg + offsets[0]);
  return (void *) newmsg;
}
void* CMessage_OutlierStatsMessage::pack(OutlierStatsMessage *msg) {
  msg->stats = (double *) ((char *)msg->stats - (char *)msg);
  return (void *) msg;
}
OutlierStatsMessage* CMessage_OutlierStatsMessage::unpack(void* buf) {
  OutlierStatsMessage *msg = (OutlierStatsMessage *) buf;
  msg->stats = (double *) ((size_t)msg->stats + (char *)msg);
  return msg;
}
int CMessage_OutlierStatsMessage::__idx=0;
#endif

/* DEFS: message OutlierWeightMessage;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_OutlierWeightMessage::operator new(size_t s){
  return OutlierWeightMessage::alloc(__idx, s, 0, 0);
}
void *CMessage_OutlierWeightMessage::operator new(size_t s, int* sz){
  return OutlierWeightMessage::alloc(__idx, s, sz, 0);
}
void *CMessage_OutlierWeightMessage::operator new(size_t s, int* sz,const int pb){
  return OutlierWeightMessage::alloc(__idx, s, sz, pb);
}
void *CMessage_OutlierWeightMessage::operator new(size_t s, const int p) {
  return OutlierWeightMessage::alloc(__idx, s, 0, p);
}
void* CMessage_OutlierWeightMessage::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  int offsets[1];
  offsets[0] = ALIGN8(sz);
  OutlierWeightMessage *newmsg = (OutlierWeightMessage *) CkAllocMsg(msgnum, offsets[0], pb);
  return (void *) newmsg;
}
void* CMessage_OutlierWeightMessage::pack(OutlierWeightMessage *msg) {
  return (void *) msg;
}
OutlierWeightMessage* CMessage_OutlierWeightMessage::unpack(void* buf) {
  OutlierWeightMessage *msg = (OutlierWeightMessage *) buf;
  return msg;
}
int CMessage_OutlierWeightMessage::__idx=0;
#endif

/* DEFS: message OutlierThresholdMessage;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_OutlierThresholdMessage::operator new(size_t s){
  return OutlierThresholdMessage::alloc(__idx, s, 0, 0);
}
void *CMessage_OutlierThresholdMessage::operator new(size_t s, int* sz){
  return OutlierThresholdMessage::alloc(__idx, s, sz, 0);
}
void *CMessage_OutlierThresholdMessage::operator new(size_t s, int* sz,const int pb){
  return OutlierThresholdMessage::alloc(__idx, s, sz, pb);
}
void *CMessage_OutlierThresholdMessage::operator new(size_t s, const int p) {
  return OutlierThresholdMessage::alloc(__idx, s, 0, p);
}
void* CMessage_OutlierThresholdMessage::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  int offsets[1];
  offsets[0] = ALIGN8(sz);
  OutlierThresholdMessage *newmsg = (OutlierThresholdMessage *) CkAllocMsg(msgnum, offsets[0], pb);
  return (void *) newmsg;
}
void* CMessage_OutlierThresholdMessage::pack(OutlierThresholdMessage *msg) {
  return (void *) msg;
}
OutlierThresholdMessage* CMessage_OutlierThresholdMessage::unpack(void* buf) {
  OutlierThresholdMessage *msg = (OutlierThresholdMessage *) buf;
  return msg;
}
int CMessage_OutlierThresholdMessage::__idx=0;
#endif

/* DEFS: mainchare TraceProjectionsInit: Chare{
TraceProjectionsInit(CkArgMsg* impl_msg);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_TraceProjectionsInit::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: TraceProjectionsInit(CkArgMsg* impl_msg);
 */
CkChareID CProxy_TraceProjectionsInit::ckNew(CkArgMsg* impl_msg, int impl_onPE)
{
  CkChareID impl_ret;
  CkCreateChare(CkIndex_TraceProjectionsInit::__idx, CkIndex_TraceProjectionsInit::__idx_TraceProjectionsInit_CkArgMsg, impl_msg, &impl_ret, impl_onPE);
  return impl_ret;
}
void CProxy_TraceProjectionsInit::ckNew(CkArgMsg* impl_msg, CkChareID* pcid, int impl_onPE)
{
  CkCreateChare(CkIndex_TraceProjectionsInit::__idx, CkIndex_TraceProjectionsInit::__idx_TraceProjectionsInit_CkArgMsg, impl_msg, pcid, impl_onPE);
}
  CProxy_TraceProjectionsInit::CProxy_TraceProjectionsInit(CkArgMsg* impl_msg, int impl_onPE)
{
  CkChareID impl_ret;
  CkCreateChare(CkIndex_TraceProjectionsInit::__idx, CkIndex_TraceProjectionsInit::__idx_TraceProjectionsInit_CkArgMsg, impl_msg, &impl_ret, impl_onPE);
  ckSetChareID(impl_ret);
}
 int CkIndex_TraceProjectionsInit::__idx_TraceProjectionsInit_CkArgMsg=0;
void CkIndex_TraceProjectionsInit::_call_TraceProjectionsInit_CkArgMsg(void* impl_msg,TraceProjectionsInit * impl_obj)
{
  new (impl_obj) TraceProjectionsInit((CkArgMsg*)impl_msg);
}
#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_TraceProjectionsInit::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterChareInCharm(__idx);
  CkRegisterBase(__idx, CkIndex_Chare::__idx);
// REG: TraceProjectionsInit(CkArgMsg* impl_msg);
  __idx_TraceProjectionsInit_CkArgMsg = CkRegisterEp("TraceProjectionsInit(CkArgMsg* impl_msg)",
     (CkCallFnPtr)_call_TraceProjectionsInit_CkArgMsg, CMessage_CkArgMsg::__idx, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterMainChare(__idx, __idx_TraceProjectionsInit_CkArgMsg);
}
#endif


/* DEFS: readonly CkGroupID traceProjectionsGID;
 */
extern CkGroupID traceProjectionsGID;
#ifndef CK_TEMPLATES_ONLY
extern "C" void __xlater_roPup_traceProjectionsGID(void *_impl_pup_er) {
  PUP::er &_impl_p=*(PUP::er *)_impl_pup_er;
  _impl_p|traceProjectionsGID;
}
#endif

/* DEFS: group TraceProjectionsBOC: IrrGroup{
TraceProjectionsBOC(CkMigrateMessage* impl_msg);
TraceProjectionsBOC(void);
void startOutlierAnalysis(void);
void outlierAverageReduction(CkReductionMsg* impl_msg);
void calculateWeights(OutlierStatsMessage* impl_msg);
void determineOutliers(OutlierWeightMessage* impl_msg);
void setOutliers(OutlierThresholdMessage* impl_msg);
void startEndTimeAnalysis(void);
void endTimeReduction(CkReductionMsg* impl_msg);
void finalReduction(CkReductionMsg* impl_msg);
void shutdownAnalysis(void);
void closeTrace(void);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_TraceProjectionsBOC::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: TraceProjectionsBOC(CkMigrateMessage* impl_msg);
 */

/* DEFS: TraceProjectionsBOC(void);
 */

/* DEFS: void startOutlierAnalysis(void);
 */
void CProxyElement_TraceProjectionsBOC::startOutlierAnalysis(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_startOutlierAnalysis_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_startOutlierAnalysis_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_startOutlierAnalysis_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void outlierAverageReduction(CkReductionMsg* impl_msg);
 */
void CProxyElement_TraceProjectionsBOC::outlierAverageReduction(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_outlierAverageReduction_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_outlierAverageReduction_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_outlierAverageReduction_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void calculateWeights(OutlierStatsMessage* impl_msg);
 */
void CProxyElement_TraceProjectionsBOC::calculateWeights(OutlierStatsMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_calculateWeights_OutlierStatsMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_calculateWeights_OutlierStatsMessage, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_calculateWeights_OutlierStatsMessage, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void determineOutliers(OutlierWeightMessage* impl_msg);
 */
void CProxyElement_TraceProjectionsBOC::determineOutliers(OutlierWeightMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_determineOutliers_OutlierWeightMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_determineOutliers_OutlierWeightMessage, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_determineOutliers_OutlierWeightMessage, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void setOutliers(OutlierThresholdMessage* impl_msg);
 */
void CProxyElement_TraceProjectionsBOC::setOutliers(OutlierThresholdMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_setOutliers_OutlierThresholdMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_setOutliers_OutlierThresholdMessage, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_setOutliers_OutlierThresholdMessage, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void startEndTimeAnalysis(void);
 */
void CProxyElement_TraceProjectionsBOC::startEndTimeAnalysis(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void endTimeReduction(CkReductionMsg* impl_msg);
 */
void CProxyElement_TraceProjectionsBOC::endTimeReduction(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_endTimeReduction_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_endTimeReduction_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_endTimeReduction_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void finalReduction(CkReductionMsg* impl_msg);
 */
void CProxyElement_TraceProjectionsBOC::finalReduction(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_finalReduction_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_finalReduction_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_finalReduction_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void shutdownAnalysis(void);
 */
void CProxyElement_TraceProjectionsBOC::shutdownAnalysis(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_shutdownAnalysis_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_shutdownAnalysis_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_shutdownAnalysis_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void closeTrace(void);
 */
void CProxyElement_TraceProjectionsBOC::closeTrace(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_closeTrace_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_closeTrace_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_closeTrace_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}
/* DEFS: TraceProjectionsBOC(CkMigrateMessage* impl_msg);
 */
 int CkIndex_TraceProjectionsBOC::__idx_TraceProjectionsBOC_CkMigrateMessage=0;
void CkIndex_TraceProjectionsBOC::_call_TraceProjectionsBOC_CkMigrateMessage(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  new (impl_obj) TraceProjectionsBOC((CkMigrateMessage*)impl_msg);
}

/* DEFS: TraceProjectionsBOC(void);
 */
CkGroupID CProxy_TraceProjectionsBOC::ckNew(void)
{
  void *impl_msg = CkAllocSysMsg();
  return CkCreateGroup(CkIndex_TraceProjectionsBOC::__idx, CkIndex_TraceProjectionsBOC::__idx_TraceProjectionsBOC_void, impl_msg);
}
 int CkIndex_TraceProjectionsBOC::__idx_TraceProjectionsBOC_void=0;
void CkIndex_TraceProjectionsBOC::_call_TraceProjectionsBOC_void(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  new (impl_obj) TraceProjectionsBOC();
}

/* DEFS: void startOutlierAnalysis(void);
 */
void CProxy_TraceProjectionsBOC::startOutlierAnalysis(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_startOutlierAnalysis_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_startOutlierAnalysis_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_startOutlierAnalysis_void, impl_msg, ckGetGroupID(),0);
}
    void CProxy_TraceProjectionsBOC::startOutlierAnalysis(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_startOutlierAnalysis_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_TraceProjectionsBOC::__idx_startOutlierAnalysis_void=0;
void CkIndex_TraceProjectionsBOC::_call_startOutlierAnalysis_void(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->startOutlierAnalysis();
}

/* DEFS: void outlierAverageReduction(CkReductionMsg* impl_msg);
 */
void CProxy_TraceProjectionsBOC::outlierAverageReduction(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_outlierAverageReduction_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_outlierAverageReduction_CkReductionMsg, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_outlierAverageReduction_CkReductionMsg, impl_msg, ckGetGroupID(),0);
}
    void CProxy_TraceProjectionsBOC::outlierAverageReduction(CkReductionMsg* impl_msg, int npes, int *pes)
    {
      CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_outlierAverageReduction_CkReductionMsg, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_TraceProjectionsBOC::__idx_outlierAverageReduction_CkReductionMsg=0;
void CkIndex_TraceProjectionsBOC::_call_outlierAverageReduction_CkReductionMsg(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  impl_obj->outlierAverageReduction((CkReductionMsg*)impl_msg);
}

/* DEFS: void calculateWeights(OutlierStatsMessage* impl_msg);
 */
void CProxy_TraceProjectionsBOC::calculateWeights(OutlierStatsMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_calculateWeights_OutlierStatsMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_calculateWeights_OutlierStatsMessage, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_calculateWeights_OutlierStatsMessage, impl_msg, ckGetGroupID(),0);
}
    void CProxy_TraceProjectionsBOC::calculateWeights(OutlierStatsMessage* impl_msg, int npes, int *pes)
    {
      CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_calculateWeights_OutlierStatsMessage, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_TraceProjectionsBOC::__idx_calculateWeights_OutlierStatsMessage=0;
void CkIndex_TraceProjectionsBOC::_call_calculateWeights_OutlierStatsMessage(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  impl_obj->calculateWeights((OutlierStatsMessage*)impl_msg);
}

/* DEFS: void determineOutliers(OutlierWeightMessage* impl_msg);
 */
void CProxy_TraceProjectionsBOC::determineOutliers(OutlierWeightMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_determineOutliers_OutlierWeightMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_determineOutliers_OutlierWeightMessage, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_determineOutliers_OutlierWeightMessage, impl_msg, ckGetGroupID(),0);
}
    void CProxy_TraceProjectionsBOC::determineOutliers(OutlierWeightMessage* impl_msg, int npes, int *pes)
    {
      CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_determineOutliers_OutlierWeightMessage, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_TraceProjectionsBOC::__idx_determineOutliers_OutlierWeightMessage=0;
void CkIndex_TraceProjectionsBOC::_call_determineOutliers_OutlierWeightMessage(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  impl_obj->determineOutliers((OutlierWeightMessage*)impl_msg);
}

/* DEFS: void setOutliers(OutlierThresholdMessage* impl_msg);
 */
void CProxy_TraceProjectionsBOC::setOutliers(OutlierThresholdMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_setOutliers_OutlierThresholdMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_setOutliers_OutlierThresholdMessage, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_setOutliers_OutlierThresholdMessage, impl_msg, ckGetGroupID(),0);
}
    void CProxy_TraceProjectionsBOC::setOutliers(OutlierThresholdMessage* impl_msg, int npes, int *pes)
    {
      CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_setOutliers_OutlierThresholdMessage, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_TraceProjectionsBOC::__idx_setOutliers_OutlierThresholdMessage=0;
void CkIndex_TraceProjectionsBOC::_call_setOutliers_OutlierThresholdMessage(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  impl_obj->setOutliers((OutlierThresholdMessage*)impl_msg);
}

/* DEFS: void startEndTimeAnalysis(void);
 */
void CProxy_TraceProjectionsBOC::startEndTimeAnalysis(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg, ckGetGroupID(),0);
}
    void CProxy_TraceProjectionsBOC::startEndTimeAnalysis(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void=0;
void CkIndex_TraceProjectionsBOC::_call_startEndTimeAnalysis_void(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->startEndTimeAnalysis();
}

/* DEFS: void endTimeReduction(CkReductionMsg* impl_msg);
 */
void CProxy_TraceProjectionsBOC::endTimeReduction(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_endTimeReduction_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_endTimeReduction_CkReductionMsg, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_endTimeReduction_CkReductionMsg, impl_msg, ckGetGroupID(),0);
}
    void CProxy_TraceProjectionsBOC::endTimeReduction(CkReductionMsg* impl_msg, int npes, int *pes)
    {
      CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_endTimeReduction_CkReductionMsg, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_TraceProjectionsBOC::__idx_endTimeReduction_CkReductionMsg=0;
void CkIndex_TraceProjectionsBOC::_call_endTimeReduction_CkReductionMsg(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  impl_obj->endTimeReduction((CkReductionMsg*)impl_msg);
}

/* DEFS: void finalReduction(CkReductionMsg* impl_msg);
 */
void CProxy_TraceProjectionsBOC::finalReduction(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_finalReduction_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_finalReduction_CkReductionMsg, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_finalReduction_CkReductionMsg, impl_msg, ckGetGroupID(),0);
}
    void CProxy_TraceProjectionsBOC::finalReduction(CkReductionMsg* impl_msg, int npes, int *pes)
    {
      CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_finalReduction_CkReductionMsg, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_TraceProjectionsBOC::__idx_finalReduction_CkReductionMsg=0;
void CkIndex_TraceProjectionsBOC::_call_finalReduction_CkReductionMsg(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  impl_obj->finalReduction((CkReductionMsg*)impl_msg);
}

/* DEFS: void shutdownAnalysis(void);
 */
void CProxy_TraceProjectionsBOC::shutdownAnalysis(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_shutdownAnalysis_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_shutdownAnalysis_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_shutdownAnalysis_void, impl_msg, ckGetGroupID(),0);
}
    void CProxy_TraceProjectionsBOC::shutdownAnalysis(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_shutdownAnalysis_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_TraceProjectionsBOC::__idx_shutdownAnalysis_void=0;
void CkIndex_TraceProjectionsBOC::_call_shutdownAnalysis_void(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->shutdownAnalysis();
}

/* DEFS: void closeTrace(void);
 */
void CProxy_TraceProjectionsBOC::closeTrace(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_closeTrace_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_closeTrace_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_closeTrace_void, impl_msg, ckGetGroupID(),0);
}
    void CProxy_TraceProjectionsBOC::closeTrace(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_closeTrace_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_TraceProjectionsBOC::__idx_closeTrace_void=0;
void CkIndex_TraceProjectionsBOC::_call_closeTrace_void(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->closeTrace();
}
#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_TraceProjectionsBOC::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterChareInCharm(__idx);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,TraceProjectionsBOC::isIrreducible());
// REG: TraceProjectionsBOC(CkMigrateMessage* impl_msg);
  __idx_TraceProjectionsBOC_CkMigrateMessage = CkRegisterEp("TraceProjectionsBOC(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_TraceProjectionsBOC_CkMigrateMessage, 0, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterMigCtor(__idx, __idx_TraceProjectionsBOC_CkMigrateMessage);

// REG: TraceProjectionsBOC(void);
  __idx_TraceProjectionsBOC_void = CkRegisterEp("TraceProjectionsBOC(void)",
     (CkCallFnPtr)_call_TraceProjectionsBOC_void, 0, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterDefaultCtor(__idx, __idx_TraceProjectionsBOC_void);

// REG: void startOutlierAnalysis(void);
  __idx_startOutlierAnalysis_void = CkRegisterEp("startOutlierAnalysis(void)",
     (CkCallFnPtr)_call_startOutlierAnalysis_void, 0, __idx, 0+CK_EP_INTRINSIC);

// REG: void outlierAverageReduction(CkReductionMsg* impl_msg);
  __idx_outlierAverageReduction_CkReductionMsg = CkRegisterEp("outlierAverageReduction(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_outlierAverageReduction_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void calculateWeights(OutlierStatsMessage* impl_msg);
  __idx_calculateWeights_OutlierStatsMessage = CkRegisterEp("calculateWeights(OutlierStatsMessage* impl_msg)",
     (CkCallFnPtr)_call_calculateWeights_OutlierStatsMessage, CMessage_OutlierStatsMessage::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void determineOutliers(OutlierWeightMessage* impl_msg);
  __idx_determineOutliers_OutlierWeightMessage = CkRegisterEp("determineOutliers(OutlierWeightMessage* impl_msg)",
     (CkCallFnPtr)_call_determineOutliers_OutlierWeightMessage, CMessage_OutlierWeightMessage::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void setOutliers(OutlierThresholdMessage* impl_msg);
  __idx_setOutliers_OutlierThresholdMessage = CkRegisterEp("setOutliers(OutlierThresholdMessage* impl_msg)",
     (CkCallFnPtr)_call_setOutliers_OutlierThresholdMessage, CMessage_OutlierThresholdMessage::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void startEndTimeAnalysis(void);
  __idx_startEndTimeAnalysis_void = CkRegisterEp("startEndTimeAnalysis(void)",
     (CkCallFnPtr)_call_startEndTimeAnalysis_void, 0, __idx, 0+CK_EP_INTRINSIC);

// REG: void endTimeReduction(CkReductionMsg* impl_msg);
  __idx_endTimeReduction_CkReductionMsg = CkRegisterEp("endTimeReduction(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_endTimeReduction_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void finalReduction(CkReductionMsg* impl_msg);
  __idx_finalReduction_CkReductionMsg = CkRegisterEp("finalReduction(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_finalReduction_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void shutdownAnalysis(void);
  __idx_shutdownAnalysis_void = CkRegisterEp("shutdownAnalysis(void)",
     (CkCallFnPtr)_call_shutdownAnalysis_void, 0, __idx, 0+CK_EP_TRACEDISABLE+CK_EP_INTRINSIC);

// REG: void closeTrace(void);
  __idx_closeTrace_void = CkRegisterEp("closeTrace(void)",
     (CkCallFnPtr)_call_closeTrace_void, 0, __idx, 0+CK_EP_INTRINSIC);
}
#endif

#ifndef CK_TEMPLATES_ONLY
void _registerTraceProjections(void)
{
  static int _done = 0; if(_done) return; _done = 1;
/* REG: message OutlierStatsMessage{
double stats[];
}
;
*/
CMessage_OutlierStatsMessage::__register("OutlierStatsMessage", sizeof(OutlierStatsMessage),(CkPackFnPtr) OutlierStatsMessage::pack,(CkUnpackFnPtr) OutlierStatsMessage::unpack);

/* REG: message OutlierWeightMessage;
*/
CMessage_OutlierWeightMessage::__register("OutlierWeightMessage", sizeof(OutlierWeightMessage),(CkPackFnPtr) OutlierWeightMessage::pack,(CkUnpackFnPtr) OutlierWeightMessage::unpack);

/* REG: message OutlierThresholdMessage;
*/
CMessage_OutlierThresholdMessage::__register("OutlierThresholdMessage", sizeof(OutlierThresholdMessage),(CkPackFnPtr) OutlierThresholdMessage::pack,(CkUnpackFnPtr) OutlierThresholdMessage::unpack);

/* REG: mainchare TraceProjectionsInit: Chare{
TraceProjectionsInit(CkArgMsg* impl_msg);
};
*/
  CkIndex_TraceProjectionsInit::__register("TraceProjectionsInit", sizeof(TraceProjectionsInit));

      _registerInitCall(initTraceProjectionsBOC,1);

  CkRegisterReadonly("traceProjectionsGID","CkGroupID",sizeof(traceProjectionsGID),(void *) &traceProjectionsGID,__xlater_roPup_traceProjectionsGID);

/* REG: group TraceProjectionsBOC: IrrGroup{
TraceProjectionsBOC(CkMigrateMessage* impl_msg);
TraceProjectionsBOC(void);
void startOutlierAnalysis(void);
void outlierAverageReduction(CkReductionMsg* impl_msg);
void calculateWeights(OutlierStatsMessage* impl_msg);
void determineOutliers(OutlierWeightMessage* impl_msg);
void setOutliers(OutlierThresholdMessage* impl_msg);
void startEndTimeAnalysis(void);
void endTimeReduction(CkReductionMsg* impl_msg);
void finalReduction(CkReductionMsg* impl_msg);
void shutdownAnalysis(void);
void closeTrace(void);
};
*/
  CkIndex_TraceProjectionsBOC::__register("TraceProjectionsBOC", sizeof(TraceProjectionsBOC));

}
#endif
