package projector.core;

import projector.gui.*;
import projector.language.*;

import java.io.*;
import java.util.*;
import java.lang.reflect.*;

public class EventIntervalGenerator {
	public int maxLang;
	// for reading projector logs
	TraceReader tReader;
	// Object of any language .
	GeneralEventObject geObj1,geObj2;
	//Array for Interpreters;
	Interpreter [] interpreters;
	String fileName;

	/*Array of languageNames*/
	String [] languageNames;
	EventInterval [] currentInterval;
	Vector[] intervals;

	public EventIntervalGenerator(String fileName){
		this.fileName = fileName;
		tReader = null;
		try{
			tReader = new TraceReader(fileName,"");


		}catch(Exception e){
			System.out.println("Problems with Opening Tracereader");
			System.exit(0);
		}
		maxLang = tReader.getMaxLangs();
		languageNames = tReader.getLanguageNames();
		interpreters = new Interpreter[tReader.getMaxLangs()];
		
		for(int i=1;i< maxLang;i++){
			String className = "Interpreter_"+languageNames[i];
			String packageName =  "projector.language.";
			className = packageName+className;
			try{
				Class cls = Class.forName(className);
				Constructor ctr = cls.getConstructor(null);
				interpreters[i] = (Interpreter) ctr.newInstance(null);
		  }	catch(Exception e){
				System.err.println(e);
				System.exit(-1);
			}
		}
		/*
		interpreters[1] = new ConverseInterpreter();
	  	interpreters[2] = new CharmInterpreter();
	  	interpreters[3] = new MachineInterpreter();
		interpreters[4] = new AmpiInterpreter();*/

		currentInterval = new EventInterval[tReader.getMaxLangs()];
	}

	public Vector [] getIntervals(int pe,double bt,double et){
		boolean teof;
		intervals=null;
	
//		System.out.println("Beginning Time  " + bt+"EndTime " + et);
		try{
		intervals = new Vector[maxLang];
		
		for(int i=0;i<maxLang;i++){
			intervals[i] = new Vector();
			currentInterval[i] = null;
		}
		geObj1 = new GeneralEventObject();
	  geObj2 = new GeneralEventObject();
		geObj1.proc = pe;
		geObj2.proc = pe;
		geObj1.language = 1;
		geObj2.language = 1;
		
		tReader.resetAll(pe);
		
		teof = !tReader.nextGlobalEvent(geObj2,bt);

		Stack beginStack = new Stack();
		Stack beginTimeStack = new Stack();
		Stack intervalStack = new Stack();
		double nextBeginTime=-1,prevEndTime=0;
		EventInterval current_interval=null;
		EventInterval push_interval;
		while(!teof){
			//System.out.println("event "+geObj2.language+" " + geObj2.eventType+" " + geObj2.timestamp);
			teof = !tReader.nextGlobalEvent(geObj2);
			if(interpreters[geObj2.language].isBeginType(geObj2)){
							
				current_interval = new EventInterval(pe,geObj2.timestamp,geObj2.language);
				current_interval.beginObj = geObj2.clone(1);

				//intervalStack.push(current_interval);
				//beginStack.push(stackgeObj);
				currentInterval[current_interval.language] = current_interval;
			}else{
			
				if(interpreters[geObj2.language].isEndType(geObj2)){					
					push_interval = (EventInterval )currentInterval[geObj2.language];
					if(push_interval != null){
						push_interval.endTime = geObj2.timestamp;
						push_interval.executionTime = geObj2.timestamp - push_interval.startTime;
						push_interval.endObj = geObj2.clone(1);
						intervals[push_interval.language].add(push_interval);
						currentInterval[push_interval.language] = null; 
					}
					
				}else{

					if(current_interval != null)
						if(current_interval.language == geObj2.language){
							current_interval.eventVector.add(geObj2.clone(1));
						}else{
							if(currentInterval[geObj2.language]!= null){
								currentInterval[geObj2.language].eventVector.add(geObj2.clone(1));
							}else{
								/**Events outside any interval .. create dummy interval and just add to correct language in intervals array**/
								EventInterval dummy_interval = new EventInterval(pe,geObj2.timestamp,geObj2.language);
								dummy_interval.beginObj = null;
								dummy_interval.endTime = geObj2.timestamp;
								dummy_interval.executionTime = 0.0;
								dummy_interval.endObj = null;
								dummy_interval.eventVector.add(geObj2.clone(1));
								intervals[geObj2.language].add(dummy_interval);
							}

						/*	System.out.println("Event appears to be out of scope in Language "+current_interval.language);
							System.out.println("Event Language " + geObj2.language+" Type "+geObj2.eventType);*/
						}
				}
			}
			if(teof || geObj2.timestamp > et){
				break;
			}	
		}
		}catch(Exception e){
			System.out.println("Exception in intervalgenerator \n"+e);
			e.printStackTrace();
		}

		return 	intervals;
		
	}
	
	public Vector getLanguageIntervals(int language,int pe,double bt,double et){
		Vector intervalVec = new Vector();
		tReader.resetAll(pe);
		Interpreter thisInterpreter = interpreters[language];
		EventInterval current_interval=null;
		
		geObj1 = new GeneralEventObject();
		geObj1.proc = pe;
		geObj1.language = language;


		geObj2 = new GeneralEventObject();
		geObj2.proc = pe;
		geObj2.language = language;
		
		
		try{
		boolean teof = !tReader.nextEvent(geObj2,bt);
		/** Missing events need to be thought out 
				A method to match begin and end event attributes of a language
				should be added to the interpreters and used here
		**/
		while(!teof){
			teof = !tReader.nextEvent(geObj2);
			if(thisInterpreter.isBeginType(geObj2)){
				current_interval = new EventInterval(pe,geObj2.timestamp,language);
				current_interval.beginObj = geObj2.clone(1);
			}else{
				if(thisInterpreter.isEndType(geObj2)){
				    if (current_interval != null) {
					current_interval.endTime = geObj2.timestamp;
					current_interval.executionTime = geObj2.timestamp-current_interval.startTime;
					current_interval.endObj = geObj2.clone(1);
					intervalVec.add(current_interval);
					current_interval = null;
				    }
				}else{
					if(current_interval != null){
						current_interval.eventVector.add(geObj2.clone(1));
					}else{
						EventInterval dummy_interval = new EventInterval(pe,geObj2.timestamp,geObj2.language);
						dummy_interval.beginObj = null;
						dummy_interval.endTime = geObj2.timestamp;
						dummy_interval.executionTime = 0.0;
						dummy_interval.endObj = null;
						dummy_interval.eventVector.add(geObj2.clone(1));
						intervalVec.add(dummy_interval);

					}
				}
			}
			if(teof || geObj2.timestamp > et){
				break;
			}	
		}
		}catch(AbortException e){
			System.err.println(e);
			System.exit(1);
		}
		return intervalVec;
	}

	
	public Interpreter [] getInterpreters(){
		return interpreters;
	}

};
