/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import projections.gui.MainWindow;

public class ColorManager {
    static int myRun = 0;
    private static String filename = null;

    public static void setDefaultLocation(String fname) {
        filename = fname;
    }

    public static Color[][] initializeColors() {
        Color[][] retColors = new Color[4][];
        for (int i = 0; i < retColors.length; ++i) {
            retColors[i] = ColorManager.createColorMap(MainWindow.runObject[myRun].getNumActivity(i));
        }
        return retColors;
    }

    public static Color[][] initializeColors(String filename) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(filename));
        Color[][] retColors = new Color[4][];
        String[] names = null;
        Color[][] tempColors = null;
        int index = 0;
        try {
            int i;
            names = (String[])in.readObject();
            tempColors = (Color[][])in.readObject();
            if (names.length != tempColors.length) {
                System.err.println("WARNING: Color file corrupted. Number of names do not match number of sets of colors.");
                return null;
            }
            for (i = 0; i < tempColors.length; ++i) {
                index = MainWindow.runObject[myRun].stringToActivity(names[i]);
                if (index == -1) continue;
                retColors[index] = tempColors[i];
            }
            for (i = 0; i < retColors.length; ++i) {
                if (retColors[i] != null) continue;
                retColors[i] = ColorManager.createColorMap(MainWindow.runObject[myRun].getNumActivity(i));
            }
        }
        catch (ClassCastException e) {
            in.close();
            int activity = 0;
            retColors[activity] = new Color[MainWindow.runObject[myRun].getNumActivity(activity)];
            ColorManager.loadActivityColors(activity, retColors[activity]);
            for (int i = 0; i < retColors.length; ++i) {
                if (retColors[i] != null) continue;
                retColors[i] = ColorManager.createColorMap(MainWindow.runObject[myRun].getNumActivity(i));
            }
        }
        catch (Exception e) {
            System.err.println("WARNING: Failed to read saved color object");
            System.err.println(e);
            return null;
        }
        in.close();
        return retColors;
    }

    public static void loadActivityColors(int type, Color[] origColors) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(filename));
        Color[][] retColors = null;
        try {
            retColors = (Color[][])in.readObject();
        }
        catch (ClassCastException e) {
            retColors[type] = ColorManager.loadActivityColorsFallback(type);
        }
        catch (Exception e) {
            System.err.println("WARNING: Failed to read saved color object");
            System.err.println(e);
        }
        in.close();
        if (type >= 0 && type < 4) {
            if (origColors.length == retColors[type].length) {
                for (int i = 0; i < origColors.length; ++i) {
                    origColors[i] = retColors[type][i];
                }
            } else {
                System.err.println("WARNING: Current color array length of " + origColors.length + " does not match " + "stored color array length of " + retColors[type].length + ". Load " + "request rejected.");
            }
        } else {
            System.err.println("WARNING - Internal Error: Activity type " + type + " unknown when requesting load " + "colors. Please inform developers");
        }
    }

    public static Color[] loadActivityColorsFallback(int type) throws IOException {
        Color[] retColors = null;
        if (type == 0) {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(filename));
            try {
                retColors = (Color[])in.readObject();
            }
            catch (ClassCastException e) {
                System.err.println("WARNING: Unexpected object format when attempting to read color file");
                System.err.println(e);
                return null;
            }
            catch (Exception e) {
                System.err.println("WARNING: Failed to read saved color object");
                System.err.println(e);
                return null;
            }
            in.close();
        } else {
            retColors = ColorManager.createColorMap(MainWindow.runObject[myRun].getNumActivity(type));
        }
        return retColors;
    }

    public static void saveColors(Color[][] colors) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filename));
            out.writeObject(colors);
            out.close();
        }
        catch (Exception e) {
            System.err.println("WARNING: Failed to save color file to " + filename);
            System.err.println(e);
        }
    }

    public static Color[] createGrayscaleColorMap(int numColors) {
        Color[] colors = new Color[numColors];
        float H = 1.0f;
        float S = 0.0f;
        float B = 0.9f;
        float delta = (float)(0.8 / (double)numColors);
        for (int i = 0; i < numColors; ++i) {
            colors[i] = Color.getHSBColor(H, S, B);
            if (!((double)(B -= delta) < 0.1)) continue;
            B = 0.1f;
        }
        return colors;
    }

    public static Color[] createColorMap(int numColors) {
        Color[] colors = new Color[numColors];
        float H = 1.0f;
        float S = 1.0f;
        float B = 1.0f;
        float delta = (float)(1.0 / (double)numColors);
        for (int i = 0; i < numColors; ++i) {
            colors[i] = Color.getHSBColor(H, S, B);
            if (!((double)(H -= delta) < 0.0)) continue;
            H = 1.0f;
        }
        return colors;
    }

    public static Color[] createColorMap(int numEPs, int[] epMap) {
        int numSignificant = epMap.length;
        int[] weights = new int[numSignificant];
        if (numSignificant > 0) {
            int acceleration = 2;
            int increment = 7;
            weights[numSignificant - 1] = 5;
            for (int ep = numSignificant - 2; ep >= 0; --ep) {
                weights[ep] = weights[ep + 1] + increment;
                increment += acceleration;
            }
        }
        return ColorManager.createColorMap(numEPs, epMap, weights);
    }

    public static Color[] createColorMap(int numEPs, int[] epMap, int[] weights) {
        Color[] colors = new Color[numEPs];
        int numSignificant = epMap.length;
        if (numSignificant == 0) {
            return ColorManager.createColorMap(numEPs);
        }
        int total = 0;
        for (int ep = 0; ep < numSignificant; ++ep) {
            total += weights[ep];
        }
        double k = (double)weights[numSignificant - 1] / (double)total;
        int c = numEPs - numSignificant;
        double x = 1.0 / (k * (double)c + 1.0);
        if (x < 0.67) {
            x = 0.67;
        }
        double currentHue = 1.0;
        double saturation = 1.0;
        double brightness = 1.0;
        for (int ep = 0; ep < numSignificant; ++ep) {
            colors[epMap[ep]] = Color.getHSBColor((float)currentHue, (float)saturation, (float)brightness);
            currentHue -= (double)weights[ep] / (double)total * x;
        }
        double delta = currentHue / (double)c;
        for (int ep = 0; ep < numEPs; ++ep) {
            if (colors[ep] != null) continue;
            colors[ep] = Color.getHSBColor((float)currentHue, (float)saturation, (float)brightness);
            currentHue -= delta;
        }
        return colors;
    }
}

