/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.TextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class FloatTextField
extends TextField
implements TextListener {
    private String lastValue;
    int lastCaretPosition;

    public FloatTextField(float defval, int size) {
        super("" + defval, size);
        this.addTextListener(this);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                char ch = evt.getKeyChar();
                if (!('0' <= ch && ch <= '9' || ch == '.' || Character.isISOControl(ch))) {
                    evt.consume();
                } else {
                    FloatTextField.this.lastCaretPosition = FloatTextField.this.getCaretPosition();
                }
            }
        });
        this.lastValue = "" + defval;
    }

    private void checkValue() {
        try {
            Float.valueOf(this.getText().trim() + "0");
            this.lastValue = this.getText();
        }
        catch (NumberFormatException e) {
            this.setText(this.lastValue);
            this.setCaretPosition(this.lastCaretPosition);
        }
    }

    public float getValue() {
        this.checkValue();
        try {
            return Float.valueOf(this.getText().trim()).floatValue();
        }
        catch (NumberFormatException e) {
            return Float.valueOf(this.lastValue).floatValue();
        }
    }

    public void textValueChanged(TextEvent evt) {
        this.checkValue();
    }
}

