/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import projections.analysis.ProjMain;
import projections.gui.MainWindow;
import projections.gui.MenuManager;

public class MainMenuManager
extends MenuManager
implements ActionListener,
ItemListener {
    private JMenu fileMenu;
    private JMenu preferencesMenu;
    private JMenu toolMenu;
    private static final int NO_DATA = 0;
    private static final int OPENED_FILES = 1;
    private static final int OPENED_SUMMARY = 2;
    private MainWindow parent;

    public MainMenuManager(JFrame parent) {
        super(parent);
        this.parent = (MainWindow)parent;
        this.createMenus();
    }

    void stateChanged(int state) {
        switch (state) {
            case 0: {
                this.setEnabled(this.fileMenu, new boolean[]{true, false, false, false, true});
                this.setEnabled(this.preferencesMenu, new boolean[]{true, true, false, false});
                this.setEnabled(this.toolMenu, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false});
                break;
            }
            case 2: {
                this.setEnabled(this.fileMenu, new boolean[]{true, true, true, false, true});
                this.setEnabled(this.preferencesMenu, new boolean[]{true, true, false, false});
                this.setEnabled(this.toolMenu, new boolean[]{true, false, true, false, false, false, false, false, true, true, false, false, false, true, false, true, true});
                break;
            }
            case 1: {
                this.setEnabled(this.fileMenu, new boolean[]{true, true, true, false, true});
                this.setEnabled(this.preferencesMenu, new boolean[]{true, true, false, false});
                this.setEnabled(this.toolMenu, new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true});
            }
        }
    }

    private void createMenus() {
        this.fileMenu = this.makeJMenu("File", new Object[]{"Open File(s)", "Close current data", "Close all data", null, "Quit"});
        this.menubar.add(this.fileMenu);
        this.preferencesMenu = this.makeJMenu("Preferences", new Object[]{"Change Background Color", "Change Foreground Color", "Use Default Grayscale Colors", "Use Standard Colors"});
        this.menubar.add(this.preferencesMenu);
        this.toolMenu = this.makeJMenu("Tools", MainWindow.windowMenuNames);
        this.menubar.add(this.toolMenu);
        this.stateChanged(0);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)e.getSource();
            String arg = mi.getText();
            if (arg.equals("Open File(s)")) {
                this.parent.showOpenFileDialog();
            }
            if (arg.equals("Close current data")) {
                this.parent.closeCurrent();
            } else if (arg.equals("Close all data")) {
                this.parent.closeAll();
            } else if (arg.equals("Quit")) {
                ProjMain.shutdown(0);
            } else if (arg.equals("Change Background Color")) {
                this.parent.changeBackground();
            } else if (arg.equals("Change Foreground Color")) {
                this.parent.changeForeground();
            } else if (arg.equals("Use Default Grayscale Colors")) {
                this.parent.setGrayscale();
            } else if (arg.equals("Use Standard Colors")) {
                this.parent.setFullColor();
            } else {
                for (int i = 0; i < 18 && i < MainWindow.windowMenuNames.length; ++i) {
                    if (!MainWindow.windowMenuNames[i].equals(arg)) continue;
                    this.parent.showChildWindow(MainWindow.windowClassNames[i], i);
                    break;
                }
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
    }

    public void fileOpened() {
        this.stateChanged(1);
    }

    public void lastFileClosed() {
        this.stateChanged(0);
    }

    public void summaryOnly() {
        this.stateChanged(2);
    }
}

