/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import projections.gui.MainWindow;
import projections.gui.Timeline.Data;

public class UserEventObject
extends JComponent
implements Comparable {
    private static final long serialVersionUID = 1L;
    static int myRun = 0;
    public static final int SINGLE = 1;
    public static final int PAIR = 2;
    public int Type;
    public long BeginTime;
    public long EndTime;
    public int UserEventID;
    public int CharmEventID;
    private Color color;
    public String Name;
    private Data data;
    private int pe;

    public UserEventObject(int pe, long t, int e, int event, int type) {
        this.setFocusable(false);
        this.Type = type;
        this.BeginTime = this.EndTime = t;
        this.UserEventID = e;
        this.CharmEventID = event;
        this.color = MainWindow.runObject[myRun].getUserEventColor(this.UserEventID);
        if (this.color == null) {
            this.color = Color.white;
        }
        this.Name = MainWindow.runObject[myRun].getUserEventName(this.UserEventID);
        this.pe = pe;
    }

    public void setLocationAndSize(Data data, int actualDisplayWidth) {
        this.data = data;
        int leftCoord = data.timeToScreenPixel(this.BeginTime, actualDisplayWidth);
        int rightCoord = data.timeToScreenPixel(this.EndTime, actualDisplayWidth);
        if (this.EndTime > data.endTime()) {
            rightCoord = data.timeToScreenPixel(data.endTime(), actualDisplayWidth) - 5;
        }
        if (this.BeginTime < data.beginTime()) {
            leftCoord = data.timeToScreenPixel(data.beginTime(), actualDisplayWidth) + 5;
        }
        int width = rightCoord - leftCoord + 1;
        int rectHeight = data.userEventRectHeight();
        double yTop = ((double)this.verticalDisplayPosition() + 0.5) * (double)data.singleTimelineHeight() - (double)(data.barheight() / 2) - (double)rectHeight;
        this.setBounds(leftCoord, (int)yTop, width, rectHeight);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.data.showUserEvents()) {
            g.setColor(this.color);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void shiftTimesBy(long shift) {
        this.BeginTime += shift;
        this.EndTime += shift;
    }

    public int compareTo(Object o) {
        UserEventObject ueo = (UserEventObject)o;
        if (this.pe != ueo.pe) {
            return this.pe - ueo.pe;
        }
        return (int)(this.BeginTime - ueo.BeginTime);
    }

    public int verticalDisplayPosition() {
        return this.data.whichTimelineVerticalPosition(this.pe);
    }
}

