/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.ccs.CcsServer;
import charm.ccs.PythonExecute;
import charm.ccs.PythonPrint;
import charm.debug.AllocationGraphDialog;
import charm.debug.AllocationGraphPanel;
import charm.debug.AllocationTreePanel;
import charm.debug.CpdUtil;
import charm.debug.EpCheckBox;
import charm.debug.EpTreeCheckBox;
import charm.debug.EpTreeListener;
import charm.debug.EpTreeRenderer;
import charm.debug.GdbProcess;
import charm.debug.MemoryDialog;
import charm.debug.MemoryPanel;
import charm.debug.MemoryTrace;
import charm.debug.PListOutputArea;
import charm.debug.ParamsDialog;
import charm.debug.PythonDialog;
import charm.debug.PythonIteratorGroup;
import charm.debug.ServThread;
import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;
import charm.debug.inspect.InspectPanel;
import charm.debug.inspect.Inspector;
import charm.debug.pdata.CharePList;
import charm.debug.pdata.ChareTypePList;
import charm.debug.pdata.EpInfo;
import charm.debug.pdata.EpPList;
import charm.debug.pdata.GenericInfo;
import charm.debug.pdata.GenericPList;
import charm.debug.pdata.MsgPList;
import charm.debug.pdata.MsgTypePList;
import charm.debug.pdata.ReadonlyPList;
import charm.debug.preference.CpdFilter;
import charm.debug.preference.Execution;
import charm.debug.preference.Preference;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class ParDebug
extends JPanel
implements ActionListener,
ListSelectionListener {
    private Preference preferences;
    private Execution exec;
    private static String hostnumber;
    private static String envDisplay;
    private static Process sshTunnel;
    public static byte[] globals;
    public static int dataPos;
    static ServThread servthread;
    private static GdbProcess gdb;
    public static CpdUtil server;
    private DefaultListModel listModel;
    private PList listItems = null;
    private boolean isRunning = false;
    private boolean[] peList = null;
    public static int currentListedPE;
    private CharePList groupItems;
    private MsgPList messageQueue;
    private EpPList epItems;
    private MsgTypePList msgItems;
    private ChareTypePList chareItems;
    private HashSet breakpointSet;
    private CpdListInfo[] cpdLists;
    private static JFrame appFrame;
    private JButton startButton;
    private JButton continueButton;
    private JButton stepButton;
    private JButton quitButton;
    private JButton freezeButton;
    private JButton startGdbButton;
    private JPanel peActualPanel;
    private JTextArea programOutputArea;
    private JScrollPane outputAreaScrollPane;
    private InspectPanel outputPanel;
    private PListOutputArea outputArea;
    private JTextArea newOutputArea;
    private JSplitPane bottomSplitPane;
    private JTextField statusArea;
    private JComboBox listsbox;
    private JComboBox pesbox;
    private JList listItemNames;
    private JScrollPane entryScrollPane;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenu menuAction;
    private JMenuItem menuFileOpen;
    private JMenuItem menuFileEdit;
    private JMenuItem menuFileSave;
    private JMenu menuRecent;
    private JMenuItem menuWindowSettings;
    private JMenuItem menuActionStart;
    private JMenuItem menuActionContinue;
    private JMenuItem menuActionQuit;
    private JMenuItem menuActionFreeze;
    private JMenuItem menuActionMemory;
    private JMenuItem menuActionAllocationTree;
    private JMenuItem menuActionAllocationGraph;
    private JMenuItem menuActionPython;
    public static int numberPesGlobal;

    public static String infoCommand(String s) {
        return gdb.infoCommand(s);
    }

    private void abort(String problem) {
        System.out.println(problem);
        System.exit(1);
    }

    private String getEnvDisplay() {
        String displayEnv = null;
        String localip = null;
        try {
            localip = InetAddress.getLocalHost().getHostAddress();
            displayEnv = localip + ":0.0";
            System.out.println("DISPLAY variable = " + displayEnv);
        }
        catch (Exception exc) {
            this.abort("Error retrieving IP address for DISPLAY variable: " + exc.getMessage());
        }
        return displayEnv;
    }

    public void displayProgramOutput(String line) {
        this.programOutputArea.append(line);
        this.programOutputArea.scrollRectToVisible(new Rectangle(0, this.programOutputArea.getHeight() - 2, 1, 1));
    }

    private void addedRunParameter() {
        this.setStatusMessage("Executable: " + this.exec.executable + "        number of pes: " + this.exec.npes);
    }

    private void loadedRunParameter() {
        this.setStatusMessage("Loaded configuration => Executable: " + this.exec.executable + "     number of pes: " + this.exec.npes);
    }

    private void savedRunParameter(String file) {
        this.setStatusMessage("Saved current configuration to file  " + file);
    }

    public void setStatusMessage(String txt) {
        this.statusArea.setText(txt);
    }

    public void notifyBreakpoint(String txt) {
        this.stepButton.setEnabled(true);
        this.continueButton.setEnabled(true);
        this.freezeButton.setEnabled(false);
        CpdListInfo list = this.cpdLists[this.listsbox.getSelectedIndex()];
        if (list.list == this.messageQueue) {
            int forPE = Integer.parseInt((String)this.pesbox.getSelectedItem());
            this.populateNewList(this.listsbox.getSelectedIndex(), forPE, this.listModel);
        }
        this.setStatusMessage(txt);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferences.size != null) {
            return this.preferences.size;
        }
        return super.getPreferredSize();
    }

    public Point getPreferredLocation() {
        return this.preferences.location;
    }

    private void populateNewList(int cpdListIndex, int forPE, DefaultListModel dest) {
        dest.removeAllElements();
        this.outputArea.setList(null);
        this.newOutputArea.setText("");
        this.listItems = null;
        String lName = this.cpdLists[cpdListIndex].name;
        if (lName == null) {
            return;
        }
        GenericPList list = this.cpdLists[cpdListIndex].list;
        if (list == null || list.needRefresh()) {
            int nItems = server.getListLength(lName, forPE);
            this.listItems = server.getPList(lName, forPE, 0, nItems);
        }
        if (list != null) {
            if (list.needRefresh()) {
                list.load(this.listItems);
            }
            list.populate(dest);
        } else {
            for (PAbstract cur = this.listItems.elementAt(0); cur != null; cur = cur.getNext()) {
                dest.addElement(cur.getDeepName());
            }
        }
    }

    private void expandListElement(int cpdListIndex, int forPE, int listItem) {
        currentListedPE = forPE;
        String detailedName = this.cpdLists[cpdListIndex].detailedName;
        int position = this.bottomSplitPane.getDividerLocation();
        if (detailedName == null) {
            if (this.cpdLists[cpdListIndex].list != null) {
                this.bottomSplitPane.setRightComponent(this.outputPanel);
                this.bottomSplitPane.setDividerLocation(position);
                Object selected = this.listItemNames.getSelectedValue();
                if (selected instanceof GenericInfo) {
                    ((GenericInfo)selected).getDetails(this.outputPanel);
                } else {
                    System.out.println("Error: element not of type GenericInfo");
                }
            } else {
                this.bottomSplitPane.setRightComponent(this.outputAreaScrollPane);
                this.bottomSplitPane.setDividerLocation(position);
                this.outputArea.setList((PList)this.listItems.elementAt(listItem));
            }
        } else {
            this.bottomSplitPane.setRightComponent(this.outputAreaScrollPane);
            this.bottomSplitPane.setDividerLocation(position);
            PList detailList = server.getPList(detailedName, forPE, listItem, listItem + 1);
            this.outputArea.setList(detailList);
        }
    }

    private void listenTo(JMenuItem m, String command, String toolTip) {
        if (toolTip != null) {
            m.setToolTipText(toolTip);
        }
        m.setActionCommand(command);
        m.addActionListener(this);
    }

    public ParDebug(Execution e) {
        CpdListInfo[] cpdListInfoArray = new CpdListInfo[11];
        cpdListInfoArray[0] = new CpdListInfo("-- Display --", null, null, null);
        this.groupItems = new CharePList();
        cpdListInfoArray[1] = new CpdListInfo("Charm Objects", "charm/objectNames", null, this.groupItems);
        cpdListInfoArray[2] = new CpdListInfo("Array Elements", "charm/arrayElements", null, new CharePList());
        this.messageQueue = new MsgPList();
        cpdListInfoArray[3] = new CpdListInfo("Messages in Queue", "converse/localqueue", null, this.messageQueue);
        cpdListInfoArray[4] = new CpdListInfo("Readonly Variables", "charm/readonly", null, new ReadonlyPList());
        cpdListInfoArray[5] = new CpdListInfo("Readonly Messages", "charm/readonlyMsg", null, null);
        this.epItems = new EpPList();
        cpdListInfoArray[6] = new CpdListInfo("Entry Points", "charm/entries", null, this.epItems);
        this.chareItems = new ChareTypePList();
        cpdListInfoArray[7] = new CpdListInfo("Chare Types", "charm/chares", null, this.chareItems);
        this.msgItems = new MsgTypePList();
        cpdListInfoArray[8] = new CpdListInfo("Message Types", "charm/messages", null, this.msgItems);
        cpdListInfoArray[9] = new CpdListInfo("Mainchares", "charm/mains", null, null);
        cpdListInfoArray[10] = new CpdListInfo("Viewable Lists", "converse/lists", null, null);
        this.cpdLists = cpdListInfoArray;
        this.isRunning = false;
        this.preferences = new Preference();
        this.preferences.load();
        this.exec = e;
        this.breakpointSet = new HashSet();
        this.setLayout(new BoxLayout(this, 1));
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.menuBar.add(this.menuFile);
        this.menuFile.setMnemonic('F');
        this.menuFileOpen = new JMenuItem("Open Configuration", 79);
        this.menuFile.add(this.menuFileOpen);
        this.listenTo(this.menuFileOpen, "openConf", "Open the configuration of a parallel program to debug");
        this.menuFileEdit = new JMenuItem("Edit Configuration", 69);
        this.menuFile.add(this.menuFileEdit);
        this.listenTo(this.menuFileEdit, "editConf", "Edit the parameters for the current configuration");
        this.menuFileSave = new JMenuItem("Save Configuration", 83);
        this.menuFile.add(this.menuFileSave);
        this.listenTo(this.menuFileSave, "saveConf", "Save the current configuration");
        this.menuRecent = new JMenu("Recent Configurations");
        this.menuFile.add(this.menuRecent);
        this.updateRecentConfig();
        this.menuFile.addSeparator();
        this.menuWindowSettings = new JMenuItem("Save Window Settings", 87);
        this.menuFile.add(this.menuWindowSettings);
        this.listenTo(this.menuWindowSettings, "saveWindowSet", "Save the current window settings");
        JMenuItem menuFileExit = new JMenuItem("Exit Debugger", 88);
        this.menuFile.add(menuFileExit);
        this.listenTo(menuFileExit, "exitDebugger", null);
        this.menuAction = new JMenu("Action");
        this.menuBar.add(this.menuAction);
        this.menuAction.setMnemonic('A');
        this.menuActionStart = new JMenuItem("Start", 83);
        this.menuAction.add(this.menuActionStart);
        this.listenTo(this.menuActionStart, "begin", "Start the parallel program");
        this.menuActionContinue = new JMenuItem("Continue", 67);
        this.menuAction.add(this.menuActionContinue);
        this.listenTo(this.menuActionContinue, "unfreeze", "Continue to run the parallel program");
        this.menuActionFreeze = new JMenuItem("Freeze", 70);
        this.menuAction.add(this.menuActionFreeze);
        this.listenTo(this.menuActionFreeze, "freeze", "Freeze the parallel program");
        this.menuActionQuit = new JMenuItem("Quit", 81);
        this.menuAction.add(this.menuActionQuit);
        this.listenTo(this.menuActionQuit, "quit", "Quit the parallel program");
        this.menuAction.addSeparator();
        this.menuActionMemory = new JMenuItem("Memory", 77);
        this.menuAction.add(this.menuActionMemory);
        this.listenTo(this.menuActionMemory, "memory", "Inspect the application memory");
        this.menuActionAllocationTree = new JMenuItem("Memory Allocation Tree", 84);
        this.menuAction.add(this.menuActionAllocationTree);
        this.listenTo(this.menuActionAllocationTree, "allocationTree", "Print the memory allocation tree");
        this.menuActionAllocationGraph = new JMenuItem("Memory Allocation Graph", 71);
        this.menuAction.add(this.menuActionAllocationGraph);
        this.listenTo(this.menuActionAllocationGraph, "allocationGraph", "Print the memory allocation graph");
        this.menuActionPython = new JMenuItem("Python script", 80);
        this.menuAction.add(this.menuActionPython);
        this.listenTo(this.menuActionPython, "python", "Run python script on application");
        this.statusArea = new JTextField(60);
        this.statusArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.statusArea.setMaximumSize(new Dimension(1000000, 40));
        this.statusArea.setEditable(false);
        this.statusArea.setBackground(Color.lightGray);
        JPanel middlePanel = new JPanel();
        middlePanel.setLayout(new BoxLayout(middlePanel, 0));
        this.entryScrollPane = new JScrollPane();
        this.entryScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Set Break Points"), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        this.entryScrollPane.setPreferredSize(new Dimension(200, 380));
        JPanel secondPanelWithOutput = new JPanel();
        secondPanelWithOutput.setLayout(new BoxLayout(secondPanelWithOutput, 1));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Control Buttons"), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        buttonPanel.setPreferredSize(new Dimension(500, 80));
        this.startButton = new JButton("Start");
        this.startButton.setVerticalTextPosition(0);
        this.startButton.setHorizontalTextPosition(2);
        this.startButton.setMnemonic(83);
        this.startButton.setActionCommand("begin");
        this.startButton.setEnabled(true);
        this.startButton.setToolTipText("Run the parallel program from scratch.");
        this.startButton.addActionListener(this);
        this.startButton.setPreferredSize(new Dimension(100, 80));
        this.stepButton = new JButton("Step");
        this.stepButton.setVerticalTextPosition(3);
        this.stepButton.setHorizontalTextPosition(0);
        this.stepButton.setMnemonic(80);
        this.stepButton.setActionCommand("step");
        this.stepButton.setEnabled(false);
        this.stepButton.setToolTipText("Deliver a single message.");
        this.stepButton.addActionListener(this);
        this.stepButton.setPreferredSize(new Dimension(100, 80));
        this.continueButton = new JButton("Continue");
        this.continueButton.setVerticalTextPosition(3);
        this.continueButton.setHorizontalTextPosition(0);
        this.continueButton.setMnemonic(85);
        this.continueButton.setActionCommand("unfreeze");
        this.continueButton.setEnabled(false);
        this.continueButton.setToolTipText("Resume execution.");
        this.continueButton.addActionListener(this);
        this.continueButton.setPreferredSize(new Dimension(100, 80));
        this.freezeButton = new JButton("Freeze");
        this.freezeButton.setVerticalTextPosition(3);
        this.freezeButton.setHorizontalTextPosition(0);
        this.freezeButton.setActionCommand("freeze");
        this.freezeButton.setEnabled(false);
        this.freezeButton.setToolTipText("Stop execution.");
        this.freezeButton.addActionListener(this);
        this.freezeButton.setPreferredSize(new Dimension(100, 80));
        this.quitButton = new JButton("Quit");
        this.quitButton.setVerticalTextPosition(3);
        this.quitButton.setHorizontalTextPosition(0);
        this.quitButton.setMnemonic(81);
        this.quitButton.setActionCommand("quit");
        this.quitButton.setEnabled(false);
        this.quitButton.setToolTipText("End the program.");
        this.quitButton.addActionListener(this);
        this.quitButton.setPreferredSize(new Dimension(100, 80));
        this.startGdbButton = new JButton("Start GDB");
        this.startGdbButton.setVerticalTextPosition(3);
        this.startGdbButton.setHorizontalTextPosition(0);
        this.startGdbButton.setActionCommand("startgdb");
        this.startGdbButton.setEnabled(false);
        this.startGdbButton.setToolTipText("Start gdb on selected processors.");
        this.startGdbButton.addActionListener(this);
        this.startGdbButton.setPreferredSize(new Dimension(100, 80));
        buttonPanel.add(this.startButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.stepButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.continueButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.freezeButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.quitButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.startGdbButton);
        JPanel outputAndPePanel = new JPanel();
        outputAndPePanel.setLayout(new BoxLayout(outputAndPePanel, 0));
        this.programOutputArea = new JTextArea();
        this.programOutputArea.setColumns(100);
        this.programOutputArea.setLineWrap(true);
        JScrollPane programOutputScrollPane = new JScrollPane(this.programOutputArea);
        programOutputScrollPane.setBorder(BorderFactory.createTitledBorder("Program Output"));
        programOutputScrollPane.setPreferredSize(new Dimension(350, 300));
        JPanel pePanel = new JPanel();
        pePanel.setLayout(new BoxLayout(pePanel, 1));
        pePanel.setPreferredSize(new Dimension(50, 380));
        this.peActualPanel = new JPanel();
        this.peActualPanel.setLayout(new BoxLayout(this.peActualPanel, 1));
        JScrollPane pesScrollPane = new JScrollPane(this.peActualPanel);
        pesScrollPane.setBorder(BorderFactory.createTitledBorder("Pes"));
        pePanel.add(pesScrollPane);
        outputAndPePanel.add(programOutputScrollPane);
        outputAndPePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        outputAndPePanel.add(pePanel);
        outputAndPePanel.setPreferredSize(new Dimension(500, 300));
        secondPanelWithOutput.add(buttonPanel);
        secondPanelWithOutput.add(Box.createRigidArea(new Dimension(0, 5)));
        secondPanelWithOutput.add(outputAndPePanel);
        secondPanelWithOutput.setPreferredSize(new Dimension(500, 380));
        JSplitPane middleSplitPane = new JSplitPane(1, this.entryScrollPane, secondPanelWithOutput);
        middleSplitPane.setResizeWeight(0.5);
        middlePanel.add(middleSplitPane);
        middlePanel.setPreferredSize(new Dimension(600, 380));
        this.add(middlePanel);
        JPanel panelForComboBoxes = new JPanel();
        panelForComboBoxes.setLayout(new BoxLayout(panelForComboBoxes, 0));
        panelForComboBoxes.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("View Entities on PE"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        String[] displayStrings = new String[this.cpdLists.length];
        for (int i = 0; i < this.cpdLists.length; ++i) {
            displayStrings[i] = this.cpdLists[i].display;
        }
        this.listsbox = new JComboBox<String>(displayStrings);
        this.listsbox.setActionCommand("lists");
        this.listsbox.addActionListener(this);
        this.listsbox.setEnabled(false);
        this.listsbox.setPreferredSize(new Dimension(450, 70));
        this.pesbox = new JComboBox();
        this.pesbox.setActionCommand("changepe");
        this.pesbox.addActionListener(this);
        this.pesbox.setEnabled(false);
        this.pesbox.setPreferredSize(new Dimension(100, 70));
        panelForComboBoxes.add(this.listsbox);
        panelForComboBoxes.add(Box.createRigidArea(new Dimension(50, 70)));
        panelForComboBoxes.add(this.pesbox);
        panelForComboBoxes.setPreferredSize(new Dimension(600, 70));
        this.add(panelForComboBoxes);
        JPanel panelForEntities = new JPanel();
        panelForEntities.setLayout(new BoxLayout(panelForEntities, 0));
        panelForEntities.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        panelForEntities.setPreferredSize(new Dimension(600, 230));
        this.listModel = new DefaultListModel();
        this.listItemNames = new JList(this.listModel);
        this.listItemNames.setSelectionMode(0);
        this.listItemNames.addListSelectionListener(this);
        JScrollPane listScrollPane = new JScrollPane(this.listItemNames);
        listScrollPane.setBorder(BorderFactory.createTitledBorder("Entities"));
        this.outputArea = new PListOutputArea();
        this.newOutputArea = new JTextArea();
        this.newOutputArea.setEditable(false);
        this.newOutputArea.setBackground(this.outputArea.getBackground());
        this.newOutputArea.setLineWrap(true);
        this.newOutputArea.setWrapStyleWord(true);
        this.outputAreaScrollPane = new JScrollPane(this.outputArea);
        this.outputAreaScrollPane.setHorizontalScrollBarPolicy(31);
        this.outputAreaScrollPane.setBorder(BorderFactory.createTitledBorder("Details"));
        this.outputPanel = new InspectPanel();
        this.outputPanel.setBorder(BorderFactory.createTitledBorder("Details"));
        this.bottomSplitPane = new JSplitPane(1, listScrollPane, this.outputPanel);
        this.bottomSplitPane.setOneTouchExpandable(true);
        panelForEntities.add(this.bottomSplitPane);
        this.add(panelForEntities);
        this.add(this.statusArea);
        gdb = new GdbProcess(this);
        this.addedRunParameter();
    }

    public void updateRecentConfig() {
        Object[] files = this.preferences.getRecent();
        this.menuRecent.removeAll();
        if (files.length > 0) {
            this.menuRecent.setEnabled(true);
            for (int i = 0; i < files.length; ++i) {
                JMenuItem item = new JMenuItem((String)files[i]);
                this.listenTo(item, "openRecent", null);
                this.menuRecent.add(item);
            }
        } else {
            this.menuRecent.setEnabled(false);
        }
    }

    public void loadConfigFile(File filename) {
        try {
            this.exec = Execution.load(filename);
        }
        catch (IOException ioe) {
            this.setStatusMessage("Failed to load configuration file");
            return;
        }
        catch (ClassNotFoundException cnfe) {
            this.setStatusMessage("Configuration file corrupted");
            return;
        }
        this.loadedRunParameter();
        this.preferences.addRecent(this.exec.locationOnDisk);
        this.updateRecentConfig();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("openConf")) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            chooser.addChoosableFileFilter(new CpdFilter());
            chooser.setAcceptAllFileFilterUsed(false);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.loadConfigFile(chooser.getSelectedFile());
            }
        } else if (e.getActionCommand().equals("editConf")) {
            ParamsDialog dialogbox = new ParamsDialog((Frame)appFrame, true, this.exec);
            dialogbox.setLocationRelativeTo(appFrame);
            dialogbox.pack();
            dialogbox.setVisible(true);
        } else if (e.getActionCommand().equals("saveConf")) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            chooser.addChoosableFileFilter(new CpdFilter());
            chooser.setAcceptAllFileFilterUsed(false);
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                int response;
                File filename = chooser.getSelectedFile();
                if (!filename.getName().endsWith(".cpd")) {
                    filename = new File(filename.getAbsolutePath() + ".cpd");
                }
                if (filename.exists() && (response = JOptionPane.showConfirmDialog(this, "Do you want to overwrite the file?", "File overwrite", 0)) != 0) {
                    this.setStatusMessage("Save aborted");
                    return;
                }
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(filename));
                    oos.writeObject(this.exec);
                    oos.close();
                }
                catch (IOException ioe) {
                    this.setStatusMessage("Failed to save configuration file");
                    return;
                }
                this.savedRunParameter(filename.getAbsolutePath());
                this.exec.locationOnDisk = filename.getAbsolutePath();
                this.preferences.addRecent(this.exec.locationOnDisk);
                this.updateRecentConfig();
            }
        } else if (e.getActionCommand().equals("openRecent")) {
            JMenuItem item = (JMenuItem)e.getSource();
            String filename = item.getText();
            System.out.println("Loading configuration file: " + filename);
            this.loadConfigFile(new File(filename));
        } else if (e.getActionCommand().equals("saveWindowSet")) {
            this.preferences.location = this.getParent().getLocationOnScreen();
            this.preferences.size = this.getParent().getSize();
        } else if (e.getActionCommand().equals("begin")) {
            this.startProgram();
        } else if (e.getActionCommand().equals("freeze")) {
            server.bcastCcsRequest("ccs_debug", "freeze", 1, this.exec.npes, this.peList);
            this.stepButton.setEnabled(true);
            this.continueButton.setEnabled(true);
            this.freezeButton.setEnabled(false);
            this.setStatusMessage("Program is frozen on selected pes");
        } else if (e.getActionCommand().equals("unfreeze")) {
            server.bcastCcsRequest("ccs_continue_break_point", "", 0, this.exec.npes, this.peList);
            this.stepButton.setEnabled(true);
            this.continueButton.setEnabled(true);
            this.freezeButton.setEnabled(true);
            this.setStatusMessage("Program is running");
        } else if (e.getActionCommand().equals("step")) {
            server.bcastCcsRequest("ccs_single_step", "", 0, this.exec.npes, this.peList);
            CpdListInfo list = this.cpdLists[this.listsbox.getSelectedIndex()];
            if (list.list == this.messageQueue) {
                int forPE = Integer.parseInt((String)this.pesbox.getSelectedItem());
                this.populateNewList(this.listsbox.getSelectedIndex(), forPE, this.listModel);
            }
            this.setStatusMessage("Single message delivered");
        } else if (e.getActionCommand().equals("quit")) {
            server.bcastCcsRequest("ccs_debug_quit", "", 0, this.exec.npes, this.peList);
            this.quitProgram();
        } else if (e.getActionCommand().equals("startgdb")) {
            server.bcastCcsRequest("ccs_remove_all_break_points", "", 0, this.exec.npes, this.peList);
            for (int i = 0; i < this.exec.npes; ++i) {
                if (!this.peList[i]) continue;
                PList pl = server.getPList("hostinfo", i);
                PList cur = (PList)pl.elementAt(0);
                byte[] addr = ((PString)cur.elementNamed("address")).getBytes();
                int[] address = new int[4];
                for (int j = 0; j < 4; ++j) {
                    address[j] = addr[j];
                    if (address[j] >= 0) continue;
                    int n = j;
                    address[n] = address[n] + 256;
                }
                int pid = ((PNative)cur.elementNamed("pid")).getIntValue(0);
                String sshCommand = null;
                String[] str = null;
                String ipAddress = address[0] + "." + address[1] + "." + address[2] + "." + address[3];
                String script = "ssh " + ipAddress + " \"cat > /tmp/start_gdb." + pid + " << END_OF_SCRIPT\n" + "shell /bin/rm -f /tmp/start_gdb." + pid + "\n" + "handle SIGWINCH nostop noprint\n" + "handle SIGWAITING nostop noprint\n" + "attach " + pid + "\n" + "END_OF_SCRIPT\n" + "gdb " + new File(this.exec.executable).getAbsolutePath() + " -x /tmp/start_gdb." + pid + "\"";
                if (!this.exec.hostname.equals("localhost")) {
                    sshCommand = "ssh -T " + this.exec.hostname + " ssh -T";
                    str = new String[9];
                    str[5] = this.exec.hostname;
                    str[6] = "ssh";
                    str[7] = ipAddress;
                    str[8] = script;
                } else {
                    sshCommand = "ssh -T";
                    str = new String[7];
                    str[5] = ipAddress;
                    str[6] = script;
                }
                str[0] = "xterm";
                str[1] = "-title";
                str[2] = "Node " + i;
                str[3] = "-e";
                str[4] = "/bin/bash";
                str[5] = "-c";
                for (int k = 0; k < str.length; ++k) {
                    System.out.print(str[k] + " ");
                }
                System.out.println();
                try {
                    Runtime.getRuntime().exec(str);
                    continue;
                }
                catch (Exception e1) {
                    System.err.println(e);
                }
            }
            this.setStatusMessage("Gdb started on selected pes");
        } else if (e.getActionCommand().equals("breakpoints")) {
            EpCheckBox chkbox = (EpCheckBox)e.getSource();
            int breakpointIndex = chkbox.ep.getEpIndex();
            String entryPointName = "" + breakpointIndex;
            if (chkbox.isSelected()) {
                this.breakpointSet.add(new Integer(breakpointIndex));
                server.bcastCcsRequest("ccs_set_break_point", entryPointName, 0, this.exec.npes, this.peList);
                this.stepButton.setEnabled(true);
                this.continueButton.setEnabled(true);
                this.freezeButton.setEnabled(false);
                this.setStatusMessage("Break Point set at entry point " + entryPointName);
            } else {
                this.breakpointSet.remove(new Integer(breakpointIndex));
                server.bcastCcsRequest("ccs_remove_break_point", entryPointName, 0, this.exec.npes, this.peList);
                this.stepButton.setEnabled(true);
                this.continueButton.setEnabled(true);
                this.freezeButton.setEnabled(true);
                this.setStatusMessage("Break Point removed at entry point " + entryPointName + " on selected Pes");
            }
            CpdListInfo list = this.cpdLists[this.listsbox.getSelectedIndex()];
            if (list.list == this.messageQueue) {
                int forPE = Integer.parseInt((String)this.pesbox.getSelectedItem());
                this.populateNewList(this.listsbox.getSelectedIndex(), forPE, this.listModel);
            }
        } else if (e.getActionCommand().equals("memory")) {
            MemoryDialog input = new MemoryDialog((Frame)appFrame, true, this.exec.npes);
            if (input.confirmed()) {
                MemoryPanel memory;
                JFrame frame = new JFrame("Memory visualization");
                frame.setDefaultCloseOperation(2);
                MemoryPanel newContentPane = memory = new MemoryPanel();
                newContentPane.setOpaque(true);
                frame.setContentPane(newContentPane);
                memory.loadData(input);
                frame.setTitle("Memory Processor " + input.getPe());
                frame.setJMenuBar(memory.getMenu());
                frame.pack();
                frame.setVisible(true);
            }
        } else if (e.getActionCommand().equals("allocationTree")) {
            AllocationTreePanel at;
            JFrame frame = new JFrame("Allocation Tree");
            frame.setDefaultCloseOperation(2);
            AllocationTreePanel newContentPane = at = new AllocationTreePanel();
            newContentPane.setOpaque(true);
            frame.setContentPane(newContentPane);
            frame.setTitle("Allocation Tree");
            at.loadTree(frame);
            frame.pack();
            frame.setVisible(true);
        } else if (e.getActionCommand().equals("allocationGraph")) {
            AllocationGraphDialog input = new AllocationGraphDialog((Frame)appFrame, true, this.exec.npes);
            if (input.confirmed()) {
                AllocationGraphPanel at;
                JFrame frame = new JFrame("Allocation Graph");
                frame.setDefaultCloseOperation(2);
                AllocationGraphPanel newContentPane = at = new AllocationGraphPanel();
                newContentPane.setOpaque(true);
                frame.setContentPane(newContentPane);
                frame.setTitle("Allocation Graph");
                String executable = new File(this.exec.executable).getAbsolutePath();
                String logFile = new File(executable).getParent();
                if (logFile == null) {
                    logFile = ".";
                }
                logFile = logFile + "/memoryLog_";
                at.load(frame, new MemoryTrace(logFile, this.exec.npes), input);
                frame.setJMenuBar(at.getMenu());
                frame.pack();
                frame.setVisible(true);
            }
        } else if (e.getActionCommand().equals("python")) {
            PythonDialog input = new PythonDialog(appFrame, true, this.groupItems, this.chareItems, gdb, server);
            if (input.confirmed()) {
                PythonExecute code = new PythonExecute(input.getText(), "method", new PythonIteratorGroup(input.getChareGroup()), false, true, 0);
                code.setKeepPrint(true);
                code.setWait(true);
                System.out.println("Sending python request " + (code.isHighLevel() ? " highlevel" : "") + (code.isKeepPrint() ? " keepPrint" : "") + (code.isKeepWait() ? " keepWait" : "") + (code.isPersistent() ? " persistent" : "") + (code.isIterate() ? " iterative" : ""));
                byte[] reply = server.sendCcsRequestBytes("CpdPythonGroup", code.pack(), 0, true);
                if (reply.length == 0) {
                    System.out.println("The python module was not linked in the application");
                    return;
                }
                int interpreterHandle = CcsServer.readInt(reply, 0);
                System.out.println("Python interpreter: " + interpreterHandle);
                PythonPrint print = new PythonPrint(interpreterHandle, true);
                byte[] output = server.sendCcsRequestBytes("CpdPythonGroup", print.pack(), 0, true);
                System.out.println("Python printed: " + new String(output));
            }
        } else if (e.getActionCommand().equals("pecheck")) {
            JCheckBox chkbox = (JCheckBox)e.getSource();
            String peText = chkbox.getText();
            String peno = peText.substring(3);
            this.peList[Integer.parseInt((String)peno)] = chkbox.isSelected();
        } else if (e.getActionCommand().equals("lists") || e.getActionCommand().equals("changepe")) {
            if (this.pesbox.getSelectedItem() != null) {
                int forPE = Integer.parseInt((String)this.pesbox.getSelectedItem());
                this.populateNewList(this.listsbox.getSelectedIndex(), forPE, this.listModel);
            }
        } else if (e.getActionCommand().equals("exitDebugger")) {
            if (this.isRunning) {
                server.bcastCcsRequest("ccs_debug_quit", "", 0, this.exec.npes, this.peList);
                this.quitProgram();
            }
            this.preferences.save();
            System.exit(0);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        JList theList = (JList)e.getSource();
        if (theList == this.listItemNames && !theList.isSelectionEmpty()) {
            int forPE = Integer.parseInt((String)this.pesbox.getSelectedItem());
            this.expandListElement(this.listsbox.getSelectedIndex(), forPE, theList.getSelectedIndex());
        }
    }

    public void startProgram() {
        gdb.terminate();
        this.isRunning = true;
        this.programOutputArea.setText("");
        String executable = new File(this.exec.executable).getAbsolutePath();
        String charmrunDir = new File(executable).getParent();
        if (charmrunDir == null) {
            charmrunDir = ".";
        }
        String charmrunPath = charmrunDir + "/charmrun";
        if (envDisplay.length() == 0) {
            envDisplay = this.getEnvDisplay();
        }
        numberPesGlobal = this.exec.npes;
        String totCommandLine = charmrunPath + " " + "+p" + this.exec.npes + " " + executable + " " + this.exec.parameters + "  +cpd +DebugDisplay " + envDisplay + " ++server";
        if (this.exec.port.length() != 0) {
            totCommandLine = totCommandLine + " ++server-port " + this.exec.port;
        }
        if (!this.exec.hostname.equals("localhost")) {
            if (this.exec.username.length() > 0) {
                totCommandLine = "-l " + this.exec.username + " " + totCommandLine;
            }
            totCommandLine = "ssh " + this.exec.hostname + " " + totCommandLine;
        }
        System.out.println("ParDebug> " + totCommandLine);
        this.programOutputArea.setText(totCommandLine);
        Process p = null;
        Runtime runtime = null;
        runtime = Runtime.getRuntime();
        try {
            p = runtime.exec(totCommandLine);
        }
        catch (Exception exc) {
            System.out.println("ParDebug> Error executing " + totCommandLine);
            this.quitProgram();
            return;
        }
        servthread = new ServThread(this, p);
        servthread.start();
        while (servthread.getFlag() == 0) {
        }
        if (servthread.getFlag() != 1) {
            this.setStatusMessage("Failed to start program");
            return;
        }
        try {
            String initialInfo = this.getInitialInfo();
            int dataInitial = initialInfo.indexOf("\n.data ");
            int dataFinal = initialInfo.indexOf("\n", dataInitial + 1);
            String dataValues = initialInfo.substring(dataInitial + 6, dataFinal).trim();
            int endSize = dataValues.indexOf(32);
            int startPos = dataValues.lastIndexOf(32);
            int dataSize = Integer.parseInt(dataValues.substring(0, endSize));
            dataPos = Integer.parseInt(dataValues.substring(startPos + 1));
            int bssInitial = initialInfo.indexOf("\n.bss");
            int bssFinal = initialInfo.indexOf("\n", bssInitial + 1);
            String bssValues = initialInfo.substring(bssInitial + 6, bssFinal).trim();
            endSize = bssValues.indexOf(32);
            startPos = bssValues.lastIndexOf(32);
            int bssSize = Integer.parseInt(bssValues.substring(0, endSize));
            int bssPos = Integer.parseInt(bssValues.substring(startPos + 1));
            globals = new byte[16];
            CcsServer.writeInt(globals, 0, dataPos);
            CcsServer.writeInt(globals, 4, dataPos + dataSize);
            CcsServer.writeInt(globals, 8, bssPos);
            CcsServer.writeInt(globals, 12, bssPos + bssSize);
            long iter = 0L;
            while (ParDebug.servthread.portno == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                if (iter++ <= 600L) continue;
                this.abort("Timeout waiting for program to start up (and print its CCS port number)");
            }
            if (this.exec.port.length() == 0) {
                this.exec.port = ParDebug.servthread.portno;
            }
            if (this.exec.hostname.equals("localhost")) {
                hostnumber = ParDebug.servthread.hostName;
            }
            System.out.println("ParDebug> Charmrun started (CCS IP " + (this.exec.hostname.equals("localhost") ? hostnumber : this.exec.hostname) + ", port " + this.exec.port + ")");
            String[] ccsArgs = new String[]{this.exec.hostname.equals("localhost") ? hostnumber : this.exec.hostname, this.exec.port};
            if (this.exec.sshTunnel) {
                System.out.println("ParDebug> Tunneling connection through ssh");
                try {
                    sshTunnel = runtime.exec("ssh -2 -c blowfish -L " + this.exec.port + ":localhost:" + this.exec.port + " " + this.exec.hostname);
                }
                catch (Exception exc) {
                    System.out.println("ParDebug> Could not create ssh tunnel");
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                ccsArgs[0] = "localhost";
            }
            System.out.println("Connecting to: " + this.exec.username + (this.exec.username.length() > 0 ? "@" : "") + (this.exec.hostname.equals("localhost") ? hostnumber : this.exec.hostname) + ":" + this.exec.port);
            CcsServer ccs = CcsServer.create(ccsArgs, false);
            server = new CpdUtil(ccs);
            this.peList = new boolean[this.exec.npes];
            for (int i = 0; i < this.exec.npes; ++i) {
                String peNumber = new Integer(i).toString();
                this.pesbox.addItem(peNumber);
                String chkboxlabel = "pe " + peNumber;
                JCheckBox chkbox = new JCheckBox(chkboxlabel);
                this.peActualPanel.add(chkbox);
                chkbox.setSelected(true);
                chkbox.addActionListener(this);
                chkbox.setActionCommand("pecheck");
                this.peList[i] = true;
            }
            this.peActualPanel.updateUI();
            this.startButton.setEnabled(false);
            this.stepButton.setEnabled(true);
            this.continueButton.setEnabled(true);
            this.quitButton.setEnabled(false);
            this.freezeButton.setEnabled(false);
            this.startGdbButton.setEnabled(true);
            Inspector.initialize(server);
            int nItems = server.getListLength("charm/chares", 0);
            this.chareItems.load(server.getPList("charm/chares", 0, 0, nItems));
            this.epItems.setLookups(this.chareItems);
            nItems = server.getListLength("charm/entries", 0);
            this.epItems.load(server.getPList("charm/entries", 0, 0, nItems));
            DefaultMutableTreeNode[] chareRoots = new DefaultMutableTreeNode[this.chareItems.size()];
            System.out.println("allocated " + this.chareItems.size() + " chareRoots");
            Vector items = this.epItems.getUserEps();
            int l = items.size();
            int i = 0;
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            DefaultMutableTreeNode userRoot = new DefaultMutableTreeNode("User Entries");
            for (i = 0; i < l; ++i) {
                EpCheckBox chkbox = new EpCheckBox((EpInfo)items.elementAt(i));
                chkbox.addActionListener(this);
                chkbox.setActionCommand("breakpoints");
                int chareType = ((EpInfo)items.elementAt(i)).getChareType();
                if (chareRoots[chareType] == null) {
                    chareRoots[chareType] = new DefaultMutableTreeNode(this.chareItems.elementAt(chareType).getType());
                    userRoot.add(chareRoots[chareType]);
                }
                chareRoots[chareType].add(new EpTreeCheckBox(chkbox));
            }
            items = this.epItems.getSystemEps();
            l = items.size();
            DefaultMutableTreeNode sysRoot = new DefaultMutableTreeNode("System Entries");
            for (i = 0; i < l; ++i) {
                EpCheckBox chkbox = new EpCheckBox((EpInfo)items.elementAt(i));
                chkbox.addActionListener(this);
                chkbox.setActionCommand("breakpoints");
                int chareType = ((EpInfo)items.elementAt(i)).getChareType();
                if (chareRoots[chareType] == null) {
                    chareRoots[chareType] = new DefaultMutableTreeNode(this.chareItems.elementAt(chareType).getType());
                    sysRoot.add(chareRoots[chareType]);
                }
                chareRoots[chareType].add(new EpTreeCheckBox(chkbox));
            }
            root.add(sysRoot);
            root.add(userRoot);
            JTree treeBP = new JTree(root);
            treeBP.setRootVisible(false);
            treeBP.collapseRow(0);
            treeBP.expandRow(1);
            treeBP.addMouseListener(new EpTreeListener(treeBP));
            treeBP.setCellRenderer(new EpTreeRenderer());
            treeBP.getSelectionModel().setSelectionMode(1);
            this.entryScrollPane.setViewportView(treeBP);
            nItems = server.getListLength("charm/messages", 0);
            this.msgItems.load(server.getPList("charm/messages", 0, 0, nItems));
            this.messageQueue.setLookups(this.epItems, this.msgItems, this.chareItems);
            nItems = server.getListLength("charm/objectNames", 0);
            this.groupItems.load(server.getPList("charm/objectNames", 0, 0, nItems));
        }
        catch (Exception e) {
            System.out.println("Error while starting the application (error: " + e + ". Aborting...");
            e.printStackTrace();
            p.destroy();
        }
        this.listsbox.setEnabled(true);
        this.pesbox.setEnabled(true);
        this.quitButton.setEnabled(true);
        this.listsbox.setSelectedIndex(3);
    }

    public void quitProgram() {
        gdb.terminate();
        this.isRunning = false;
        if (sshTunnel != null) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            sshTunnel.destroy();
            sshTunnel = null;
        }
        this.startButton.setEnabled(true);
        this.stepButton.setEnabled(false);
        this.continueButton.setEnabled(false);
        this.quitButton.setEnabled(false);
        this.freezeButton.setEnabled(false);
        this.startGdbButton.setEnabled(false);
        this.listModel.removeAllElements();
        this.outputArea.setList(null);
        this.listsbox.setEnabled(false);
        this.pesbox.removeAllItems();
        this.pesbox.setEnabled(false);
        this.peActualPanel.removeAll();
        this.peActualPanel.updateUI();
        this.entryScrollPane.setViewportView(new JLabel());
        this.setStatusMessage(new String("Ready to start new program"));
    }

    private String getInitialInfo() {
        String executable = new File(this.getFilename()).getAbsolutePath();
        String totCommandLine = "size -A " + executable;
        String hostname = this.getHostname();
        if (!hostname.equals("localhost")) {
            totCommandLine = hostname + " " + totCommandLine;
            String username = this.getUsername();
            if (!username.equals("")) {
                totCommandLine = "-l " + username + " " + totCommandLine;
            }
            totCommandLine = "ssh " + totCommandLine;
        }
        try {
            int c;
            Process p = Runtime.getRuntime().exec(totCommandLine);
            BufferedReader output = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuffer reply = new StringBuffer();
            while ((c = output.read()) != -1) {
                reply.append((char)c);
            }
            return reply.toString();
        }
        catch (Exception e) {
            System.out.println("Failed to start gdb info program");
            return "error";
        }
    }

    public static void printUsage() {
        System.out.println("Usage: java ParDebug [[-file <charm program name>] [[-param \"<charm program parameters>\"][-pes <number of pes>]] [-host <hostname>] [-user <username>] [-port <port>] [-sshtunnel] [-display <display>]]");
    }

    String getFilename() {
        return this.exec.executable;
    }

    String getHostname() {
        return this.exec.hostname;
    }

    String getUsername() {
        return this.exec.username;
    }

    public static void main(String[] args) {
        int i;
        Execution exec = new Execution();
        exec.hostname = "localhost";
        exec.username = "";
        exec.executable = "";
        exec.port = "";
        exec.npes = 1;
        String numberPesString = "1";
        exec.parameters = "";
        envDisplay = "";
        exec.sshTunnel = false;
        sshTunnel = null;
        boolean gotFilename = false;
        for (i = 0; i < args.length; i += 2) {
            if (args[i].equals("-host")) {
                exec.hostname = args[i + 1];
                continue;
            }
            if (args[i].equals("-user")) {
                exec.username = args[i + 1];
                continue;
            }
            if (args[i].equals("-port")) {
                exec.port = args[i + 1];
                continue;
            }
            if (args[i].equals("-file")) {
                exec.executable = args[i + 1];
                continue;
            }
            if (args[i].equals("-param")) {
                exec.parameters = args[i + 1];
                continue;
            }
            if (args[i].equals("-pes") || args[i].equals("+p")) {
                numberPesString = args[i + 1];
                continue;
            }
            if (args[i].equals("-display")) {
                envDisplay = args[i + 1];
                continue;
            }
            if (args[i].equals("-sshtunnel")) {
                exec.sshTunnel = true;
                --i;
                continue;
            }
            if (args[i].equals("-config")) {
                try {
                    File config = new File(args[i + 1]);
                    System.out.println("Config: " + config.getAbsolutePath());
                    exec = Execution.load(new File(args[i + 1]));
                }
                catch (IOException ioe) {
                    System.out.println("Could not open configuration file ");
                    ioe.printStackTrace();
                }
                catch (ClassNotFoundException cnfe) {
                    System.out.println("Configuration file corrupted");
                }
                continue;
            }
            if (args[i].startsWith("+p")) {
                numberPesString = args[i].substring(2);
            } else if (!gotFilename) {
                if (args[i].startsWith("-") || args[i].startsWith("+")) {
                    ParDebug.printUsage();
                    System.exit(1);
                } else {
                    exec.executable = args[i];
                    gotFilename = true;
                }
            } else {
                exec.parameters = exec.parameters + " " + args[i];
            }
            --i;
        }
        if (i > args.length) {
            ParDebug.printUsage();
            System.exit(1);
        }
        try {
            exec.npes = Integer.parseInt(numberPesString);
        }
        catch (NumberFormatException e) {
            System.out.println("Could not understand the specified number of processors");
        }
        appFrame = new JFrame("Charm Parallel Debugger");
        appFrame.setSize(1000, 1000);
        final ParDebug debugger = new ParDebug(exec);
        appFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (debugger.isRunning) {
                    server.bcastCcsRequest("ccs_debug_quit", "", -1, numberPesGlobal, null);
                    debugger.quitProgram();
                }
                debugger.preferences.save();
                System.exit(0);
            }
        });
        appFrame.getContentPane().add((Component)debugger, "Center");
        Rectangle bounds = appFrame.getGraphicsConfiguration().getBounds();
        appFrame.setLocation(50 + bounds.x, 50 + bounds.y);
        appFrame.setJMenuBar(debugger.menuBar);
        appFrame.pack();
        if (debugger.getPreferredSize() != null) {
            appFrame.setSize(debugger.getPreferredSize());
        }
        if (debugger.getPreferredLocation() != null) {
            appFrame.setLocation(debugger.getPreferredLocation());
        }
        appFrame.setVisible(true);
    }

    static {
        appFrame = null;
    }

    private class CpdListInfo {
        public String display;
        public String name;
        public String detailedName;
        public GenericPList list;

        public CpdListInfo(String display_, String name_) {
            this.display = display_;
            this.name = name_;
            this.detailedName = null;
            this.list = null;
        }

        public CpdListInfo(String display_, String name_, String detailed_, GenericPList list_) {
            this.display = display_;
            this.name = name_;
            this.detailedName = detailed_;
            this.list = list_;
        }
    }
}

