/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import projections.gui.GraphData;
import projections.gui.JSelectField;
import projections.gui.LWPanel;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.Util;
import projections.misc.ErrorDialog;

public class GraphControlPanel
extends Panel
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private Button bPlus5;
    private Button bPlus1;
    private Button bMinus1;
    private Button bMinus5;
    private Button bSelectAll;
    private Button bApply;
    private Checkbox cbXInterval;
    private Checkbox cbXProcessor;
    private Checkbox cbYMsg;
    private Checkbox cbYTime;
    private GraphData data;
    private Label lIterate;
    private Label lSelect;
    private JSelectField rangeField;
    private ErrorDialog errDlg;
    private OrderedIntList origProcList;

    public GraphControlPanel() {
        this.setBackground(Color.lightGray);
        CheckboxGroup cbgXAxis = new CheckboxGroup();
        CheckboxGroup cbgYAxis = new CheckboxGroup();
        this.cbXInterval = new Checkbox("Interval", true, cbgXAxis);
        this.cbXProcessor = new Checkbox("Processor", false, cbgXAxis);
        this.cbYMsg = new Checkbox("Msgs", true, cbgYAxis);
        this.cbYTime = new Checkbox("Time", false, cbgYAxis);
        this.bPlus5 = new Button(">>");
        this.bPlus1 = new Button(">");
        this.bMinus1 = new Button("<");
        this.bMinus5 = new Button("<<");
        this.bSelectAll = new Button("Select All");
        this.bApply = new Button("Apply");
        this.cbXInterval.addItemListener(this);
        this.cbXProcessor.addItemListener(this);
        this.cbYMsg.addItemListener(this);
        this.cbYTime.addItemListener(this);
        this.bPlus5.addActionListener(this);
        this.bPlus1.addActionListener(this);
        this.bMinus1.addActionListener(this);
        this.bMinus5.addActionListener(this);
        this.bSelectAll.addActionListener(this);
        this.bApply.addActionListener(this);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        gbc.fill = 1;
        LWPanel p1 = new LWPanel();
        LWPanel p2 = new LWPanel();
        LWPanel p3 = new LWPanel();
        p1.setLayout(gbl);
        p2.setLayout(gbl);
        p3.setLayout(gbl);
        gbc.insets = new Insets(3, 3, 3, 3);
        Util.gblAdd(this, p1, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this, p2, gbc, 1, 0, 1, 1, 3, 1);
        Util.gblAdd(this, p3, gbc, 2, 0, 1, 1, 2, 1);
        gbc.insets = new Insets(0, 0, 0, 0);
        Util.gblAdd(p1, new Label("X-AXIS", 1), gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(p1, new Label("Y-AXIS", 1), gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(p1, this.cbXInterval, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(p1, this.cbXProcessor, gbc, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(p1, this.cbYMsg, gbc, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(p1, this.cbYTime, gbc, 1, 2, 1, 1, 1, 1);
        this.lIterate = new Label("", 1);
        Util.gblAdd(p2, this.lIterate, gbc, 2, 0, 4, 1, 1, 1);
        Util.gblAdd(p2, new Label("-5", 1), gbc, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(p2, new Label("-1", 1), gbc, 3, 1, 1, 1, 1, 1);
        Util.gblAdd(p2, new Label("+1", 1), gbc, 4, 1, 1, 1, 1, 1);
        Util.gblAdd(p2, new Label("+5", 1), gbc, 5, 1, 1, 1, 1, 1);
        Util.gblAdd(p2, this.bMinus5, gbc, 2, 2, 1, 1, 1, 1);
        Util.gblAdd(p2, this.bMinus1, gbc, 3, 2, 1, 1, 1, 1);
        Util.gblAdd(p2, this.bPlus1, gbc, 4, 2, 1, 1, 1, 1);
        Util.gblAdd(p2, this.bPlus5, gbc, 5, 2, 1, 1, 1, 1);
        this.lSelect = new Label("", 1);
        String selectFormat = "Format: #,#-#,#,#,#-#,etc...";
        this.rangeField = new JSelectField("", 12);
        Util.gblAdd(p3, this.lSelect, gbc, 6, 0, 4, 1, 1, 1);
        Util.gblAdd(p3, this.rangeField, gbc, 6, 1, 4, 1, 1, 1);
        Util.gblAdd(p3, this.bSelectAll, gbc, 6, 2, 2, 1, 1, 1);
        Util.gblAdd(p3, this.bApply, gbc, 8, 2, 2, 1, 1, 1);
        this.rangeField.setText(selectFormat);
        this.rangeField.addActionListener(this);
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.data == null) {
            return;
        }
        if (evt.getSource() instanceof Button) {
            Button c = (Button)evt.getSource();
            if (c == this.bPlus5 || c == this.bPlus1 || c == this.bMinus1 || c == this.bMinus5) {
                int delta = 0;
                if (c == this.bPlus5) {
                    delta = 5;
                } else if (c == this.bPlus1) {
                    delta = 1;
                } else if (c == this.bMinus1) {
                    delta = -1;
                } else if (c == this.bMinus5) {
                    delta = -5;
                }
                int x = 0;
                if (this.data.xmode == 0) {
                    this.data.interval.list.reset();
                    x = this.data.interval.list.currentElement();
                    x = (x + delta) % this.data.interval.num;
                    if (x < 0) {
                        x += this.data.interval.num;
                    }
                } else {
                    if (delta < 0) {
                        delta += this.origProcList.size();
                    }
                    x = this.origProcList.currentElement();
                    int i = 0;
                    while (i < delta) {
                        x = this.origProcList.nextElement();
                        if (x == -1) {
                            x = this.origProcList.nextElement();
                        }
                        ++i;
                    }
                }
                this.rangeField.setText(String.valueOf(x));
            } else if (c == this.bSelectAll) {
                int x = 0;
                if (this.data.xmode == 0) {
                    x = this.data.interval.num - 1;
                    this.rangeField.setText("0-" + x);
                } else {
                    this.rangeField.setText(this.origProcList.listToString());
                }
            }
        }
        if (this.data.xmode == 0) {
            this.data.interval.list = this.rangeField.getValue(this.data.interval.num);
            this.data.interval.string = this.rangeField.getText();
            this.data.setData();
        } else {
            this.data.processor.list = this.rangeField.getValue(MainWindow.runObject[this.myRun].getNumProcessors());
            if (!this.origProcList.contains(this.data.processor.list)) {
                System.out.println("Invalid processor range. ");
                if (this.errDlg == null) {
                    this.errDlg = new ErrorDialog((Frame)this.data.graphWindow, "Processors Range Beyond Scope!");
                }
                if (!this.errDlg.isShowing()) {
                    this.errDlg.setVisible(true);
                }
                this.rangeField.setText(this.origProcList.listToString());
                return;
            }
            this.data.processor.string = this.rangeField.getText();
            this.data.setData();
        }
        this.data.displayPanel.setAllBounds();
        this.data.displayPanel.UpdateDisplay();
    }

    public void itemStateChanged(ItemEvent evt) {
        if (this.data == null) {
            return;
        }
        Checkbox c = (Checkbox)evt.getSource();
        if (c == this.cbXProcessor) {
            this.setXMode(0);
        } else if (c == this.cbXInterval) {
            this.setXMode(1);
        } else if (c == this.cbYMsg) {
            this.setYMode(11);
        } else if (c == this.cbYTime) {
            this.setYMode(10);
        }
    }

    public void paint(Graphics g) {
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        super.paint(g);
    }

    public void setGraphData(GraphData data) {
        this.data = data;
        this.origProcList = data.processor.list;
    }

    public void setXMode(int mode) {
        if (this.data == null) {
            return;
        }
        this.data.xmode = mode;
        if (mode == 0) {
            if (!this.cbXProcessor.getState()) {
                this.cbXProcessor.setState(true);
            }
            this.lIterate.setText("ITERATE INTERVALS");
            this.lSelect.setText("SELECT INTERVALS (0-" + (this.data.interval.num - 1) + ")");
            this.rangeField.setText(this.data.interval.string);
        } else {
            if (!this.cbXInterval.getState()) {
                this.cbXInterval.setState(true);
            }
            this.lIterate.setText("ITERATE PROCESSORS");
            this.lSelect.setText("SELECT PROCESSORS (" + this.origProcList.listToString() + ")");
            this.rangeField.setText(this.data.processor.string);
        }
        this.data.displayPanel.setAllBounds();
        this.data.displayPanel.UpdateDisplay();
    }

    public void setYMode(int mode) {
        if (this.data == null) {
            return;
        }
        if (mode == 10 && !this.cbYTime.getState()) {
            this.cbYTime.setState(true);
        } else if (mode == 11 && !this.cbYMsg.getState()) {
            this.cbYMsg.setState(true);
        }
        this.data.ymode = mode;
        this.data.displayPanel.setAllBounds();
        this.data.displayPanel.UpdateDisplay();
        this.data.legendPanel.UpdateLegend();
    }
}

