/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.preference.Execution;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ParamsDialog
extends JDialog
implements ActionListener {
    Execution exec = null;
    private JTextField clParams;
    private JTextField numPes;
    private JTextField portno;
    private JTextField hostname;
    private JTextField username;
    private JTextField filename;
    private JTextField dir;
    private JCheckBox sshTunnel;
    private JButton chooser;
    private JButton dirchooser;

    public ParamsDialog(Frame parent, boolean modal, Execution obj) {
        super(parent, modal);
        this.exec = obj;
        this.initComponents();
        this.pack();
        this.setResizable(false);
    }

    public void setFields(String params, String pes, String pno, String host, String user, boolean ssh) {
        this.clParams.setText(params);
        this.numPes.setText(pes);
        this.portno.setText(pno);
        this.hostname.setText(host);
        this.username.setText(user);
        this.sshTunnel.setSelected(ssh);
    }

    private void initComponents() {
        this.setTitle("Program Parameters");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel contents = new JPanel();
        GridBagLayout grid = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        contents.setLayout(grid);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel filenamelabel = new JLabel("Executable:");
        filenamelabel.setLabelFor(this.filename);
        grid.setConstraints(filenamelabel, c);
        contents.add(filenamelabel);
        this.filename = new JTextField(35);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(11, 7, 0, 0);
        grid.setConstraints(this.filename, c);
        this.chooser = new JButton("Change");
        this.chooser.setActionCommand("browse");
        this.chooser.addActionListener(this);
        c.gridx = 3;
        c.gridy = 0;
        c.gridwidth = 1;
        c.fill = 13;
        c.insets = new Insets(12, 5, 0, 10);
        grid.setConstraints(this.chooser, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel dirlabel = new JLabel("Working dir:");
        dirlabel.setLabelFor(this.dir);
        grid.setConstraints(dirlabel, c);
        contents.add(dirlabel);
        this.dir = new JTextField(35);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(11, 7, 0, 0);
        grid.setConstraints(this.dir, c);
        this.dirchooser = new JButton("Change");
        this.dirchooser.setActionCommand("browsedir");
        this.dirchooser.addActionListener(this);
        c.gridx = 3;
        c.gridy = 1;
        c.gridwidth = 1;
        c.fill = 13;
        c.insets = new Insets(12, 5, 0, 10);
        grid.setConstraints(this.dirchooser, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel paramlabel = new JLabel();
        paramlabel.setText("Command Line Parameters:");
        paramlabel.setLabelFor(this.clParams);
        grid.setConstraints(paramlabel, c);
        contents.add(paramlabel);
        this.clParams = new JTextField(35);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 3;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(11, 7, 0, 0);
        grid.setConstraints(this.clParams, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel peslabel = new JLabel();
        peslabel.setText("Number of Processors:");
        peslabel.setLabelFor(this.numPes);
        grid.setConstraints(peslabel, c);
        contents.add(peslabel);
        this.numPes = new JTextField(5);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(12, 8, 0, 0);
        grid.setConstraints(this.numPes, c);
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel portNumberLabel = new JLabel();
        portNumberLabel.setText("Port Number:");
        portNumberLabel.setLabelFor(this.portno);
        grid.setConstraints(portNumberLabel, c);
        contents.add(portNumberLabel);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(12, 8, 0, 0);
        this.portno = new JTextField(5);
        grid.setConstraints(this.portno, c);
        c.gridx = 0;
        c.gridy = 5;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel hostNameLabel = new JLabel();
        hostNameLabel.setText("Host name:");
        hostNameLabel.setLabelFor(this.hostname);
        grid.setConstraints(hostNameLabel, c);
        contents.add(hostNameLabel);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(12, 8, 0, 0);
        this.hostname = new JTextField(20);
        grid.setConstraints(this.hostname, c);
        c.gridx = 0;
        c.gridy = 6;
        c.anchor = 17;
        c.insets = new Insets(6, 12, 0, 0);
        JLabel userNameLabel = new JLabel();
        userNameLabel.setText("Username:");
        userNameLabel.setLabelFor(this.username);
        grid.setConstraints(userNameLabel, c);
        contents.add(userNameLabel);
        c.gridx = 1;
        c.gridy = 6;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(6, 8, 0, 0);
        this.username = new JTextField(15);
        grid.setConstraints(this.username, c);
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 4, 0, 0);
        this.sshTunnel = new JCheckBox("Use ssh tunneling");
        grid.setConstraints(this.sshTunnel, c);
        contents.add(this.filename);
        contents.add(this.chooser);
        contents.add(this.dir);
        contents.add(this.dirchooser);
        contents.add(this.clParams);
        contents.add(this.numPes);
        contents.add(this.portno);
        contents.add(this.hostname);
        contents.add(this.username);
        contents.add(this.sshTunnel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton okButton = new JButton();
        okButton.setText("OK");
        okButton.setActionCommand("cmd.ok");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ParamsDialog.this.windowAction(event);
            }
        });
        buttonPanel.add(okButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton cancelButton = new JButton();
        cancelButton.setText("CANCEL");
        cancelButton.setActionCommand("cmd.cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ParamsDialog.this.windowAction(event);
            }
        });
        buttonPanel.add(cancelButton);
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 7;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.insets = new Insets(4, 8, 4, 4);
        grid.setConstraints(buttonPanel, c);
        contents.add(buttonPanel);
        this.getContentPane().add(contents);
        this.filename.setText(this.exec.executable);
        this.clParams.setText(this.exec.parameters);
        this.numPes.setText("" + this.exec.npes);
        this.portno.setText("" + this.exec.port);
        this.hostname.setText(this.exec.hostname);
        this.username.setText(this.exec.username);
        this.sshTunnel.setSelected(this.exec.sshTunnel);
        this.dir.setText(this.exec.workingDir);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("browse")) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.filename.setText(chooser.getSelectedFile().getAbsolutePath());
            }
        } else if (e.getActionCommand().equals("browsedir")) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.dir.setText(chooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    private void windowAction(Object actionCommand) {
        boolean closeWindow = false;
        String cmd = null;
        if (actionCommand != null) {
            cmd = actionCommand instanceof ActionEvent ? ((ActionEvent)actionCommand).getActionCommand() : actionCommand.toString();
        }
        if (cmd != null) {
            if (cmd.equals("cmd.cancel")) {
                closeWindow = true;
            } else if (cmd.equals("cmd.ok")) {
                int numberPes;
                try {
                    numberPes = Integer.parseInt(this.numPes.getText());
                    if (!this.portno.getText().equals("")) {
                        int n = Integer.parseInt(this.portno.getText());
                    }
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "All values must be positive integers", "Error", 0);
                    return;
                }
                this.exec.executable = this.filename.getText();
                this.exec.parameters = this.clParams.getText();
                this.exec.npes = numberPes;
                this.exec.port = this.portno.getText();
                this.exec.hostname = this.hostname.getText();
                this.exec.username = this.username.getText();
                this.exec.sshTunnel = this.sshTunnel.isSelected();
                this.exec.workingDir = this.dir.getText();
                closeWindow = true;
            }
        }
        if (closeWindow) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(200, 100);
            }
        };
        frame.setTitle("Debugging frame");
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(false);
        ParamsDialog dialog = new ParamsDialog((Frame)frame, true, null);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }

            @Override
            public void windowClosed(WindowEvent event) {
                System.exit(0);
            }
        });
        dialog.pack();
        dialog.setVisible(true);
    }
}

