/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.PopUpAble;
import projections.gui.ProjectionsWindow;
import projections.gui.ResponsiveToMouse;
import projections.gui.Util;
import projections.gui.graph.DataSource;
import projections.gui.graph.DataSource1D;
import projections.gui.graph.DataSource2D;
import projections.gui.graph.Graph;
import projections.gui.graph.GraphPanel;
import projections.gui.graph.XAxis;
import projections.gui.graph.XAxisDiscrete;
import projections.gui.graph.XAxisDiscreteOrdered;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxis;
import projections.gui.graph.YAxisAuto;
import projections.gui.graph.YAxisFixed;

public abstract class GenericGraphWindow
extends ProjectionsWindow
implements PopUpAble {
    static int myRun = 0;
    protected GraphPanel graphPanel;
    protected Graph graphCanvas;
    protected DataSource dataSource;
    protected XAxis xAxis;
    protected YAxis yAxis;
    protected JMenuBar menuBar = new JMenuBar();
    protected JMenu fileMenu = new JMenu("File");
    public OrderedIntList validPEs;
    public long startTime;
    public long endTime;

    protected abstract void setGraphSpecificData();

    protected void windowInit() {
        this.validPEs = MainWindow.runObject[myRun].getValidProcessorList();
        this.startTime = 0L;
        this.endTime = MainWindow.runObject[myRun].getTotalTime();
    }

    public GenericGraphWindow(String title, MainWindow mainWindow, Integer myWindowID) {
        super(title, mainWindow, myWindowID);
        this.menuBar.add(this.fileMenu);
    }

    protected void createMenus() {
        this.fileMenu = Util.makeJMenu(this.fileMenu, new Object[]{"Set Range", "Close"}, null, this);
        this.setJMenuBar(this.menuBar);
    }

    public abstract String[] getPopup(int var1, int var2);

    protected JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        this.graphCanvas = new Graph();
        this.graphPanel = new GraphPanel(this.graphCanvas);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.graphPanel);
        return mainPanel;
    }

    protected void setStackGraph(boolean isSet) {
        if (this.graphCanvas != null) {
            this.graphCanvas.setStackGraph(isSet);
        } else {
            System.err.println("Warning: The graph canvas has not yet been initialized! Ignoring request.");
        }
    }

    protected void getDialogData() {
        this.validPEs = this.dialog.getValidProcessors();
        this.startTime = this.dialog.getStartTime();
        this.endTime = this.dialog.getEndTime();
    }

    protected void setDialogData() {
        this.dialog.setValidProcessors(this.validPEs);
        this.dialog.setStartTime(this.startTime);
        this.dialog.setEndTime(this.endTime);
        super.setDialogData();
    }

    protected void setXAxis(String title, String units) {
        this.xAxis = new XAxisFixed(title, units);
    }

    protected void setXAxis(String title, OrderedIntList discreteList) {
        this.xAxis = new XAxisDiscreteOrdered(title, discreteList);
    }

    protected void setXAxis(String title, LinkedList discreteList) {
        this.xAxis = new XAxisDiscrete(title, discreteList);
    }

    protected void setXAxis(String title, String units, double startValue, double multiplier) {
        this.xAxis = new XAxisFixed(title, units);
        ((XAxisFixed)this.xAxis).setLimits(startValue, multiplier);
    }

    protected void setYAxis(String title, String units) {
        this.yAxis = this.dataSource != null ? new YAxisAuto(title, units, this.dataSource) : new YAxisFixed(title, units, 0.0);
    }

    protected void setDataSource(String title, int[] data) {
        this.dataSource = new DataSource1D(title, data);
        this.dataSource.setColors(MainWindow.runObject[myRun].getColorMap());
        if (this.yAxis != null) {
            this.yAxis = new YAxisAuto(this.yAxis.getTitle(), this.yAxis.getUnits(), this.dataSource);
        }
    }

    protected void setDataSource(String title, double[][] data) {
        this.dataSource = new DataSource2D(title, data);
        this.dataSource.setColors(MainWindow.runObject[myRun].getColorMap());
        if (this.yAxis != null) {
            this.yAxis = new YAxisAuto(this.yAxis.getTitle(), this.yAxis.getUnits(), this.dataSource);
        }
    }

    protected void setDataSource(String title, double[][] data, Color[] colorMap, GenericGraphWindow parent) {
        this.dataSource = new DataSource2D(title, data, (ResponsiveToMouse)parent);
        this.dataSource.setColors(colorMap);
        if (this.yAxis != null) {
            this.yAxis = new YAxisAuto(this.yAxis.getTitle(), this.yAxis.getUnits(), this.dataSource);
        }
    }

    protected void setDataSource(String title, int[] data, GenericGraphWindow parent) {
        this.dataSource = new DataSource1D(title, data, parent);
        this.dataSource.setColors(MainWindow.runObject[myRun].getColorMap());
        if (this.yAxis != null) {
            this.yAxis = new YAxisAuto(this.yAxis.getTitle(), this.yAxis.getUnits(), this.dataSource);
        }
    }

    protected void setDataSource(String title, double[][] data, GenericGraphWindow parent) {
        this.dataSource = new DataSource2D(title, data, (ResponsiveToMouse)parent);
        this.dataSource.setColors(MainWindow.runObject[myRun].getColorMap());
        if (this.yAxis != null) {
            this.yAxis = new YAxisAuto(this.yAxis.getTitle(), this.yAxis.getUnits(), this.dataSource);
        }
    }

    protected void refreshGraph() {
        this.graphCanvas.setData(this.dataSource, this.xAxis, this.yAxis);
        this.graphCanvas.repaint();
    }
}

