/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeMap;
import projections.analysis.GenericLogReader;
import projections.analysis.NoiseMiner;
import projections.analysis.TimelineEvent;
import projections.gui.Analysis;
import projections.misc.LogEntryData;

public class NoiseMinerThread
extends Thread {
    private int pe;
    private TreeMap h;
    private Analysis analysis;
    private NoiseMiner parent;
    private NoiseMiner.Histogram h_pe;
    public LinkedList results;
    public long[] histogramToDisplay;

    public NoiseMinerThread(int pe, Analysis analysis, NoiseMiner parent) {
        this.setPe(pe);
        this.analysis = analysis;
        this.parent = parent;
    }

    public void run() {
        System.out.println("PE " + this.pe + " loading");
        LogEntryData logdata = new LogEntryData();
        long previous_begin_time = -1L;
        int previous_begin_entry = -1;
        int encountered_user_event = -1;
        long previous_black_time = -1L;
        int blackPartIdx = -2;
        this.h = new TreeMap();
        GenericLogReader LogFile = new GenericLogReader(this.analysis.getLogName(this.getPe()), this.analysis.getVersion());
        try {
            logdata = LogFile.nextEventOnOrAfter(this.parent.getStartTime());
            while (logdata.time < this.parent.getEndTime()) {
                NoiseMiner.Event e;
                if (logdata.type == 2) {
                    previous_begin_time = logdata.time;
                    previous_begin_entry = logdata.entry;
                } else if (logdata.type == 3) {
                    if (previous_begin_entry == logdata.entry) {
                        NoiseMiner noiseMiner = this.parent;
                        noiseMiner.getClass();
                        e = noiseMiner.new NoiseMiner.Event(logdata.entry, encountered_user_event);
                        if (!this.h.containsKey(e)) {
                            this.h.put(e, this.parent.new NoiseMiner.Histogram());
                        }
                        ((NoiseMiner.Histogram)this.h.get(e)).insert(new TimelineEvent(previous_begin_time, logdata.time, -1, this.getPe()));
                        encountered_user_event = -1;
                    }
                } else if (logdata.type == 13 || logdata.type == 100) {
                    encountered_user_event = logdata.userEventID;
                }
                if (logdata.type == 3 || logdata.type == 15) {
                    previous_black_time = logdata.time;
                } else if (logdata.type == 2 || logdata.type == 14) {
                    if (previous_black_time != -1L) {
                        NoiseMiner noiseMiner = this.parent;
                        noiseMiner.getClass();
                        e = noiseMiner.new NoiseMiner.Event(blackPartIdx, -1);
                        if (!this.h.containsKey(e)) {
                            this.h.put(e, this.parent.new NoiseMiner.Histogram());
                        }
                        ((NoiseMiner.Histogram)this.h.get(e)).insert(new TimelineEvent(previous_black_time, logdata.time, -1, this.getPe()));
                    }
                } else {
                    previous_black_time = -1L;
                }
                logdata = LogFile.nextEvent();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.h_pe = this.parent.new NoiseMiner.Histogram();
        for (NoiseMiner.Histogram hist : this.h.values()) {
            hist.cluster();
            ListIterator itr = hist.clustersNormalized().listIterator();
            while (itr.hasNext()) {
                NoiseMiner.Cluster c = (NoiseMiner.Cluster)itr.next();
                this.h_pe.insert(c);
            }
        }
        this.h_pe.cluster();
        System.out.println("PE " + this.pe + " loaded");
        this.results = new LinkedList();
        int n = 1;
        while (this.h_pe.hasNthNoiseComponent(n)) {
            NoiseMiner.EventWindow ew = this.h_pe.nthNoise((int)n).events;
            long occurrences = this.h_pe.nthNoise(n).count();
            NoiseMiner.Duration duration = this.h_pe.nthNoise(n).mean();
            NoiseMiner noiseMiner = this.parent;
            noiseMiner.getClass();
            this.results.add(noiseMiner.new NoiseMiner.NoiseResult(duration, occurrences, this.pe, ew));
            ++n;
        }
        this.histogramToDisplay = new long[this.parent.numDisplayBins];
        for (int i = 0; i < this.parent.numDisplayBins; ++i) {
            this.histogramToDisplay[i] = 0L;
        }
        int numOldBinsPerNewBin = this.parent.numOldBinsPerNewBin();
        Iterator eventTypeIter = this.h.keySet().iterator();
        while (eventTypeIter.hasNext()) {
            NoiseMiner.Histogram hist = (NoiseMiner.Histogram)this.h.get(eventTypeIter.next());
            for (int i = 0; i < this.parent.getNbins(); ++i) {
                int newbin;
                int n2 = newbin = i / numOldBinsPerNewBin;
                this.histogramToDisplay[n2] = this.histogramToDisplay[n2] + hist.bin_count[i];
            }
        }
        this.h = null;
        this.h_pe = null;
        System.out.println("PE " + this.pe + " done");
    }

    public void setPe(int pe) {
        this.pe = pe;
    }

    public int getPe() {
        return this.pe;
    }
}

