/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;
import projections.gui.OrderedIntList;
import projections.gui.Timeline.AxisPanel;
import projections.gui.Timeline.Data;
import projections.gui.Timeline.LabelPanel;
import projections.gui.Timeline.MainHandler;
import projections.gui.Timeline.MainPanel;
import projections.gui.Timeline.NonScrollingLayout;

public class NonScrollingPanel
extends JPanel
implements MainHandler {
    NonScrollingPanel thisPanel = this;
    long startTime;
    long endTime;
    int PE;
    private MainPanel displayPanel;
    private LabelPanel labelPanel;
    private AxisPanel axisPanel;
    private Data data;

    public NonScrollingPanel(long startTime_, long endTime_, int PE_, Color background, Color foreground, boolean useMinimalMargins) {
        this.startTime = startTime_;
        this.endTime = endTime_;
        this.PE = PE_;
        OrderedIntList validPEs = new OrderedIntList();
        validPEs.insert(this.PE);
        this.data = new Data(null);
        this.data.setProcessorList(validPEs);
        this.data.setRange(this.startTime, this.endTime);
        this.data.setUseMinimalMargins(useMinimalMargins);
        this.data.setFontSizes(12, 10, true);
        this.data.showIdle(true);
        this.data.showPacks(true);
        if (background != null && foreground != null) {
            this.data.setColors(background, foreground);
        }
        this.displayPanel = new MainPanel(this.data, this);
        this.displayPanel.loadTimelineObjects(true, null);
        this.labelPanel = new LabelPanel(this.data);
        this.axisPanel = new AxisPanel(this.data);
        NonScrollingLayout lay = new NonScrollingLayout();
        lay.setAxis(this.axisPanel);
        lay.setLabel(this.labelPanel);
        lay.setMain(this.displayPanel);
        this.setLayout(lay);
        this.add(this.displayPanel);
        this.add(this.axisPanel);
        this.add(this.labelPanel);
        this.data.setHandler(this);
        this.data.SetToolTipDelaySmall();
    }

    public void paintComponent(Graphics g) {
        g.setColor(this.data.getBackgroundColor());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void refreshDisplay(boolean doRevalidate) {
        if (doRevalidate) {
            if (this.axisPanel != null) {
                this.axisPanel.revalidate();
            }
            if (this.displayPanel != null) {
                this.displayPanel.revalidate();
            }
            if (this.labelPanel != null) {
                this.labelPanel.revalidate();
            }
            if (this.thisPanel != null) {
                this.thisPanel.revalidate();
            }
        }
        if (this.axisPanel != null) {
            this.axisPanel.repaint();
        }
        if (this.displayPanel != null) {
            this.displayPanel.repaint();
        }
        if (this.labelPanel != null) {
            this.labelPanel.repaint();
        }
        if (this.thisPanel != null) {
            this.thisPanel.repaint();
        }
    }

    public void setData(Data data) {
        this.data = data;
    }

    public void notifyProcessorListHasChanged() {
    }

    public void displayWarning(String message) {
    }
}

