/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import projections.gui.Timeline.Data;
import projections.gui.Timeline.EntryMethodObject;

public class UserSuppliedAnalyzer
extends JFrame {
    Data data;

    UserSuppliedAnalyzer(Data data) {
        this.data = data;
        this.createLayout();
    }

    void createLayout() {
        this.setTitle("Analysis of user supplied values(timesteps)");
        TreeMap<Integer, Integer> parameterMinTime = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Integer> parameterMaxTime = new TreeMap<Integer, Integer>();
        for (List objs : this.data.allEntryMethodObjects.values()) {
            for (EntryMethodObject obj : objs) {
                Integer param = obj.userSuppliedData;
                long start = obj.getBeginTime();
                long end = obj.getEndTime();
                if (param == null) continue;
                if (parameterMinTime.containsKey(param)) {
                    Integer oldval = (Integer)parameterMinTime.get(param);
                    if (start < (long)oldval.intValue()) {
                        parameterMinTime.put(param, new Integer((int)start));
                    }
                    if (end <= (long)(oldval = (Integer)parameterMaxTime.get(param)).intValue()) continue;
                    parameterMaxTime.put(param, new Integer((int)end));
                    continue;
                }
                parameterMinTime.put(param, new Integer((int)start));
                parameterMaxTime.put(param, new Integer((int)end));
            }
        }
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(new String("User Supplied Value(timestep)"));
        columnNames.add(new String("Earliest Begin Time"));
        columnNames.add(new String("Latest End Time"));
        columnNames.add(new String("Duration"));
        columnNames.add(new String("Last Begin to This Begin"));
        columnNames.add(new String("Last End to This End"));
        Vector data = new Vector();
        Iterator i = parameterMinTime.keySet().iterator();
        Integer prevMin = null;
        Integer prevMax = null;
        while (i.hasNext()) {
            Integer param = (Integer)i.next();
            Integer min = (Integer)parameterMinTime.get(param);
            Integer max = (Integer)parameterMaxTime.get(param);
            Vector<Object> row = new Vector<Object>();
            row.add(param);
            row.add(min);
            row.add(max);
            row.add(max - min);
            if (prevMin == null) {
                row.add("");
            } else {
                row.add(min - prevMin);
            }
            if (prevMax == null) {
                row.add("");
            } else {
                row.add(max - prevMax);
            }
            prevMin = min;
            prevMax = max;
            data.add(row);
        }
        if (parameterMinTime.size() == 0) {
            JLabel msg = new JLabel("<html><body>No User Supplied Values Found in the currently loaded timeline.<br> Try selecting a different time range, or add calls to <br><font color=blue><tt>traceUserSuppliedData(int value)</tt></font> to the program.</body></html>");
            JOptionPane.showMessageDialog(this, msg, "Warning", 2);
            Vector<String> row = new Vector<String>();
            row.add(new String("No data found"));
            row.add(new String(""));
            row.add(new String(""));
            row.add(new String(""));
            row.add(new String(""));
            row.add(new String(""));
            data.add(row);
        }
        DefaultTableModel tableModel = new DefaultTableModel(data, columnNames);
        JTable table = new JTable(tableModel);
        JScrollPane scroller = new JScrollPane(table);
        scroller.setHorizontalScrollBarPolicy(30);
        this.setContentPane(scroller);
        this.pack();
        this.setSize(800, 400);
        this.setVisible(true);
    }
}

