/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import antlr.Token;
import java.util.Iterator;
import java.util.Set;
import org.antlr.tool.Attribute;
import org.antlr.tool.AttributeScope;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;

public class NameSpaceChecker {
    protected Grammar grammar;

    public NameSpaceChecker(Grammar grammar) {
        this.grammar = grammar;
    }

    public void checkConflicts() {
        Object object;
        for (int i = 1; i < this.grammar.composite.ruleIndexToRuleList.size(); ++i) {
            Object object2;
            object = this.grammar.composite.ruleIndexToRuleList.elementAt(i);
            if (object == null) continue;
            if (((Rule)object).labelNameSpace != null) {
                object2 = ((Rule)object).labelNameSpace.values().iterator();
                while (object2.hasNext()) {
                    Grammar.LabelElementPair labelElementPair = (Grammar.LabelElementPair)object2.next();
                    this.checkForLabelConflict((Rule)object, labelElementPair.label);
                }
            }
            if (((Rule)object).ruleScope != null) {
                object2 = ((Rule)object).ruleScope.getAttributes();
                for (int j = 0; j < object2.size(); ++j) {
                    Attribute attribute = (Attribute)object2.get(j);
                    this.checkForRuleScopeAttributeConflict((Rule)object, attribute);
                }
            }
            this.checkForRuleDefinitionProblems((Rule)object);
            this.checkForRuleArgumentAndReturnValueConflicts((Rule)object);
        }
        Iterator iterator = this.grammar.getGlobalScopes().values().iterator();
        while (iterator.hasNext()) {
            object = (AttributeScope)iterator.next();
            this.checkForGlobalScopeTokenConflict((AttributeScope)object);
        }
        this.lookForReferencesToUndefinedSymbols();
    }

    protected void checkForRuleArgumentAndReturnValueConflicts(Rule rule) {
        Set set;
        if (rule.returnScope != null && (set = rule.returnScope.intersection(rule.parameterScope)) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ErrorManager.grammarError(126, this.grammar, rule.tree.getToken(), string, rule.name);
            }
        }
    }

    protected void checkForRuleDefinitionProblems(Rule rule) {
        String string = rule.name;
        Token token = rule.tree.getToken();
        int n = 0;
        if ((this.grammar.type == 2 || this.grammar.type == 3) && Character.isUpperCase(string.charAt(0))) {
            n = 102;
        } else if (this.grammar.type == 1 && Character.isLowerCase(string.charAt(0)) && !rule.isSynPred) {
            n = 103;
        } else if (this.grammar.getGlobalScope(string) != null) {
            n = 118;
        }
        if (n != 0) {
            ErrorManager.grammarError(n, this.grammar, token, string);
        }
    }

    protected void lookForReferencesToUndefinedSymbols() {
        Rule rule;
        Object object;
        Object object2;
        Object object3;
        GrammarAST grammarAST;
        Iterator<GrammarAST> iterator = this.grammar.ruleRefs.iterator();
        while (iterator.hasNext()) {
            grammarAST = iterator.next();
            object3 = grammarAST.token;
            object2 = object3.getText();
            object = this.grammar.getLocallyDefinedRule((String)object2);
            rule = this.grammar.getRule((String)object2);
            if (object == null && rule != null) {
                this.grammar.delegatedRuleReferences.add(rule);
                rule.imported = true;
            }
            if (rule != null || this.grammar.getTokenType((String)object2) == -1) continue;
            ErrorManager.grammarError(106, this.grammar, object3, object2);
        }
        if (this.grammar.type == 4) {
            iterator = this.grammar.tokenIDRefs.iterator();
            while (iterator.hasNext()) {
                grammarAST = (Token)iterator.next();
                object3 = grammarAST.getText();
                if (this.grammar.composite.lexerRules.contains(object3) || this.grammar.getTokenType((String)object3) == -1) continue;
                ErrorManager.grammarWarning(105, this.grammar, (Token)grammarAST, object3);
            }
        }
        iterator = this.grammar.scopedRuleRefs.iterator();
        while (iterator.hasNext()) {
            grammarAST = iterator.next();
            object3 = this.grammar.composite.getGrammar(grammarAST.getText());
            object2 = grammarAST.getChild(1);
            object = ((GrammarAST)((Object)object2)).getText();
            if (object3 == null) {
                ErrorManager.grammarError(156, this.grammar, grammarAST.getToken(), grammarAST.getText(), object);
                continue;
            }
            rule = this.grammar.getRule(object3.name, (String)object);
            if (rule != null) continue;
            ErrorManager.grammarError(157, this.grammar, grammarAST.getToken(), grammarAST.getText(), object);
        }
    }

    protected void checkForGlobalScopeTokenConflict(AttributeScope attributeScope) {
        if (this.grammar.getTokenType(attributeScope.getName()) != -7) {
            ErrorManager.grammarError(118, this.grammar, null, attributeScope.getName());
        }
    }

    public void checkForRuleScopeAttributeConflict(Rule rule, Attribute attribute) {
        int n = 0;
        String string = null;
        String string2 = attribute.name;
        if (rule.name.equals(string2)) {
            n = 123;
            string = rule.name;
        } else if (rule.returnScope != null && rule.returnScope.getAttribute(string2) != null || rule.parameterScope != null && rule.parameterScope.getAttribute(string2) != null) {
            n = 124;
            string = rule.name;
        }
        if (n != 0) {
            ErrorManager.grammarError(n, this.grammar, rule.tree.getToken(), string2, string);
        }
    }

    protected void checkForLabelConflict(Rule rule, Token token) {
        int n = 0;
        String string = null;
        if (this.grammar.getGlobalScope(token.getText()) != null) {
            n = 118;
        } else if (this.grammar.getRule(token.getText()) != null) {
            n = 119;
        } else if (this.grammar.getTokenType(token.getText()) != -7) {
            n = 120;
        } else if (rule.ruleScope != null && rule.ruleScope.getAttribute(token.getText()) != null) {
            n = 121;
            string = rule.name;
        } else if (rule.returnScope != null && rule.returnScope.getAttribute(token.getText()) != null || rule.parameterScope != null && rule.parameterScope.getAttribute(token.getText()) != null) {
            n = 122;
            string = rule.name;
        }
        if (n != 0) {
            ErrorManager.grammarError(n, this.grammar, token, token.getText(), string);
        }
    }

    public boolean checkForLabelTypeMismatch(Rule rule, Token token, int n) {
        Grammar.LabelElementPair labelElementPair = rule.labelNameSpace.get(token.getText());
        if (labelElementPair != null && labelElementPair.type != n) {
            String string = Grammar.LabelTypeToString[n] + "!=" + Grammar.LabelTypeToString[labelElementPair.type];
            ErrorManager.grammarError(125, this.grammar, token, token.getText(), string);
            return true;
        }
        return false;
    }
}

