/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import projections.gui.ColorMap;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.ScalePanel;
import projections.gui.ScaleSlider;
import projections.gui.StlPanel;
import projections.gui.SwingWorker;
import projections.gui.Util;

public class StlWindow
extends ProjectionsWindow
implements MouseListener,
ActionListener,
ScalePanel.StatusDisplay,
ItemListener {
    int myRun = 0;
    private ScaleSlider hor;
    private ScaleSlider ver;
    private ScalePanel scalePanel;
    StlPanel stl;
    private Label status;
    public static final int MODE_UTILIZATION = 0;
    public static final int MODE_EP = 1;
    private int mode = 0;
    private JPanel modePanel;
    private ButtonGroup modeGroup;
    JRadioButton utilizationMode;
    private JRadioButton epMode;
    private ColorMap utilColorMap;
    StlWindow thisWindow = this;
    public OrderedIntList validPEs;
    public long startTime;
    public long endTime;

    protected void windowInit() {
        this.validPEs = MainWindow.runObject[this.myRun].getValidProcessorList();
        this.startTime = 0L;
        this.endTime = MainWindow.runObject[this.myRun].getTotalTime();
    }

    public StlWindow(MainWindow mainWindow) {
        super(mainWindow);
        this.setForeground(Color.lightGray);
        this.setTitle("Projections Overview - " + MainWindow.runObject[this.myRun].getFilename() + ".sts");
        this.createMenus();
        this.createLayout();
        this.pack();
        this.showDialog();
    }

    private void createLayout() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        Container windowPane = this.getContentPane();
        windowPane.setLayout(gbl);
        JPanel displayPanel = new JPanel();
        displayPanel.setLayout(gbl);
        this.status = new Label("");
        this.status.setBackground(Color.black);
        this.status.setForeground(Color.lightGray);
        this.hor = new ScaleSlider(0);
        this.hor.addMouseListener(this);
        this.ver = new ScaleSlider(1);
        this.ver.addMouseListener(this);
        this.stl = new StlPanel(this.thisWindow);
        this.scalePanel = new ScalePanel(this.hor, this.ver, this.stl);
        gbc.fill = 1;
        Util.gblAdd(displayPanel, this.scalePanel, gbc, 0, 0, 1, 1, 1, 1);
        gbc.fill = 3;
        Util.gblAdd(displayPanel, this.ver, gbc, 1, 0, 1, 1, 0, 1);
        gbc.fill = 2;
        Util.gblAdd(displayPanel, this.hor, gbc, 0, 1, 1, 1, 1, 0);
        Util.gblAdd(displayPanel, this.status, gbc, 0, 2, 1, 1, 1, 0);
        this.modePanel = new JPanel();
        this.modeGroup = new ButtonGroup();
        this.utilizationMode = new JRadioButton("Utilization", true);
        this.utilizationMode.addItemListener(this);
        this.epMode = new JRadioButton("By EP Colors", false);
        this.epMode.addItemListener(this);
        this.modeGroup.add(this.utilizationMode);
        this.modeGroup.add(this.epMode);
        if (!MainWindow.runObject[this.myRun].hasLogData()) {
            this.epMode.setEnabled(false);
        }
        gbc.fill = 2;
        Util.gblAdd(this.modePanel, this.utilizationMode, gbc, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(this.modePanel, this.epMode, gbc, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1);
        gbc.fill = 1;
        Util.gblAdd(windowPane, displayPanel, gbc, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(windowPane, this.modePanel, gbc, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1);
        this.scalePanel.setStatusDisplay(this);
        this.utilColorMap = new ColorMap();
        this.utilColorMap.addBreak(0, 0, 0, 55, 70, 255, 0, 0);
        this.utilColorMap.addBreak(70, 255, 0, 0, 100, 255, 255, 255);
        this.utilColorMap.addBreak(101, 0, 0, 55, 201, 0, 0, 255);
        this.utilColorMap.addBreak(202, 0, 255, 0, 255, 0, 255, 0);
        this.stl.setColorMap(this.utilColorMap);
    }

    void setStlPanelData() {
        double verSize;
        double horSize;
        if (this.validPEs == null) {
            horSize = MainWindow.runObject[this.myRun].getTotalTime();
            verSize = MainWindow.runObject[this.myRun].getNumProcessors();
        } else {
            horSize = this.endTime - this.startTime;
            if (horSize <= 0.0) {
                horSize = MainWindow.runObject[this.myRun].getTotalTime();
            }
            verSize = this.validPEs.size();
        }
        this.scalePanel.setScales(horSize, verSize);
        double hMin = this.scalePanel.toSlider(1.0 / horSize);
        double hMax = this.scalePanel.toSlider(0.01);
        this.hor.setMin(hMin);
        this.hor.setMax(hMax);
        this.hor.setValue(hMin);
        this.hor.setTicks(Math.floor(hMin), 1.0);
        double vMin = this.scalePanel.toSlider(1.0 / verSize);
        double vMax = this.scalePanel.toSlider(1.0);
        this.ver.setMin(vMin);
        this.ver.setMax(vMax);
        this.ver.setValue(vMin);
        this.ver.setTicks(Math.floor(vMin), 1.0);
    }

    private void createMenus() {
        MenuBar mbar = new MenuBar();
        mbar.add(Util.makeMenu("File", new Object[]{"Close"}, this));
        mbar.add(Util.makeMenu("Modify", new Object[]{"Set Range"}, this));
        this.setMenuBar(mbar);
    }

    public void showDialog() {
        try {
            if (this.dialog == null) {
                this.dialog = new RangeDialog(this, "Select Range");
            } else {
                this.setDialogData();
            }
            this.dialog.displayDialog();
            if (!this.dialog.isCancelled()) {
                this.getDialogData();
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        StlWindow.this.thisWindow.setVisible(false);
                        StlWindow.this.thisWindow.setStlPanelData();
                        StlWindow.this.stl.resetMode();
                        StlWindow.this.utilizationMode.setSelected(true);
                        StlWindow.this.stl.setData(StlWindow.this.validPEs, StlWindow.this.startTime, StlWindow.this.endTime);
                        return null;
                    }

                    public void finished() {
                        StlWindow.this.thisWindow.setVisible(true);
                        StlWindow.this.thisWindow.repaint();
                    }
                };
                worker.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof MenuItem) {
            MenuItem mi = (MenuItem)evt.getSource();
            String arg = mi.getLabel();
            if (arg.equals("Close")) {
                this.close();
            }
            if (arg.equals("Set Range")) {
                this.showDialog();
            }
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            JRadioButton button = (JRadioButton)evt.getItemSelectable();
            if (button == this.utilizationMode) {
                this.mode = 0;
            } else if (button == this.epMode) {
                this.mode = 1;
            }
            this.stl.setMode(this.mode);
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
        Component src = evt.getComponent();
        if (src == this.hor) {
            this.setStatus("Click or drag to set the horizontal zoom");
        }
        if (src == this.ver) {
            this.setStatus("Click or drag to set the vertical zoom");
        }
    }

    public void mouseExited(MouseEvent evt) {
        this.setStatus("");
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void setStatus(String msg) {
        this.status.setText(msg);
    }

    public void getDialogData() {
        this.validPEs = this.dialog.getValidProcessors();
        this.startTime = this.dialog.getStartTime();
        this.endTime = this.dialog.getEndTime();
    }

    public void setDialogData() {
        this.dialog.setValidProcessors(this.validPEs);
        this.dialog.setStartTime(this.startTime);
        this.dialog.setEndTime(this.endTime);
        super.setDialogData();
    }
}

