/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public abstract class MenuManager
implements ActionListener,
ItemListener {
    JMenuBar menubar;
    JFrame parent;

    public MenuManager(JFrame parent) {
        this.parent = parent;
        this.menubar = new JMenuBar();
        parent.setJMenuBar(this.menubar);
    }

    JMenu makeJMenu(Object parent, Object[] items) {
        JMenu m = null;
        if (parent instanceof JMenu) {
            m = (JMenu)parent;
        } else if (parent instanceof String) {
            m = new JMenu((String)parent);
        } else {
            return null;
        }
        int i = 0;
        while (i < items.length) {
            JMenuItem cmi;
            JMenuItem mi;
            if (items[i] instanceof String) {
                mi = new JMenuItem((String)items[i]);
                mi.addActionListener(this);
                m.add(mi);
            } else if (items[i] instanceof JCheckBoxMenuItem) {
                cmi = (JCheckBoxMenuItem)items[i];
                cmi.addItemListener(this);
                m.add(cmi);
            } else if (items[i] instanceof JRadioButtonMenuItem) {
                cmi = (JRadioButtonMenuItem)items[i];
                cmi.addActionListener(this);
                m.add(cmi);
            } else if (items[i] instanceof JMenuItem) {
                mi = (JMenuItem)items[i];
                mi.addActionListener(this);
                m.add(mi);
            } else if (items[i] == null) {
                m.addSeparator();
            }
            ++i;
        }
        return m;
    }

    void setEnabled(JMenu menu, boolean[] enableItems) {
        if (enableItems.length != menu.getItemCount()) {
            System.err.println("Projections Error: Menu items inconsistent!");
            System.exit(-1);
        } else {
            int i = 0;
            while (i < enableItems.length) {
                JMenuItem menuEntry = menu.getItem(i);
                if (menuEntry instanceof JMenuItem) {
                    menuEntry.setEnabled(enableItems[i]);
                }
                ++i;
            }
        }
    }

    void setEnabled(JMenu menu, int index, boolean enable) {
        if (menu.getItemCount() > index) {
            JMenuItem menuEntry = menu.getItem(index);
            if (menuEntry instanceof JMenuItem) {
                menuEntry.setEnabled(enable);
            }
        } else {
            System.err.println("Projections Error: Menu items inconsistent!");
            System.exit(-1);
        }
    }

    void setAllTo(JMenu menu, boolean setTo) {
        int i = 0;
        while (i < menu.getItemCount()) {
            JMenuItem menuEntry = menu.getItem(i);
            if (menuEntry instanceof JMenuItem) {
                menuEntry.setEnabled(setTo);
            }
            ++i;
        }
    }

    abstract void stateChanged(int var1);

    public void actionPerformed(ActionEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
    }
}

