/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Vector;

public class ProjectionsFileMgr {
    private File[] stsFiles_ = null;
    private File[][] logFiles_ = null;
    String base_ = null;
    String extention_ = null;

    public ProjectionsFileMgr(String[] fileNames) {
        this.stsFiles_ = new File[fileNames.length];
        this.logFiles_ = new File[fileNames.length][];
        int i = 0;
        while (i < fileNames.length) {
            this.stsFiles_[i] = new File(fileNames[i]);
            this.logFiles_[i] = this.findFiles(fileNames[i]);
            ++i;
        }
    }

    public ProjectionsFileMgr(Vector files) throws IOException {
        this.stsFiles_ = new File[files.size()];
        this.logFiles_ = new File[files.size()][];
        int i = 0;
        while (i < files.size()) {
            this.stsFiles_[i] = (File)files.elementAt(i);
            this.logFiles_[i] = this.findFiles(this.stsFiles_[i].getCanonicalPath());
            ++i;
        }
    }

    public void printSts() {
        int i = 0;
        while (i < this.stsFiles_.length) {
            int j = 0;
            while (j < this.logFiles_[i].length) {
                File[] cfr_ignored_0 = this.logFiles_[i];
                ++j;
            }
            ++i;
        }
    }

    public File getStsFile(int index) {
        if (this.stsFiles_ != null) {
            return this.stsFiles_[index];
        }
        return null;
    }

    public int getNumFiles() {
        if (this.stsFiles_ != null) {
            return this.stsFiles_.length;
        }
        return 0;
    }

    public File[] getLogFiles(int idx) {
        if (this.logFiles_ != null) {
            return this.logFiles_[idx];
        }
        return null;
    }

    private File[] findFiles(String stsPathName) {
        int lastDotIndex;
        File stsFile = new File(stsPathName);
        File stsDir = new File(stsFile.getParent());
        if (!stsDir.isDirectory()) {
            return null;
        }
        String stsFileName = stsFile.getName();
        int nextDotIndex = stsFileName.lastIndexOf(".", (lastDotIndex = stsFileName.lastIndexOf(".")) - 1);
        if (nextDotIndex != -1) {
            this.base_ = stsFileName.substring(0, nextDotIndex);
            this.extention_ = stsPathName.endsWith(".sts") ? stsFileName.substring(nextDotIndex + 1, lastDotIndex) : stsFileName.substring(lastDotIndex + 1, stsFileName.length());
        } else {
            this.base_ = stsFileName.substring(0, lastDotIndex - 1);
            this.extention_ = ".log";
        }
        String[] logFiles = stsDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(ProjectionsFileMgr.this.base_) && name.endsWith(ProjectionsFileMgr.this.extention_) && name.indexOf(".sts") == -1;
            }
        });
        File[] returnVal = new File[logFiles.length];
        int i = 0;
        while (i < returnVal.length) {
            returnVal[i] = new File(stsDir, logFiles[i]);
            ++i;
        }
        return returnVal;
    }
}

