/*
 * Decompiled with CFR 0.152.
 */
package projections.misc;

public class ProjectionsStatistics {
    protected long count;
    protected double sum;
    protected double sumOfSquares;
    protected double max;
    protected double min;

    public void accumulate(double item) {
        this.addData(item);
    }

    public void accumulate(double[] items) {
        int i = 0;
        while (i < items.length) {
            this.addData(items[i]);
            ++i;
        }
    }

    public void reset() {
        this.count = 0L;
        this.sum = 0.0;
        this.sumOfSquares = 0.0;
        this.max = Double.MIN_VALUE;
        this.min = Double.MAX_VALUE;
    }

    private void addData(double item) {
        ++this.count;
        this.sum += item;
        this.sumOfSquares += item * item;
        if (item > this.max) {
            this.max = item;
        }
        if (item < this.min) {
            this.min = item;
        }
    }

    public long getCount() {
        return this.count;
    }

    public double getSum() {
        return this.sum;
    }

    public double getMean() {
        return this.sum / (double)this.count;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getVariance() {
        double mean = this.getMean();
        return (this.sumOfSquares - 2.0 * mean * this.sum + mean * mean * (double)this.count) / (double)(this.count - 1L);
    }

    public double getVariance(double mean) {
        return (this.sumOfSquares - 2.0 * mean * this.sum + mean * mean * (double)this.count) / (double)(this.count - 1L);
    }

    public double getStdDeviation() {
        double variance = this.getVariance();
        return Math.sqrt(variance);
    }

    public double getStdDeviation(double variance) {
        return Math.sqrt(variance);
    }
}

