/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import projections.gui.GraphData;
import projections.gui.MainWindow;
import projections.gui.Util;

public class GraphWAxisCanvas
extends Canvas {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private GraphData data;
    private int width = 0;
    private int textheight = 0;
    private int labelwidth = 0;
    private int labelincrement = 0;
    private double deltay = 0.0;

    public GraphWAxisCanvas() {
        this.setBackground(MainWindow.runObject[this.myRun].background);
        this.setForeground(MainWindow.runObject[this.myRun].foreground);
    }

    public int getPreferredWidth() {
        Graphics g;
        if (this.width == 0 && (g = this.getGraphics()) != null) {
            FontMetrics fm = g.getFontMetrics(g.getFont());
            this.width = fm.stringWidth("100") + fm.stringWidth("%") + 20;
            g.dispose();
        }
        return this.width;
    }

    public void paint(Graphics g) {
        if (this.data == null) {
            return;
        }
        int w = this.getSize().width;
        int h = this.getSize().height - this.data.offset2;
        g.setColor(MainWindow.runObject[this.myRun].background);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.textheight == 0) {
            FontMetrics fm = g.getFontMetrics(g.getFont());
            this.textheight = fm.getHeight();
            this.labelwidth = fm.stringWidth("%");
        }
        g.setColor(MainWindow.runObject[this.myRun].foreground);
        g.drawString("%", w - 5 - this.labelwidth, h / 2);
        g.drawLine(5, this.data.offset, 5, h - 1);
        int y = 0;
        while (y <= 100) {
            int cury = h - (int)((double)y * this.deltay) - 1;
            if (y % this.labelincrement == 0) {
                g.drawLine(0, cury, 10, cury);
                g.drawString("" + y, 15, cury += (int)(0.5 * (double)this.textheight));
            } else {
                g.drawLine(3, cury, 7, cury);
            }
            ++y;
        }
    }

    public void print(Graphics pg) {
        ((Graphics2D)pg).setBackground(Color.white);
        this.setForeground(Color.black);
        int w = this.getSize().width;
        int h = this.getSize().height;
        pg.clearRect(0, 0, w, h);
        this.paint(pg);
        ((Graphics2D)pg).setBackground(Color.black);
        this.setForeground(Color.white);
    }

    public void setBounds(int x, int y, int w, int h) {
        if (this.textheight == 0) {
            Graphics g = this.getGraphics();
            FontMetrics fm = g.getFontMetrics(g.getFont());
            this.textheight = fm.getHeight();
            this.labelwidth = fm.stringWidth("%");
            g.dispose();
        }
        this.deltay = (double)(h - this.data.offset - this.data.offset2) / 100.0;
        this.labelincrement = (int)Math.ceil((double)(this.textheight + 10) / this.deltay);
        this.labelincrement = Util.getBestIncrement(this.labelincrement);
        this.data.wscale = this.deltay;
        super.setBounds(x, y, w, h);
    }

    public void setData(GraphData data) {
        this.data = data;
    }
}

