/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import projections.gui.Bubble;

public class ProfileObject
extends Component
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private float usage;
    private String name;
    private String[] bubbletext;
    private Bubble bubble;
    private boolean inside = false;

    public ProfileObject(float u, String s, int p) {
        this.usage = u;
        this.name = s;
        this.bubbletext = new String[3];
        this.bubbletext[0] = s;
        NumberFormat df = NumberFormat.getInstance();
        this.bubbletext[1] = "USAGE: " + df.format(u) + "%";
        this.bubbletext[2] = p == -1 ? "Average" : "Processor " + p;
        this.addMouseListener(this);
    }

    public String getName() {
        return this.name;
    }

    public float getUsage() {
        return this.usage;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
        if (!this.inside) {
            this.inside = true;
            ProfileObject po = this;
            Point scrnloc = po.getLocationOnScreen();
            Dimension size = this.getSize();
            if (this.bubble == null) {
                this.bubble = new Bubble(this, this.bubbletext);
            }
            this.bubble.setLocation(scrnloc.x + evt.getX(), scrnloc.y + evt.getY() + 2);
            this.bubble.setVisible(true);
        }
    }

    public void mouseExited(MouseEvent evt) {
        if (this.inside) {
            if (this.bubble != null) {
                this.bubble.dispose();
            }
            this.inside = false;
        }
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void paint(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        Color c = this.name.equals("MESSAGE PACKING") ? Color.pink : (this.name.equals("OVERHEAD") ? Color.white : (this.name.equals("IDLE") ? Color.white : this.getForeground()));
        g.setColor(c);
        g.fillRect(0, 0, w, h);
        if (this.name.equals("OVERHEAD")) {
            g.setColor(Color.black);
            int i = 0;
            while (i < h + w) {
                g.drawLine(i, 0, 0, i);
                g.drawLine(i + 1, 0, 0, i + 1);
                i += 4;
            }
        }
    }
}

