/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PrinterGraphics;
import projections.gui.FloatTextField;
import projections.gui.GraphData;
import projections.gui.GraphDisplayCanvas;
import projections.gui.GraphTitleCanvas;
import projections.gui.GraphWAxisCanvas;
import projections.gui.GraphXAxisCanvas;
import projections.gui.GraphYAxisCanvas;
import projections.gui.MainWindow;
import projections.gui.Util;

public class GraphDisplayPanel
extends Container
implements ActionListener,
ItemListener,
AdjustmentListener {
    int myRun = 0;
    private GraphData data;
    Panel mainPanel;
    private GraphTitleCanvas titleCanvas;
    private GraphYAxisCanvas yAxisCanvas;
    private GraphXAxisCanvas xAxisCanvas;
    private GraphWAxisCanvas wAxisCanvas;
    private GraphDisplayCanvas displayCanvas;
    private Scrollbar HSB;
    private Button bIncreaseX;
    private Button bDecreaseX;
    private Button bResetX;
    private Checkbox cbLineGraph;
    private Checkbox cbBarGraph;
    private Label lScale;
    private FloatTextField scaleField;

    public GraphDisplayPanel() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (GraphDisplayPanel.this.mainPanel != null) {
                    GraphDisplayPanel.this.setAllBounds();
                    GraphDisplayPanel.this.UpdateDisplay();
                }
            }
        });
        this.setBackground(Color.lightGray);
        this.mainPanel = new Panel();
        this.titleCanvas = new GraphTitleCanvas();
        this.yAxisCanvas = new GraphYAxisCanvas();
        this.wAxisCanvas = new GraphWAxisCanvas();
        this.xAxisCanvas = new GraphXAxisCanvas();
        this.displayCanvas = new GraphDisplayCanvas();
        this.HSB = new Scrollbar(0, 0, 1, 0, 1);
        this.mainPanel.setLayout(null);
        this.mainPanel.setBackground(MainWindow.runObject[this.myRun].background);
        this.mainPanel.setForeground(MainWindow.runObject[this.myRun].foreground);
        this.mainPanel.add(this.titleCanvas);
        this.mainPanel.add(this.yAxisCanvas);
        this.mainPanel.add(this.wAxisCanvas);
        this.mainPanel.add(this.xAxisCanvas);
        this.mainPanel.add(this.displayCanvas);
        this.mainPanel.add(this.HSB);
        this.HSB.setBackground(Color.lightGray);
        this.HSB.addAdjustmentListener(this);
        this.lScale = new Label("X-Axis Scale: ", 1);
        this.scaleField = new FloatTextField(1.0f, 5);
        this.scaleField.addActionListener(this);
        this.bDecreaseX = new Button("<<");
        this.bIncreaseX = new Button(">>");
        this.bResetX = new Button("Reset");
        this.bIncreaseX.addActionListener(this);
        this.bDecreaseX.addActionListener(this);
        this.bResetX.addActionListener(this);
        CheckboxGroup cbgGraphType = new CheckboxGroup();
        this.cbLineGraph = new Checkbox("Line Graph", false, cbgGraphType);
        this.cbBarGraph = new Checkbox("Bar Graph", true, cbgGraphType);
        this.cbLineGraph.addItemListener(this);
        this.cbBarGraph.addItemListener(this);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(gbl);
        Util.gblAdd(buttonPanel, this.cbLineGraph, gbc, 0, 0, 1, 1, 1, 0);
        Util.gblAdd(buttonPanel, this.cbBarGraph, gbc, 1, 0, 1, 1, 1, 0);
        Util.gblAdd(buttonPanel, this.bDecreaseX, gbc, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(buttonPanel, this.lScale, gbc, 3, 0, 1, 1, 1, 0);
        Util.gblAdd(buttonPanel, this.scaleField, gbc, 4, 0, 1, 1, 1, 0);
        Util.gblAdd(buttonPanel, this.bIncreaseX, gbc, 5, 0, 1, 1, 1, 0);
        Util.gblAdd(buttonPanel, this.bResetX, gbc, 6, 0, 1, 1, 1, 0);
        this.setLayout(gbl);
        gbc.fill = 1;
        Util.gblAdd(this, this.mainPanel, gbc, 0, 0, 1, 1, 1, 1, 10, 10, 10, 10);
        Util.gblAdd(this, buttonPanel, gbc, 0, 1, 1, 1, 1, 0, 10, 10, 10, 10);
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.data == null) {
            return;
        }
        float scale = this.data.scale;
        if (evt.getSource() instanceof Button) {
            Button b = (Button)evt.getSource();
            if (b == this.bDecreaseX) {
                if ((double)(scale = (float)((int)(scale * 4.0f) - 1) / 4.0f) < 1.0) {
                    scale = 1.0f;
                }
            } else if (b == this.bIncreaseX) {
                scale = (float)((int)(scale * 4.0f) + 1) / 4.0f;
            } else if (b == this.bResetX) {
                scale = 1.0f;
            }
            this.scaleField.setText("" + scale);
        } else {
            scale = this.scaleField.getValue();
        }
        if (scale > 1.0f) {
            this.HSB.setVisible(true);
        } else {
            this.HSB.setVisible(false);
        }
        int dcw = this.displayCanvas.getSize().width;
        int dw = (int)(scale * (float)dcw);
        this.HSB.setMaximum(dw);
        this.data.scale = scale;
        this.setAllBounds();
        this.xAxisCanvas.repaint();
        this.displayCanvas.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.xAxisCanvas.repaint();
        this.displayCanvas.repaint();
    }

    public int getHSBValue() {
        return this.HSB.getValue();
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(450, 350);
    }

    public void itemStateChanged(ItemEvent evt) {
        if (this.data == null) {
            return;
        }
        Checkbox c = (Checkbox)evt.getSource();
        if (c == this.cbLineGraph) {
            this.data.graphtype = 20;
        } else if (c == this.cbBarGraph) {
            this.data.graphtype = 21;
        }
        this.setAllBounds();
        this.UpdateDisplay();
    }

    public void paint(Graphics g) {
        if (g instanceof PrinterGraphics) {
            this.mainPanel.setBackground(Color.white);
        } else {
            this.mainPanel.setBackground(MainWindow.runObject[this.myRun].background);
        }
        super.paint(g);
    }

    public void refreshDisplay() {
        this.titleCanvas.repaint();
        this.yAxisCanvas.repaint();
        this.xAxisCanvas.repaint();
        this.wAxisCanvas.repaint();
        this.displayCanvas.repaint();
        this.mainPanel.setBackground(MainWindow.runObject[this.myRun].background);
        this.mainPanel.repaint();
    }

    public void setAllBounds() {
        if (this.data == null) {
            return;
        }
        int mpw = this.mainPanel.getSize().width;
        int mph = this.mainPanel.getSize().height;
        int tch = this.titleCanvas.getPreferredHeight();
        int ycw = this.yAxisCanvas.getPreferredWidth();
        int wcw = this.wAxisCanvas.getPreferredWidth();
        int xch = this.xAxisCanvas.getPreferredHeight();
        int sbh = 20;
        int dcw = mpw - ycw - wcw;
        int dch = mph - tch - xch - sbh;
        this.data.offset2 = xch;
        this.titleCanvas.setBounds(ycw, 0, dcw, tch);
        this.yAxisCanvas.setBounds(0, tch, ycw, dch + xch);
        this.wAxisCanvas.setBounds(mpw - wcw, tch, wcw, dch + xch);
        this.xAxisCanvas.setBounds(ycw, tch + dch, dcw, xch);
        this.displayCanvas.setBounds(ycw, tch, dcw, dch);
        this.HSB.setBounds(ycw, mph - sbh, dcw, sbh);
        this.HSB.setMaximum((int)(this.data.scale * (float)dcw));
        this.HSB.setVisibleAmount(dcw);
        this.HSB.setBlockIncrement(dcw);
        if (this.data.scale > 1.0f) {
            this.HSB.setVisible(true);
        } else {
            this.HSB.setVisible(false);
        }
    }

    public void setGraphData(GraphData data) {
        this.data = data;
        this.titleCanvas.setData(data);
        this.yAxisCanvas.setData(data);
        this.wAxisCanvas.setData(data);
        this.xAxisCanvas.setData(data);
        this.displayCanvas.setData(data);
    }

    public void UpdateDisplay() {
        this.titleCanvas.repaint();
        this.yAxisCanvas.repaint();
        this.wAxisCanvas.repaint();
        this.xAxisCanvas.repaint();
        this.displayCanvas.repaint();
    }
}

