/*
 * Decompiled with CFR 0.152.
 */
package charm.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;

public class Toolbar
extends Panel
implements MouseListener,
MouseMotionListener {
    private int curTool;
    private int nTools;
    private int tw;
    private int th;
    private Image tools;
    private Label status;
    private String[] toolDesc;
    private String savedStatus = "";

    public Toolbar(URL uRL, int n, int n2, int n3, Label label, String[] stringArray) {
        this.tw = n;
        this.th = n2;
        this.nTools = n3;
        this.curTool = 0;
        this.tools = null;
        try {
            this.tools = Toolkit.getDefaultToolkit().getImage(uRL);
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.tools, 0);
            mediaTracker.waitForID(0);
        }
        catch (Exception exception) {
            System.out.println("Error loading toolbar image " + uRL);
            exception.printStackTrace();
        }
        this.status = label;
        this.toolDesc = stringArray;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.tw, this.th * this.nTools);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.tw, this.th * this.nTools);
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.tw, 30000);
    }

    public void setTool(int n) {
        if (n != this.curTool) {
            this.curTool = n;
            this.repaint(20L);
        }
    }

    public int getTool() {
        return this.curTool;
    }

    private int toTool(MouseEvent mouseEvent) {
        int n = mouseEvent.getY() / this.th;
        if (n >= this.nTools) {
            return -1;
        }
        return n;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.toolDesc == null || this.toTool(mouseEvent) == -1) {
            this.status.setText("");
        } else {
            this.status.setText(this.toolDesc[this.toTool(mouseEvent)]);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.toTool(mouseEvent) != -1) {
            this.setTool(this.toTool(mouseEvent));
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.savedStatus = this.status.getText();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.status.setText(this.savedStatus);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        for (int i = 0; i < this.nTools; ++i) {
            int n3 = 0;
            int n4 = i * this.th;
            int n5 = 0;
            int n6 = i * this.th;
            if (i == this.curTool) {
                n3 += this.tw;
            }
            graphics.drawImage(this.tools, n5, n6, n5 + this.tw, n6 + this.th, n3, n4, n3 + this.tw, n4 + this.th, null);
        }
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, this.nTools * this.th, n, n2);
    }
}

