/*
 * Decompiled with CFR 0.152.
 */
package charm.ccs;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.Random;

public class CcsServer {
    private Request lastRequest;
    private MessageDigest SHA;
    private final int SHA_len = 20;
    private boolean isAuth = false;
    private byte[] key;
    private int level;
    private Random rand;
    protected int clientID;
    protected int clientSalt;
    protected InetAddress hostIP;
    protected int hostPort;
    protected int numNodes;
    protected int numPes;
    protected int[] nodeFirst;
    protected int[] nodeSize;
    protected static boolean printDebug = false;

    public CcsServer(InetAddress inetAddress, int n, byte[] byArray) throws IOException {
        this.connect(inetAddress, n, byArray);
    }

    public CcsServer(String string, int n, byte[] byArray) throws IOException, UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string);
        this.connect(inetAddress, n, byArray);
    }

    public CcsServer(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress, n, null);
    }

    public CcsServer(String string, int n) throws IOException, UnknownHostException {
        this(string, n, null);
    }

    public CcsServer(String string, byte[] byArray) throws IOException, NumberFormatException {
        int n = string.indexOf("=");
        int n2 = string.indexOf("=", n + 1);
        String string2 = string.substring(n + 1, string.indexOf(",")).trim();
        String string3 = string.substring(n2 + 1, string.indexOf("$")).trim();
        long l = Long.parseLong(string2);
        int n3 = Integer.parseInt(string3);
        if (l < 0L) {
            l += 0x100000000L;
        }
        String string4 = "";
        for (int i = 3; i >= 0; --i) {
            Long l2 = new Long(0xFFL & l >> 8 * i);
            string4 = string4 + l2.toString();
            if (i <= 0) continue;
            string4 = string4 + ".";
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string4);
        }
        catch (UnknownHostException unknownHostException) {
            throw new NumberFormatException(unknownHostException.toString());
        }
        this.connect(inetAddress, n3, byArray);
    }

    public Request sendRequest(String string, int n) throws IOException {
        return this.sendRequest(string, n, null);
    }

    public Request sendRequest(String string, int n, byte[] byArray) throws IOException {
        Request request2;
        CcsServer.debug("  Connecting for request '" + string + "'");
        Socket socket = new Socket(this.hostIP, this.hostPort);
        CcsServer.debug("  Connected.  Sending header");
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        int n3 = 8;
        int n4 = 32;
        int n5 = n3 + n4;
        byte[] byArray2 = new byte[n5];
        CcsServer.writeInt(byArray2, 0, n2);
        CcsServer.writeInt(byArray2, 4, n);
        CcsServer.writeString(byArray2, 8, n4, string);
        int n6 = 0;
        if (this.isAuth) {
            CcsServer.debug("  Sending authentication for level " + this.level);
            dataOutputStream.writeInt(Integer.MIN_VALUE | this.level);
            n6 = this.rand.nextInt();
            dataOutputStream.writeInt(this.clientID);
            dataOutputStream.writeInt(n6);
            dataOutputStream.write(this.SHA_makeHash(this.key, this.clientSalt++, byArray2));
        }
        dataOutputStream.write(byArray2, 0, n5);
        CcsServer.debug("  Header sent.  Sending " + n2 + " bytes of request data");
        if (byArray != null) {
            dataOutputStream.write(byArray);
        }
        dataOutputStream.flush();
        CcsServer.debug("  Request sent");
        this.lastRequest = request2 = new Request(socket, n6);
        return request2;
    }

    public byte[] recvResponse() throws IOException {
        return this.recvResponse(this.lastRequest);
    }

    public byte[] recvResponse(Request request2) throws IOException {
        CcsServer.debug("  Waiting for response");
        DataInputStream dataInputStream = new DataInputStream(request2.sock.getInputStream());
        if (this.isAuth) {
            byte[] byArray = new byte[20];
            dataInputStream.readFully(byArray);
            if (!this.SHA_checkHash(this.key, request2.salt, null, byArray)) {
                CcsServer.abort("Server's key does not match ours (during response)!");
            }
        }
        int n = dataInputStream.readInt();
        CcsServer.debug("  Response will be " + n + " bytes");
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        CcsServer.debug("  Got entire response");
        request2.sock.close();
        request2.sock = null;
        return byArray;
    }

    public boolean hasResponse(Request request2) throws IOException {
        return request2.sock.getInputStream().available() > 0;
    }

    public void close(Request request2) {
        if (request2.sock != null) {
            try {
                request2.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            request2.sock = null;
        }
    }

    public void close() {
        this.close(this.lastRequest);
        this.lastRequest = null;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public int getNumPes() {
        return this.numPes;
    }

    public int getNodeFirst(int n) {
        return this.nodeFirst[n];
    }

    public int getNodeSize(int n) {
        return this.nodeSize[n];
    }

    public static final int readInt(byte[] byArray, int n) {
        return ((0xFF & byArray[n + 0]) << 24) + ((0xFF & byArray[n + 1]) << 16) + ((0xFF & byArray[n + 2]) << 8) + ((0xFF & byArray[n + 3]) << 0);
    }

    public static final float readFloat(byte[] byArray, int n) {
        return Float.intBitsToFloat(CcsServer.readInt(byArray, n));
    }

    public static final long readLong(byte[] byArray, int n) {
        return ((0xFFL & (long)byArray[n + 0]) << 56) + ((0xFFL & (long)byArray[n + 1]) << 48) + ((0xFFL & (long)byArray[n + 2]) << 40) + ((0xFFL & (long)byArray[n + 3]) << 32) + ((0xFFL & (long)byArray[n + 4]) << 24) + ((0xFFL & (long)byArray[n + 5]) << 16) + ((0xFFL & (long)byArray[n + 6]) << 8) + ((0xFFL & (long)byArray[n + 7]) << 0);
    }

    public static final double readDouble(byte[] byArray, int n) {
        return Double.longBitsToDouble(CcsServer.readLong(byArray, n));
    }

    public static final void writeInt(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 >>> 24);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 3] = (byte)(n2 >>> 0);
    }

    public static final void writeFloat(byte[] byArray, int n, float f) {
        CcsServer.writeInt(byArray, n, Float.floatToRawIntBits(f));
    }

    public static final void writeLong(byte[] byArray, int n, long l) {
        byArray[n + 0] = (byte)(l >>> 56);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 7] = (byte)(l >>> 0);
    }

    public static final void writeDouble(byte[] byArray, int n, double d) {
        CcsServer.writeLong(byArray, n, Double.doubleToRawLongBits(d));
    }

    public static final void writeBytes(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3;
        int n4 = n2;
        if (n4 > byArray2.length) {
            n4 = byArray2.length;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            byArray[n + n3] = byArray2[n3];
        }
        for (n3 = n4; n3 < n2; ++n3) {
            byArray[n + n3] = 0;
        }
    }

    public static final void writeString(byte[] byArray, int n, int n2, String string) {
        int n3;
        int n4 = n2;
        if (n4 > string.length()) {
            n4 = string.length();
        }
        for (n3 = 0; n3 < n4; ++n3) {
            byArray[n + n3] = (byte)string.charAt(n3);
        }
        for (n3 = n4; n3 < n2; ++n3) {
            byArray[n + n3] = 0;
        }
    }

    private final byte[] SHA_makeMessage() {
        return new byte[52];
    }

    private byte[] SHA_digestMessage(byte[] byArray) {
        this.SHA.reset();
        this.SHA.update(byArray);
        return this.SHA.digest();
    }

    private byte[] SHA_makeHash(byte[] byArray, int n, byte[] byArray2) {
        byte[] byArray3 = this.SHA_makeMessage();
        CcsServer.writeBytes(byArray3, 0, 16, byArray);
        CcsServer.writeInt(byArray3, 16, n);
        if (byArray2 != null) {
            CcsServer.writeBytes(byArray3, 20, 16, byArray2);
        }
        byte[] byArray4 = this.SHA_digestMessage(byArray3);
        return byArray4;
    }

    private boolean SHA_checkHash(byte[] byArray, int n, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = this.SHA_makeHash(byArray, n, byArray2);
        for (int i = 0; i < 20; ++i) {
            if (byArray3[i] == byArray4[i]) continue;
            return false;
        }
        return true;
    }

    protected void authenticate(byte[] byArray) throws IOException {
        int n;
        this.isAuth = true;
        long l = System.currentTimeMillis();
        this.key = new byte[16];
        for (n = 0; n < byArray.length; ++n) {
            this.key[n] = byArray[n];
            l ^= (long)(this.key[n] << n);
        }
        this.rand = new Random(l);
        n = 0;
        while ((long)n < (long)(10 + byArray.length) + (l & 0xFL)) {
            this.rand.nextInt();
            ++n;
        }
        try {
            this.SHA = MessageDigest.getInstance("SHA");
        }
        catch (Exception exception) {
            CcsServer.abort("Couldn't load SHA hash code!");
        }
        this.level = 0;
        CcsServer.debug("  Connecting for authentication");
        Socket socket = new Socket(this.hostIP, this.hostPort);
        CcsServer.debug("  Connected.  Sending request");
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
        int n2 = this.rand.nextInt();
        int n3 = 0;
        try {
            dataOutputStream.writeInt(0x80000100 | this.level);
            dataOutputStream.writeInt(n2);
            n3 = dataInputStream.readInt();
        }
        catch (IOException iOException) {
            CcsServer.abort("Server does not use authentication!");
        }
        byte[] byArray2 = new byte[20];
        try {
            dataOutputStream.write(this.SHA_makeHash(this.key, n3, null));
            dataInputStream.readFully(byArray2);
        }
        catch (EOFException eOFException) {
            CcsServer.abort("Server does not accept our key!");
        }
        if (!this.SHA_checkHash(this.key, n2, null, byArray2)) {
            CcsServer.abort("Server's key does not match ours (during initial check)!");
        }
        this.clientID = dataInputStream.readInt();
        this.clientSalt = dataInputStream.readInt();
        CcsServer.debug("  I am client " + this.clientID + ".  My first salt is " + this.clientSalt + ".");
        socket.close();
        CcsServer.debug("  Authentication complete");
    }

    protected void connect(InetAddress inetAddress, int n, byte[] byArray) throws IOException {
        this.hostIP = inetAddress;
        this.hostPort = n;
        CcsServer.debug("Connecting...");
        if (byArray != null) {
            this.authenticate(byArray);
        }
        this.sendRequest("ccs_getinfo", 0);
        CcsServer.debug("Connected.  Getting machine info.");
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.recvResponse()));
        CcsServer.debug("Parsing machine info");
        this.numNodes = dataInputStream.readInt();
        this.nodeFirst = new int[this.numNodes];
        this.nodeSize = new int[this.numNodes];
        this.numPes = 0;
        for (int i = 0; i < this.numNodes; ++i) {
            this.nodeFirst[i] = this.numPes;
            this.nodeSize[i] = dataInputStream.readInt();
            this.numPes += this.nodeSize[i];
        }
    }

    protected static void debug(String string) {
        if (printDebug) {
            System.out.println("CcsServer: " + string);
        }
    }

    protected static void abort(String string) {
        System.out.println("CcsServer FATAL ERROR: " + string);
        System.exit(1);
    }

    public static byte[] parseKey(String string) {
        byte[] byArray = new byte[(string.length() + 1) / 2];
        for (int i = 0; i < string.length(); ++i) {
            int n = 16;
            if (i % 2 == 1) {
                n = 1;
            }
            int n2 = i / 2;
            byArray[n2] = (byte)(byArray[n2] + (byte)(n * Character.digit(string.charAt(i), 16)));
        }
        return byArray;
    }

    public static CcsServer create(String[] stringArray, boolean bl) {
        CcsServer ccsServer = null;
        if (stringArray.length < 2) {
            System.out.println("Usage: CcsServer <server DNS name or IP> <port> [ <authentication key>]");
        } else {
            printDebug = bl;
            String string = stringArray[0];
            int n = 0;
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                CcsServer.abort("Couldn't parse port number");
            }
            byte[] byArray = null;
            if (stringArray.length > 2) {
                byArray = CcsServer.parseKey(stringArray[2]);
            }
            try {
                ccsServer = new CcsServer(string, n, byArray);
            }
            catch (Exception exception) {
                CcsServer.abort("Error connecting to host:" + exception);
            }
        }
        return ccsServer;
    }

    public static void main(String[] stringArray) {
        CcsServer ccsServer = CcsServer.create(stringArray, true);
        System.out.println("The CCS server has " + ccsServer.getNumPes() + " processors.");
    }

    public static class Request {
        protected Socket sock;
        protected int salt;

        protected Request(Socket socket, int n) {
            this.sock = socket;
            this.salt = n;
        }
    }
}

