/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.ccs.CcsServer;
import charm.debug.CpdUtil;
import charm.debug.fmt.Verbose;
import charm.debug.inspect.Inspector;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class TinyClient {
    private CpdUtil cpd;

    private void decodeList(byte[] byArray) {
        Verbose verbose = new Verbose();
        verbose.decode(byArray);
    }

    public TinyClient(CcsServer ccsServer, String string, int n, int n2, int n3) {
        this.cpd = new CpdUtil(ccsServer);
        if (string == null) {
            string = "converse/lists";
        }
        if (string.equals("allocationTree")) {
            String string2 = Integer.toString(n);
            if (n == -1) {
                n = 0;
            }
            byte[] byArray = this.cpd.sendCcsRequestBytes("ccs_debug_allocationTree", string2, n);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
            int n4 = 0;
            while (n4 * 20 < byArray.length) {
                System.out.println(Long.toHexString(byteBuffer.getLong()) + " " + byteBuffer.getInt() + " " + byteBuffer.getInt() + " " + byteBuffer.getInt());
                ++n4;
            }
            for (n4 = 0; n4 < byArray.length; ++n4) {
                System.out.println(" " + Integer.toHexString(byArray[n4]));
            }
            return;
        }
        int n5 = this.cpd.getListLength(string, n);
        System.out.println("Cpd list " + string + " contains " + n5 + " items");
        Inspector.initialize(this.cpd);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = n5;
        }
        String string3 = this.cpd.stringList(string, n, n2, n3);
        System.out.println("\n------ Text version: \n" + string3);
        byte[] byArray = this.cpd.byteList(string, "fmt", n, n2, n3, null);
        System.out.println("\n------ Binary version (" + byArray.length + " bytes)");
        this.decodeList(byArray);
        System.out.println("string={" + string + "}" + string.equals("converse/memory"));
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: java client <host> <port> [ <list> [ <pe> ] [ <lo> [ <hi> ] ] ]");
            System.exit(1);
        }
        String[] stringArray2 = new String[]{stringArray[0], stringArray[1]};
        CcsServer ccsServer = CcsServer.create(stringArray2, false);
        System.out.println("Connected: The CCS server has " + ccsServer.getNumPes() + " processors.");
        String string = null;
        int n = 0;
        if (stringArray.length > 2) {
            string = stringArray[2];
        }
        if (stringArray.length > 3) {
            n = Integer.parseInt(stringArray[3]);
        }
        int n2 = -1;
        int n3 = -1;
        if (stringArray.length > 4) {
            n2 = Integer.parseInt(stringArray[4]);
        }
        if (stringArray.length > 5) {
            n3 = Integer.parseInt(stringArray[5]);
        }
        System.out.println("args " + stringArray.length + ": " + n2 + " " + n3);
        new TinyClient(ccsServer, string, n, n2, n3);
    }
}

