/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.ParDebug;
import charm.debug.inspect.GenericElement;
import charm.debug.inspect.Inspector;
import charm.debug.inspect.TypeVisitor;
import charm.debug.inspect.VisitableType;
import java.nio.ByteBuffer;

public abstract class GenericType
extends VisitableType {
    String name = null;

    GenericType() {
    }

    public GenericType build(String string) {
        return this.build(string, null);
    }

    public abstract GenericType build(String var1, String var2);

    public String getName() {
        return this.name;
    }

    public int getChildren() {
        return 0;
    }

    public GenericElement getChild(int n) {
        return null;
    }

    public abstract String getValue(TypeVisitor var1);

    public int getPointer() {
        return 0;
    }

    public int pointerSize() {
        if (Inspector.is64bit()) {
            return 8;
        }
        return 4;
    }

    public abstract int getSize();

    public String toString() {
        return this.toString("");
    }

    public abstract String toString(String var1);

    public String memoryToString(ByteBuffer byteBuffer) {
        return this.memoryToString("", byteBuffer, 0);
    }

    public abstract String memoryToString(String var1, ByteBuffer var2, int var3);

    static String getDescription(String string) {
        String string2 = ParDebug.infoCommand("ptype class " + string + "\n");
        System.out.println("info1:ptype " + string + " = " + string2);
        if (string2.length() == 0) {
            string2 = ParDebug.infoCommand("ptype " + string + "\n");
            System.out.println("info2:ptype " + string + " = " + string2);
        }
        if (string2.length() == 0) {
            System.out.println("info string is still null");
            return null;
        }
        if (!string2.startsWith("type =")) {
            System.out.println("incorrect description for " + string + ": " + string2);
            return null;
        }
        return string2.substring(6).trim();
    }

    static String printPointer(ByteBuffer byteBuffer, int n) {
        if (n < 0) {
            return "?";
        }
        if (Inspector.is64bit()) {
            return "0x" + Long.toHexString(byteBuffer.getLong(n));
        }
        return "0x" + Integer.toHexString(byteBuffer.getInt(n));
    }
}

