/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.CpdUtil;
import charm.debug.inspect.DataType;
import charm.debug.inspect.GenericType;
import charm.debug.inspect.PrimitiveType;
import java.nio.ByteOrder;
import java.util.Hashtable;

public class Inspector {
    private static Hashtable allTypes;
    private static ByteOrder byteOrder;
    private static boolean addressSpace64;
    private static int sizeInt;
    private static int sizeLong;
    private static int sizeLongLong;
    private static int sizeBool;

    public static void initialize(CpdUtil cpdUtil) {
        allTypes = new Hashtable();
        allTypes.put("int", new PrimitiveType("int"));
        allTypes.put("unsigned int", new PrimitiveType("unsigned int"));
        allTypes.put("short", new PrimitiveType("short"));
        allTypes.put("unsigned short", new PrimitiveType("unsigned short"));
        allTypes.put("long", new PrimitiveType("long"));
        allTypes.put("unsigned long", new PrimitiveType("unsigned long"));
        allTypes.put("long long", new PrimitiveType("long long"));
        allTypes.put("unsigned long long", new PrimitiveType("unsigned long long"));
        allTypes.put("char", new PrimitiveType("char"));
        allTypes.put("unsigned char", new PrimitiveType("unsigned char"));
        allTypes.put("void", new PrimitiveType("void"));
        allTypes.put("float", new PrimitiveType("float"));
        allTypes.put("double", new PrimitiveType("double"));
        allTypes.put("bool", new PrimitiveType("bool"));
        byte[] byArray = cpdUtil.sendCcsRequest("ccs_machine_architecture", "", 0).getBytes();
        System.out.print("Machine is ");
        if (byArray[0] == 1) {
            System.out.print("32 bit, ");
            addressSpace64 = false;
        } else if (byArray[0] == 2) {
            System.out.print("64 bit, ");
            addressSpace64 = true;
        } else {
            System.out.print("unknown pointer size, ");
        }
        if (byArray[1] == 1) {
            System.out.println("little endian");
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else {
            System.out.println("big endian");
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        sizeInt = byArray[2];
        sizeLong = byArray[3];
        sizeLongLong = byArray[4];
        sizeBool = byArray[5];
    }

    public static ByteOrder getByteOrder() {
        return byteOrder;
    }

    public static boolean is64bit() {
        return addressSpace64;
    }

    public static int getIntSize() {
        return sizeInt;
    }

    public static int getLongSize() {
        return sizeLong;
    }

    public static int getLongLongSize() {
        return sizeLongLong;
    }

    public static int getBoolSize() {
        return sizeBool;
    }

    public static GenericType getTypeCreate(String string) {
        GenericType genericType = (GenericType)allTypes.get(string);
        if (genericType == null) {
            DataType dataType = new DataType();
            allTypes.put(string, dataType);
            dataType.build(string);
            genericType = dataType;
        }
        return genericType;
    }

    public static GenericType getType(String string) {
        GenericType genericType = (GenericType)allTypes.get(string);
        return genericType;
    }

    public static void putType(String string, GenericType genericType) {
        allTypes.put(string, genericType);
    }
}

