/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.inspect.DataType;
import charm.debug.inspect.GenericElement;
import charm.debug.inspect.GenericType;
import charm.debug.inspect.Inspector;
import charm.debug.inspect.TypeVisitor;
import java.nio.ByteBuffer;

public class TypedefType
extends GenericType {
    GenericType real;
    int pointer;

    public GenericType build(String string, String string2) {
        int n;
        String string3 = this.name = string;
        String string4 = string2;
        int n2 = 0;
        do {
            n = 0;
            for (int i = string4.length() - 1; i >= 0 && string4.charAt(i) == '*'; --i) {
                ++n;
            }
            n2 += n;
        } while ((string4 = TypedefType.getDescription(string3 = string4.substring(0, string4.length() - n).trim())).indexOf("{") == -1 && !string4.equals(string3));
        System.out.println("realName: " + string3);
        GenericType genericType = Inspector.getType(string3);
        if (genericType == null) {
            genericType = new DataType();
            Inspector.putType(string3, genericType);
            genericType.build(string3, string4);
        }
        this.real = genericType;
        this.pointer = n2;
        return this;
    }

    public GenericType build(String string, DataType dataType, int n) {
        this.name = string;
        this.pointer = n;
        this.real = dataType;
        return this;
    }

    public int getChildren() {
        return this.real.getChildren();
    }

    public GenericElement getChild(int n) {
        return this.real.getChild(n);
    }

    public String getValue(TypeVisitor typeVisitor) {
        StringBuffer stringBuffer = new StringBuffer(this.real.getName());
        for (int i = 0; i < this.pointer; ++i) {
            stringBuffer.append('*');
        }
        if (this.real.getChildren() == 0) {
            stringBuffer.append(' ').append(this.real.getValue(typeVisitor));
        }
        return stringBuffer.toString();
    }

    public int getPointer() {
        return this.pointer;
    }

    public boolean isVirtual() {
        if (this.real instanceof DataType) {
            return ((DataType)this.real).isVirtual;
        }
        return false;
    }

    public int getSize() {
        if (this.pointer > 0) {
            return this.pointerSize();
        }
        return this.real.getSize();
    }

    public String toString(String string) {
        System.out.println("typedef: |" + this.name + "| to |" + this.real.getName() + "|");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name).append(" (");
        stringBuffer.append(this.real.toString(string)).append(")");
        if (this.pointer > 0) {
            stringBuffer.append(" ");
            for (int i = 0; i < this.pointer; ++i) {
                stringBuffer.append("*");
            }
        }
        return stringBuffer.toString();
    }

    public String memoryToString(String string, ByteBuffer byteBuffer, int n) {
        if (this.pointer > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.real.getName());
            for (int i = 0; i < this.pointer; ++i) {
                stringBuffer.append("*");
            }
            stringBuffer.append(" ").append(TypedefType.printPointer(byteBuffer, n));
            return stringBuffer.toString();
        }
        return this.real.getName() + " " + this.real.memoryToString(string, byteBuffer, n);
    }

    public void visit(TypeVisitor typeVisitor) {
        if (this.pointer > 0) {
            typeVisitor.setPointer(this.pointer);
            typeVisitor.addValue(typeVisitor.printPointer());
        } else {
            typeVisitor.addValue(this.real.getName());
            typeVisitor.push();
            this.real.visit(typeVisitor);
            typeVisitor.pop();
        }
    }
}

