/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPanel;
import projections.gui.Timeline.Data;

public class LabelPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Data data;

    public LabelPanel(Data data) {
        this.setOpaque(true);
        this.data = data;
    }

    private int preferredWidth() {
        if (this.data.useMinimalView()) {
            return 60;
        }
        return 90;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredWidth(), this.data.screenHeight());
    }

    protected void paintComponent(Graphics g) {
        g.setFont(this.data.labelFont);
        FontMetrics fm = g.getFontMetrics();
        g.setColor(this.data.getBackgroundColor());
        Rectangle clipBounds = g.getClipBounds();
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        g.setColor(this.data.getForegroundColor());
        this.data.processorList().reset();
        int p = 0;
        while (p < this.data.numPs()) {
            String peString;
            if (this.data.useMinimalView()) {
                peString = "PE " + this.data.processorList().nextElement();
                int stringWidth = fm.stringWidth(peString);
                g.drawString(peString, this.preferredWidth() - stringWidth, fm.getHeight() / 2 + this.data.singleTimelineHeight() / 2 + p * this.data.singleTimelineHeight());
            } else {
                peString = "PE " + this.data.processorList().nextElement();
                g.drawString(peString, 10, this.data.singleTimelineHeight() / 2 + p * this.data.singleTimelineHeight());
                String percentString = "(" + (int)(100.0f - this.data.idleUsage[p]) + ", " + (int)this.data.processorUsage[p] + ")";
                g.drawString(percentString, 15, this.data.singleTimelineHeight() / 2 + p * this.data.singleTimelineHeight() + fm.getHeight() + 2);
            }
            ++p;
        }
    }
}

