/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.DecimalFormat;
import projections.gui.graph.Graph;

public abstract class Axis {
    public static final int DISCRETE = 1;
    public static final int CONTINUOUS = 2;
    private static final int MAJOR_TICK_OFFSET = 4;
    private static final int MINOR_TICK_OFFSET = 2;
    private static final int MINOR_TICKS_PER_MAJOR = 4;
    private static final int DIST_BETWEEN_MINOR_TICKS = 10;
    private static final int DIST_BETWEEN_LABELS = 5;
    private static final Color MAJOR_TICK_COLOR = Color.white;
    private static final Color MINOR_TICK_COLOR = Color.lightGray;
    private DecimalFormat small_ = null;
    private DecimalFormat large_ = null;
    private double min_;
    private double max_;
    double scale_ = 1.0;

    public static int getTickSize() {
        return 4;
    }

    public void setZoom(double min, double max) {
        this.min_ = min;
        this.max_ = max;
        this.scale_ = this.getSize() / (max - min);
    }

    public double coordToNormalScale(double c) {
        return (c - this.min_) / (this.max_ - this.min_);
    }

    public void newLimits(Graph g, double min, double max) {
    }

    public abstract void drawTick(Graphics var1, int var2, int var3, int var4);

    public abstract void drawAxis(Graphics var1, int var2, int var3, int var4);

    public abstract void drawLabel(Graphics var1, FontMetrics var2, String var3, int var4, int var5);

    public int getVerticalSize(FontMetrics fm, String label) {
        int length = label.length();
        int charHeight = fm.getHeight();
        int strHeight = charHeight * length;
        return strHeight;
    }

    public abstract int getDimDiscrete(FontMetrics var1, String var2);

    public abstract int getDimContinuous(FontMetrics var1, String var2);

    public int getLabelDimension(FontMetrics fm, int size) {
        TickMetrics tm = new TickMetrics(size);
        boolean discrete = this.getAxisType() == 1;
        int indicesPerTick = discrete ? (int)(tm.tickSpacing / tm.dataSize) : 0;
        int maxDim = 0;
        for (int i = 0; i < tm.numTicks; ++i) {
            int dim;
            int n = dim = discrete ? this.getDimDiscrete(fm, this.getIndexName((int)(this.min_ + 0.5) + i * indicesPerTick)) : this.getDimContinuous(fm, this.getValueName(this.min_ + (double)i * tm.tickSpacing / (double)size * tm.actualSize));
            if (dim <= maxDim) continue;
            maxDim = dim;
        }
        return maxDim;
    }

    public void draw(Graphics g, FontMetrics fm, int labelPos, int axisPos, int start, int size, int dir) {
        this.drawAxis(g, axisPos, start, size);
        TickMetrics tm = new TickMetrics(size);
        int maxLabelSize = 0;
        int indicesPerTick = 0;
        if (this.getAxisType() == 1) {
            indicesPerTick = (int)(tm.tickSpacing / tm.dataSize);
            maxLabelSize = this.calcMaxLabelSize(fm, indicesPerTick, tm.numTicks);
        }
        int minor_ticks_per_major = 4;
        if (this.getAxisType() == 1) {
            minor_ticks_per_major = this.calcNumMinorTicks(fm, minor_ticks_per_major, maxLabelSize, tm.numTicks, tm.tickSpacing);
        }
        int tickIndex = 0;
        if (this.getAxisType() == 1) {
            start += (int)((Math.ceil(this.min_) - this.min_) / (this.max_ - this.min_) * (double)size + 0.5);
        }
        for (int i = 0; i < tm.numTicks; ++i) {
            int pos = start + dir * (int)((double)i * tm.tickSpacing + 0.5);
            int tickSize = 0;
            if (tickIndex % (minor_ticks_per_major + 1) == 0) {
                int yLoc;
                tickSize = 4;
                g.setColor(MAJOR_TICK_COLOR);
                int xLoc = dir > 0 ? pos : labelPos;
                int n = yLoc = dir > 0 ? labelPos : pos;
                if (this.getAxisType() == 1) {
                    this.drawLabel(g, fm, this.getIndexName((int)(Math.ceil(this.min_) + (double)(tickIndex * indicesPerTick))), xLoc, yLoc);
                } else {
                    this.drawLabel(g, fm, this.getValueName(this.min_ + (double)i * tm.tickSpacing / (double)size * tm.actualSize), xLoc, yLoc);
                }
            } else {
                tickSize = 2;
                g.setColor(MINOR_TICK_COLOR);
            }
            this.drawTick(g, pos, axisPos, tickSize);
            ++tickIndex;
        }
    }

    private int calcNumMinorTicks(FontMetrics fm, int minor_ticks_per_major, int maxLabelSize, int numTicks, double tickSpacing) {
        while (tickSpacing * (double)(minor_ticks_per_major + 1) < (double)maxLabelSize && minor_ticks_per_major < numTicks - 1) {
            ++minor_ticks_per_major;
        }
        boolean adjusted = false;
        while (tickSpacing * (double)(minor_ticks_per_major + 1) >= (double)(maxLabelSize + 5) && minor_ticks_per_major > 0) {
            adjusted = true;
            --minor_ticks_per_major;
        }
        if (adjusted && tickSpacing * (double)(minor_ticks_per_major + 1) < (double)(maxLabelSize + 5)) {
            ++minor_ticks_per_major;
        }
        return minor_ticks_per_major;
    }

    private int calcMaxLabelSize(FontMetrics fm, int indicesPerTick, int numTicks) {
        int maxLabelSize = 0;
        for (int i = 0; i < numTicks; ++i) {
            int labelSize = this.getLabelSize(fm, this.getIndexName((int)(this.min_ + 0.5) + i * indicesPerTick));
            if (labelSize <= maxLabelSize) continue;
            maxLabelSize = labelSize;
        }
        return maxLabelSize;
    }

    public abstract int getLabelSize(FontMetrics var1, String var2);

    public abstract int getAxisType();

    public abstract String getTitle();

    public abstract double getMin();

    public abstract double getMax();

    public double getSize() {
        return this.getMax() - this.getMin();
    }

    public double getDifference() {
        return 0.01 * (this.getMax() - this.getMin());
    }

    public String getValueName(double val) {
        double value;
        if (this.large_ == null) {
            this.large_ = new DecimalFormat();
            this.large_.setGroupingUsed(true);
            this.large_.setMinimumFractionDigits(0);
            this.large_.setMaximumFractionDigits(0);
        }
        if (this.small_ == null) {
            this.small_ = new DecimalFormat();
            this.small_.setGroupingUsed(true);
        }
        if ((value = Math.abs(val)) >= 100.0) {
            return this.large_.format(val);
        }
        if (value >= 10.0) {
            this.small_.setMinimumFractionDigits(1);
            this.small_.setMaximumFractionDigits(1);
            return this.small_.format(val);
        }
        if (value >= 1.0) {
            this.small_.setMinimumFractionDigits(2);
            this.small_.setMaximumFractionDigits(2);
            return this.small_.format(val);
        }
        this.small_.setMinimumFractionDigits(3);
        this.small_.setMaximumFractionDigits(3);
        return this.small_.format(val);
    }

    public String getIndexName(int index) {
        if (this.large_ == null) {
            this.large_ = new DecimalFormat();
            this.large_.setGroupingUsed(true);
            this.large_.setMinimumFractionDigits(0);
            this.large_.setMaximumFractionDigits(0);
        }
        return this.large_.format(index);
    }

    public abstract int getMinIndex();

    public abstract int getMaxIndex();

    public int getNumIndices() {
        return this.getMaxIndex() - this.getMinIndex() + 1;
    }

    public abstract String getUnits();

    private class TickMetrics {
        public double actualSize;
        public double dataSize;
        public int numTicks;
        public double tickSpacing;

        TickMetrics(int size) {
            this.actualSize = Axis.this.getSize() * Axis.this.scale_;
            this.dataSize = (double)size / this.actualSize;
            this.numTicks = (int)(((double)size - this.dataSize) / 10.0);
            this.tickSpacing = this.dataSize > 10.0 ? this.dataSize : 10.0;
            this.numTicks = (int)((double)size / this.tickSpacing);
        }
    }
}

