/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import projections.analysis.GenericLogReader;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalRangeDialog;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.U;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class IntervalWindow
extends GenericGraphWindow
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    public long thresholdTime;
    public long intervalSize;
    private double[][] dataSource;
    private boolean countSends = true;
    private boolean getNewData = false;
    private final int NO_OF_DATASOURCES = 3;
    private final int STRETCHED_EP = 0;
    private final int SEND_COUNT = 1;
    private final int MSG_LEN_COUNT = 2;

    protected void windowInit() {
        this.intervalSize = 1000L;
        super.windowInit();
    }

    public IntervalWindow(MainWindow mainWindow, Integer myWindowID) {
        super("Projections Interval Graph", mainWindow, myWindowID);
        this.setGraphSpecificData();
        this.createMenus();
        this.getContentPane().add(this.getMainPanel());
        this.pack();
        this.showDialog();
        this.setVisible(true);
        this.refreshGraph();
    }

    protected void showDialog() {
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "Select Range");
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            this.getNewData = true;
            this.refreshGraph();
        }
    }

    protected void getDialogData() {
        IntervalRangeDialog dialog = (IntervalRangeDialog)this.dialog;
        this.intervalSize = dialog.getIntervalSize();
        super.getDialogData();
    }

    protected void showWindow() {
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof JMenuItem) {
            JMenuItem m = (JMenuItem)evt.getSource();
            if (m.getText().equals("Set Range")) {
                this.showDialog();
            } else if (m.getText().equals("Send Count vs Stretched EntryPoints")) {
                this.countSends = m.isSelected();
                this.getNewData = false;
                this.refreshGraph();
            } else if (m.getText().equals("Bytes Sent vs Stretched EntryPoints")) {
                this.countSends = !m.isSelected();
                this.getNewData = false;
                this.refreshGraph();
            } else if (m.getText().equals("Close")) {
                this.close();
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        String s = "Item event detected. \n   Event source: " + source.getText() + "\n    New state: " + (e.getStateChange() == 1 ? "selected" : "unselected");
        System.out.println(s);
    }

    public String[] getPopup(int xVal, int yVal) {
        return null;
    }

    protected void createMenus() {
        JRadioButtonMenuItem countGraphButton = new JRadioButtonMenuItem("Send Count vs Stretched EntryPoints", true);
        countGraphButton.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        JRadioButtonMenuItem byteGraphButton = new JRadioButtonMenuItem("Bytes Sent vs Stretched EntryPoints", false);
        byteGraphButton.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        ButtonGroup graphChoiceButton = new ButtonGroup();
        graphChoiceButton.add(countGraphButton);
        graphChoiceButton.add(byteGraphButton);
        JMenuBar mbar = new JMenuBar();
        this.setJMenuBar(mbar);
        mbar.add(Util.makeJMenu("File", new Object[]{"Set Range", "Close"}, null, this));
        mbar.add(Util.makeJMenu("Options", new Object[]{countGraphButton, byteGraphButton}, null, this));
    }

    protected void setGraphSpecificData() {
        this.setXAxis("Time Interval", "");
        this.setYAxis("#", "");
    }

    protected void refreshGraph() {
        if (this.getNewData) {
            this.getNewData();
        }
        if (this.dataSource != null) {
            int mode;
            String titleString;
            if (this.countSends) {
                titleString = "Stretched EntryPoints vs Send Messages";
                mode = 1;
            } else {
                titleString = "Stretched EntryPoints vs Bytes Sent";
                mode = 2;
            }
            double[][] data = new double[this.dataSource.length][2];
            for (int i = 0; i < this.dataSource.length; ++i) {
                data[i][0] = this.dataSource[i][0];
                data[i][1] = this.dataSource[i][mode];
            }
            double multiplier = (double)(this.endTime - this.startTime) / (double)(this.dataSource.length - 1);
            this.setXAxis("Time Interval (" + U.t(this.startTime) + " - " + U.t(this.endTime) + ")", "ms", this.startTime / 1000L, multiplier / 1000.0);
            this.setDataSource(titleString, data);
            super.refreshGraph();
        }
    }

    private void getNewData() {
        OrderedIntList tmpPEs = this.validPEs.copyOf();
        LogEntryData logData = new LogEntryData();
        LogEntryData prevLogData = new LogEntryData();
        int no_of_bins = (int)((this.endTime - this.startTime) / this.intervalSize) + 1;
        this.dataSource = new double[no_of_bins][3];
        for (int i = 0; i < no_of_bins; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.dataSource[i][j] = 0.0;
            }
        }
        block10: while (tmpPEs.hasMoreElements()) {
            int pe = tmpPEs.nextElement();
            GenericLogReader logReader = new GenericLogReader(MainWindow.runObject[this.myRun].getLogName(pe), MainWindow.runObject[this.myRun].getVersion());
            try {
                logReader.nextEventOnOrAfter(this.startTime, logData);
                while (true) {
                    logReader.nextEvent(logData);
                    if (logData.time > this.endTime) continue block10;
                    switch (logData.type) {
                        case 1: {
                            int binValue = (int)((logData.time - this.startTime) / this.intervalSize);
                            double[] dArray = this.dataSource[binValue];
                            dArray[1] = dArray[1] + 1.0;
                            double[] dArray2 = this.dataSource[binValue];
                            dArray2[2] = dArray2[2] + (double)logData.msglen;
                            break;
                        }
                        case 2: {
                            prevLogData = logData.copyOf();
                            break;
                        }
                        case 3: {
                            long executionTime = logData.time - prevLogData.time;
                            if (executionTime <= this.thresholdTime) break;
                            int binValue = (int)((prevLogData.time - this.startTime) / this.intervalSize);
                            double[] dArray = this.dataSource[binValue];
                            dArray[0] = dArray[0] + 1.0;
                        }
                    }
                }
            }
            catch (EOFException e) {
            }
            catch (IOException e) {
                System.out.println("Exception at IntervalWindow::getData() " + e);
            }
        }
    }
}

