/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import projections.gui.PopUpAble;
import projections.gui.ResponsiveToMouse;
import projections.gui.U;
import projections.gui.Util;
import projections.gui.graph.DataSource2D;
import projections.gui.graph.Graph;
import projections.gui.graph.GraphPanel;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxisAuto;

public class PoseRTDopDisplayPanel
extends JPanel
implements PopUpAble {
    private static final long serialVersionUID = 1L;
    private GraphPanel graphPanel;
    private JPanel controlPanel;
    private Graph graph;

    public PoseRTDopDisplayPanel() {
        this.createLayout();
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        this.setLayout(gbl);
        this.graph = new Graph();
        this.graphPanel = new GraphPanel(this.graph);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gbl);
        Util.gblAdd(this, this.graphPanel, gbc, 0, 0, 1, 1, 1, 1, 5, 5, 5, 5);
        Util.gblAdd(this, this.controlPanel, gbc, 0, 1, 1, 1, 1, 0);
    }

    public void setGraphData(int[][] data, long intervalSize, int startInterval, int endInterval) {
        DataSource2D datasource = new DataSource2D("Degree of Parallism: " + U.t((long)startInterval * intervalSize) + " to " + U.t((long)endInterval * intervalSize), data, (ResponsiveToMouse)this);
        datasource.setColors(new Color[]{Color.green, Color.blue});
        XAxisFixed xaxis = new XAxisFixed("Time: interval size = " + U.t(intervalSize), "Time");
        xaxis.setLimits((double)startInterval * (double)intervalSize, intervalSize);
        YAxisAuto yaxis = new YAxisAuto("Number of Simultaneous Events", "", datasource);
        this.graph.setData(datasource, xaxis, yaxis);
    }

    public void refreshGraph() {
        this.graph.repaint();
    }

    public String[] getPopup(int xVal, int yVal) {
        if (xVal < 0 || yVal < 0) {
            return null;
        }
        return null;
    }
}

