/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import projections.gui.JLongTextField;
import projections.gui.JSelectField;
import projections.gui.JTimeTextField;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.U;
import projections.gui.Util;

public class PoseRangeDialog
extends JDialog
implements ActionListener,
KeyListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    ProjectionsWindow parentWindow;
    int myRun = 0;
    private static final int DIALOG_OK = 0;
    private static final int DIALOG_CANCELLED = 1;
    protected JPanel processorsPanel;
    protected JTabbedPane timePanel;
    protected JPanel realTimePanel;
    protected JPanel virtTimePanel;
    protected JPanel buttonPanel;
    protected JPanel mainPanel;
    protected JButton bOK;
    protected JButton bUpdate;
    protected JButton bCancel;
    protected JSelectField processorsField;
    protected JTimeTextField realIntervalSizeField;
    protected JTimeTextField realStartTimeField;
    protected JTimeTextField realEndTimeField;
    protected JLongTextField virtIntervalSizeField;
    protected JLongTextField virtStartTimeField;
    protected JLongTextField virtEndTimeField;
    private JLabel realStartFieldLabel;
    private JLabel realEndFieldLabel;
    private JLabel realIntervalSizeFieldLabel;
    private JLabel virtStartFieldLabel;
    private JLabel virtEndFieldLabel;
    private JLabel virtIntervalSizeFieldLabel;
    private JLabel processorsFieldLabel;
    private JLabel totalSelectedRealTimeLabel;
    private JLabel validRealTimeLabel;
    private JLabel totalNumRealIntervalsLabel;
    private JLabel realStartIntervalLabel;
    private JLabel realEndIntervalLabel;
    private JLabel totalSelectedVirtTimeLabel;
    private JLabel validVirtTimeLabel;
    private JLabel totalNumVirtIntervalsLabel;
    private JLabel virtStartIntervalLabel;
    private JLabel virtEndIntervalLabel;
    private JLabel validProcessorsLabel;
    protected OrderedIntList validProcessors;
    protected long realIntervalSize;
    protected long realStartTime;
    protected long realEndTime;
    protected long virtIntervalSize;
    protected long virtStartTime;
    protected long virtEndTime;
    private String validProcessorsString;
    protected long numRealIntervals;
    private long realStartInterval;
    private long realEndInterval;
    protected long numVirtIntervals;
    private long virtStartInterval;
    private long virtEndInterval;
    protected DecimalFormat _format;
    private boolean layoutComplete = false;
    int dialogState;

    public PoseRangeDialog(ProjectionsWindow parentWindow, String titleString) {
        super(parentWindow, titleString, true);
        this.parentWindow = parentWindow;
        this.validProcessors = MainWindow.runObject[this.myRun].getValidProcessorList(3);
        this.validProcessorsString = this.validProcessors.listToString();
        this.realIntervalSize = 1000L;
        this.realStartTime = 0L;
        this.realEndTime = MainWindow.runObject[this.myRun].getPoseTotalTime();
        this.realStartInterval = 0L;
        this.realEndInterval = this.realEndTime / this.realIntervalSize;
        this.numRealIntervals = this.realEndInterval - this.realStartInterval + 1L;
        this.virtStartTime = 0L;
        this.virtEndTime = MainWindow.runObject[this.myRun].getPoseTotalVirtualTime();
        this.virtIntervalSize = this.virtEndTime / 100L + 1L;
        this.virtStartInterval = 0L;
        this.virtEndInterval = this.virtEndTime / this.virtIntervalSize;
        this.numVirtIntervals = this.virtEndInterval - this.virtStartInterval + 1L;
        this._format = new DecimalFormat();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof JButton) {
            JButton b = (JButton)evt.getSource();
            if (b == this.bOK) {
                JTextField someField = this.checkConsistent();
                if (someField != null) {
                    someField.selectAll();
                    someField.requestFocus();
                    return;
                }
                this.dialogState = 0;
                this.setVisible(false);
            } else {
                if (b == this.bUpdate) {
                    this.updateData(this.processorsField);
                    this.updateData(this.realStartTimeField);
                    this.updateData(this.realEndTimeField);
                    this.updateData(this.virtStartTimeField);
                    this.updateData(this.virtEndTimeField);
                    return;
                }
                if (b == this.bCancel) {
                    this.dialogState = 1;
                    this.setVisible(false);
                }
            }
        } else if (evt.getSource() instanceof JTextField) {
            this.updateData((JTextField)evt.getSource());
            this.bOK.setEnabled(true);
        }
    }

    public void focusGained(FocusEvent evt) {
    }

    public void focusLost(FocusEvent evt) {
        if (evt.getComponent() instanceof JTextField) {
            this.updateData((JTextField)evt.getComponent());
            this.bOK.setEnabled(true);
        }
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        int keycode = evt.getKeyCode();
        if (evt.getComponent() instanceof JTextField) {
            JTextField field = (JTextField)evt.getComponent();
            switch (keycode) {
                case 10: {
                    this.updateData(field);
                    this.bOK.setEnabled(true);
                    break;
                }
                case 9: {
                    this.updateData(field);
                    this.bOK.setEnabled(true);
                    break;
                }
                default: {
                    this.bOK.setEnabled(false);
                }
            }
        }
    }

    public void displayDialog() {
        if (!this.layoutComplete) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    PoseRangeDialog.this.dialogState = 1;
                    PoseRangeDialog.this.setVisible(false);
                }
            });
            this.mainPanel = this.createMainLayout();
            this.buttonPanel = this.createButtonLayout();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.mainPanel, "North");
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.layoutComplete = true;
            this.pack();
            this.setResizable(false);
        } else {
            this.setParameters();
        }
        this.setVisible(true);
    }

    JPanel createMainLayout() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.processorsPanel = new JPanel();
        this.processorsPanel.setLayout(gbl);
        this.validProcessorsLabel = new JLabel("Valid Processors = " + this.validProcessorsString, 2);
        this.processorsFieldLabel = new JLabel("Processors :", 2);
        this.processorsField = new JSelectField(this.validProcessorsString, 12);
        this.processorsField.addActionListener(this);
        Util.gblAdd(this.processorsPanel, this.validProcessorsLabel, gbc, 0, 0, 2, 1, 1, 1);
        Util.gblAdd(this.processorsPanel, this.processorsFieldLabel, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.processorsPanel, this.processorsField, gbc, 1, 1, 1, 1, 1, 1);
        this.timePanel = new JTabbedPane();
        this.timePanel.setBorder(new TitledBorder(new LineBorder(Color.black), "POSE TIME PARAMETER"));
        this.realTimePanel = new JPanel();
        this.realTimePanel.setLayout(gbl);
        this.realIntervalSizeFieldLabel = new JLabel("Size of Real Time Interval:", 2);
        this.realIntervalSizeField = new JTimeTextField(this.realIntervalSize, 12);
        this.realIntervalSizeField.addActionListener(this);
        this.realIntervalSizeField.addKeyListener(this);
        this.realIntervalSizeField.addFocusListener(this);
        this.realStartFieldLabel = new JLabel("Real Time Start:", 2);
        this.realStartTimeField = new JTimeTextField(this.realStartTime, 12);
        this.realStartTimeField.addActionListener(this);
        this.realStartTimeField.addKeyListener(this);
        this.realStartTimeField.addFocusListener(this);
        this.realEndFieldLabel = new JLabel("Real Time End:", 2);
        this.realEndTimeField = new JTimeTextField(this.realEndTime, 12);
        this.realEndTimeField.addActionListener(this);
        this.realEndTimeField.addKeyListener(this);
        this.realEndTimeField.addFocusListener(this);
        this.validRealTimeLabel = new JLabel("Valid Real Time Range: " + U.t(0L) + " to " + U.t(MainWindow.runObject[this.myRun].getPoseTotalTime()));
        this.totalSelectedRealTimeLabel = new JLabel("Selected Total Time: " + U.t(this.realEndTime - this.realStartTime));
        this.realStartIntervalLabel = new JLabel("Start Interval: " + this.realStartInterval);
        this.realEndIntervalLabel = new JLabel("End Interval: " + this.realEndInterval);
        this.totalNumRealIntervalsLabel = new JLabel("Num Intervals: " + (this.realEndInterval - this.realStartInterval + 1L));
        Util.gblAdd(this.realTimePanel, this.realIntervalSizeFieldLabel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.realIntervalSizeField, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.realStartFieldLabel, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.realStartTimeField, gbc, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.realEndFieldLabel, gbc, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.realEndTimeField, gbc, 3, 1, 1, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.validRealTimeLabel, gbc, 0, 2, 4, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.totalSelectedRealTimeLabel, gbc, 0, 3, 4, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.realStartIntervalLabel, gbc, 0, 4, 2, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.realEndIntervalLabel, gbc, 1, 4, 2, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.totalNumRealIntervalsLabel, gbc, 0, 5, 4, 1, 1, 1);
        this.virtTimePanel = new JPanel();
        this.virtTimePanel.setLayout(gbl);
        this.virtIntervalSizeFieldLabel = new JLabel("Units in Virtual Time Interval:", 2);
        this.virtIntervalSizeField = new JLongTextField(this.virtIntervalSize, 12);
        this.virtIntervalSizeField.addActionListener(this);
        this.virtIntervalSizeField.addKeyListener(this);
        this.virtIntervalSizeField.addFocusListener(this);
        this.virtStartFieldLabel = new JLabel("Virtual Time Start:", 2);
        this.virtStartTimeField = new JLongTextField(this.virtStartTime, 12);
        this.virtStartTimeField.addActionListener(this);
        this.virtStartTimeField.addKeyListener(this);
        this.virtStartTimeField.addFocusListener(this);
        this.virtEndFieldLabel = new JLabel("Virtual Time End:", 2);
        this.virtEndTimeField = new JLongTextField(this.virtEndTime, 12);
        this.virtEndTimeField.addActionListener(this);
        this.virtEndTimeField.addKeyListener(this);
        this.virtEndTimeField.addFocusListener(this);
        this.validVirtTimeLabel = new JLabel("Valid Virtual Time Range: 0 to " + MainWindow.runObject[this.myRun].getPoseTotalVirtualTime());
        this.totalSelectedVirtTimeLabel = new JLabel("Units of Selected Total Time: " + (this.virtEndTime - this.virtStartTime));
        this.virtStartIntervalLabel = new JLabel("Start Interval: " + this.virtStartInterval);
        this.virtEndIntervalLabel = new JLabel("End Interval: " + this.virtEndInterval);
        this.totalNumVirtIntervalsLabel = new JLabel("Num Intervals: " + (this.virtEndInterval - this.virtStartInterval + 1L));
        Util.gblAdd(this.virtTimePanel, this.virtIntervalSizeFieldLabel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.virtIntervalSizeField, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.virtStartFieldLabel, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.virtStartTimeField, gbc, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.virtEndFieldLabel, gbc, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.virtEndTimeField, gbc, 3, 1, 1, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.validVirtTimeLabel, gbc, 0, 2, 4, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.totalSelectedVirtTimeLabel, gbc, 0, 3, 4, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.virtStartIntervalLabel, gbc, 0, 4, 2, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.virtEndIntervalLabel, gbc, 1, 4, 2, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.totalNumVirtIntervalsLabel, gbc, 0, 5, 4, 1, 1, 1);
        this.timePanel.addTab("Real Time", null, this.realTimePanel, "Real Time Parameters");
        this.timePanel.addTab("Virtual", null, this.virtTimePanel, "Virtual Time Parameters");
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(gbl);
        Util.gblAdd(inputPanel, this.processorsPanel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(inputPanel, this.timePanel, gbc, 0, 1, 1, 1, 1, 1);
        return inputPanel;
    }

    JPanel createButtonLayout() {
        JPanel buttonPanel = new JPanel();
        this.bOK = new JButton("OK");
        this.bUpdate = new JButton("Update");
        this.bCancel = new JButton("Cancel");
        buttonPanel.add(this.bOK);
        buttonPanel.add(this.bUpdate);
        buttonPanel.add(this.bCancel);
        this.bOK.addActionListener(this);
        this.bUpdate.addActionListener(this);
        this.bCancel.addActionListener(this);
        return buttonPanel;
    }

    void updateData(JTextField field) {
        if (field instanceof JTimeTextField) {
            if (field == this.realStartTimeField) {
                this.realStartTime = this.realStartTimeField.getValue();
                this.realStartInterval = this.realStartTime / this.realIntervalSize;
            } else if (field == this.realEndTimeField) {
                this.realEndTime = this.realEndTimeField.getValue();
                this.realEndInterval = this.realEndTime / this.realIntervalSize;
            } else if (field == this.realIntervalSizeField) {
                this.realIntervalSize = this.realIntervalSizeField.getValue();
            }
        } else if (field instanceof JLongTextField) {
            if (field == this.virtStartTimeField) {
                this.virtStartTime = this.virtStartTimeField.getValue();
            } else if (field == this.virtEndTimeField) {
                this.virtEndTime = this.virtEndTimeField.getValue();
            } else if (field == this.virtIntervalSizeField) {
                this.virtIntervalSize = this.virtIntervalSizeField.getValue();
            }
        }
        this.updateDerived(field);
    }

    JTextField checkConsistent() {
        return null;
    }

    public boolean isModified() {
        return true;
    }

    void updateDerived(JTextField field) {
        if (field instanceof JTimeTextField) {
            if (field == this.realStartTimeField) {
                this.realStartInterval = this.realStartTime / this.realIntervalSize;
                this.numRealIntervals = this.realEndInterval - this.realStartInterval + 1L;
            } else if (field == this.realEndTimeField) {
                this.realEndInterval = this.realEndTime / this.realIntervalSize;
                this.numRealIntervals = this.realEndInterval - this.realStartInterval + 1L;
            } else if (field == this.realIntervalSizeField) {
                this.realStartInterval = this.realStartTime / this.realIntervalSize;
                this.realEndInterval = this.realEndTime / this.realIntervalSize;
                this.numRealIntervals = this.realEndInterval - this.realStartInterval + 1L;
            }
        } else if (field instanceof JLongTextField) {
            if (field == this.virtStartTimeField) {
                this.virtStartInterval = this.virtStartTime / this.virtIntervalSize;
                this.numVirtIntervals = this.virtEndInterval - this.virtStartInterval + 1L;
            } else if (field == this.virtEndTimeField) {
                this.virtEndInterval = this.virtEndTime / this.virtIntervalSize;
                this.numVirtIntervals = this.virtEndInterval - this.virtStartInterval + 1L;
            } else if (field == this.virtIntervalSizeField) {
                this.virtStartInterval = this.virtStartTime / this.virtIntervalSize;
                this.virtEndInterval = this.virtEndTime / this.virtIntervalSize;
                this.numVirtIntervals = this.virtEndInterval - this.virtStartInterval + 1L;
            }
        } else if (field == null) {
            this.realStartInterval = this.realStartTime / this.realIntervalSize;
            this.realEndInterval = this.realEndTime / this.realIntervalSize;
            this.numRealIntervals = this.realEndInterval - this.realStartInterval + 1L;
            this.virtStartInterval = this.virtStartTime / this.virtIntervalSize;
            this.virtEndInterval = this.virtEndTime / this.virtIntervalSize;
            this.numVirtIntervals = this.virtEndInterval - this.virtStartInterval + 1L;
        }
        this.totalSelectedRealTimeLabel.setText("Selected Total Time: " + U.t(this.realEndTime - this.realStartTime));
        this.realStartIntervalLabel.setText("Start Interval: " + this.realStartInterval);
        this.realEndIntervalLabel.setText("End Interval: " + this.realEndInterval);
        this.totalNumRealIntervalsLabel.setText("Num Intervals: " + (this.realEndInterval - this.realStartInterval + 1L));
        this.totalSelectedVirtTimeLabel.setText("Units of Selected Total Time: " + (this.virtEndTime - this.virtStartTime));
        this.virtStartIntervalLabel.setText("Start Interval: " + this.virtStartInterval);
        this.virtEndIntervalLabel.setText("End Interval: " + this.virtEndInterval);
        this.totalNumVirtIntervalsLabel.setText("Num Intervals: " + (this.virtEndInterval - this.virtStartInterval + 1L));
    }

    void setParameters() {
        this.realIntervalSize = this.realIntervalSizeField.getValue();
        this.realStartTime = this.realStartTimeField.getValue();
        this.realEndTime = this.realEndTimeField.getValue();
        this.virtIntervalSize = this.virtIntervalSizeField.getValue();
        this.virtStartTime = this.virtStartTimeField.getValue();
        this.virtEndTime = this.virtEndTimeField.getValue();
        this.updateDerived(null);
    }

    public boolean isCancelled() {
        return this.dialogState == 1;
    }

    public OrderedIntList getValidProcessors() {
        return this.validProcessors;
    }

    public void setValidProcessors(OrderedIntList validProcessors) {
        this.validProcessors = validProcessors;
        this.validProcessorsString = this.validProcessors.listToString();
    }

    public long getRealIntervalSize() {
        return this.realIntervalSize;
    }

    public void setRealIntervalSize(long realIntervalSize) {
        this.realIntervalSize = realIntervalSize;
    }

    public long getRealStartTime() {
        return this.realStartTime;
    }

    public void setRealStartTime(long realStartTime) {
        this.realStartTime = realStartTime;
    }

    public long getRealEndTime() {
        return this.realEndTime;
    }

    public void setRealEndTime(long realEndTime) {
        this.realEndTime = realEndTime;
    }

    public long getVirtIntervalSize() {
        return this.virtIntervalSize;
    }

    public void setVirtIntervalSize(long virtIntervalSize) {
        this.virtIntervalSize = virtIntervalSize;
    }

    public long getVirtStartTime() {
        return this.virtStartTime;
    }

    public void setVirtStartTime(long virtStartTime) {
        this.virtStartTime = virtStartTime;
    }

    public long getVirtEndTime() {
        return this.virtEndTime;
    }

    public void setVirtEndTime(long virtEndTime) {
        this.virtEndTime = virtEndTime;
    }
}

