/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;
import projections.gui.MainWindow;
import projections.gui.Timeline.EntryMethodObject;
import projections.gui.Timeline.TimelineMessage;

public class MessageCanvas
extends JPanel {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private String[] sTitles;
    private int[] width;
    private EntryMethodObject obj;
    private FontMetrics fm;
    private Set msgs;
    private int w;
    private int h;
    private int numTitles = 17;
    private int numColumns = 5;
    private int[] maxColWidth = null;

    public MessageCanvas(EntryMethodObject obj) {
        this.obj = obj;
        this.w = 0;
        this.h = 0;
        this.msgs = obj.getMessages();
        this.sTitles = new String[this.numTitles];
        this.width = new int[this.numTitles];
        int entryID = obj.getEntryID();
        this.sTitles[0] = "DETAILS FOR ENTRY: ";
        this.sTitles[1] = MainWindow.runObject[this.myRun].getEntryFullNameByID(entryID);
        this.sTitles[2] = "BEGIN TIME: ";
        this.sTitles[3] = "" + obj.getBeginTime();
        this.sTitles[4] = "     END TIME: ";
        this.sTitles[5] = "" + obj.getEndTime();
        this.sTitles[6] = "     MSGS: ";
        this.sTitles[7] = "" + obj.getNumMsgs();
        this.sTitles[8] = "CREATED BY: ";
        this.sTitles[9] = "Processor " + obj.getPCreation();
        this.sTitles[10] = "      EXECUTED ON: ";
        this.sTitles[11] = "Processor " + obj.getPCurrent();
        this.sTitles[12] = "MSG#";
        this.sTitles[13] = "MSG SIZE:";
        this.sTitles[14] = "TIME SENT";
        this.sTitles[15] = "TIME SINCE LAST SEND";
        this.sTitles[16] = "TO ENTRY:";
        this.setBackground(Color.pink);
        this.setForeground(Color.lightGray);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 600);
    }

    public void paint(Graphics g) {
        int dy;
        int i;
        int wi = this.getSize().width;
        int space0 = (wi - this.width[0] - this.width[1]) / 2;
        int space1 = (wi - this.width[2] - this.width[3] - this.width[4] - this.width[5] - this.width[6] - this.width[7]) / 2;
        int space2 = (wi - this.width[8] - this.width[9] - this.width[10] - this.width[11]) / 2;
        int totalColWidth = 0;
        for (i = 0; i < this.maxColWidth.length; ++i) {
            totalColWidth += this.maxColWidth[i];
        }
        int space3 = (wi - totalColWidth) / (1 + this.maxColWidth.length);
        if (space0 < 0) {
            space0 = 0;
        }
        if (space1 < 0) {
            space1 = 0;
        }
        if (space2 < 0) {
            space2 = 0;
        }
        if (space3 < 0) {
            space3 = 0;
        }
        int[] colWidth = new int[this.numColumns];
        int[] colStart = new int[this.numColumns];
        colWidth[0] = this.maxColWidth[0] + (int)((double)space3 * 1.3);
        colWidth[1] = this.maxColWidth[1] + space3;
        colWidth[2] = this.maxColWidth[2] + (int)((double)space3 * 1.3);
        colWidth[3] = this.maxColWidth[3] + (int)((double)space3 * 1.3);
        colWidth[4] = this.maxColWidth[4] + space3;
        colStart[0] = 0;
        for (i = 1; i < colStart.length; ++i) {
            colStart[i] = colStart[i - 1] + colWidth[i - 1];
        }
        int y = dy = this.fm.getHeight() + 5;
        int wtmp = 0;
        g.setColor(Color.white);
        g.drawString(this.sTitles[1], (wi - this.width[1]) / 2, y);
        g.setColor(Color.red.darker());
        wtmp = space1;
        g.drawString(this.sTitles[2], wtmp, y += dy);
        g.drawString(this.sTitles[4], wtmp += this.width[2] + this.width[3], y);
        g.drawString(this.sTitles[6], wtmp += this.width[4] + this.width[5], y);
        g.setColor(Color.lightGray);
        wtmp = space1 + this.width[2];
        g.drawString(this.sTitles[3], wtmp, y);
        g.drawString(this.sTitles[5], wtmp += this.width[3] + this.width[4], y);
        g.drawString(this.sTitles[7], wtmp += this.width[5] + this.width[6], y);
        g.setColor(Color.green.darker());
        wtmp = space2;
        g.drawString(this.sTitles[8], wtmp, y += dy);
        g.drawString(this.sTitles[10], wtmp += this.width[8] + this.width[9], y);
        g.setColor(Color.lightGray);
        wtmp = space2 + this.width[8];
        g.drawString(this.sTitles[9], wtmp, y);
        g.drawString(this.sTitles[11], wtmp += this.width[9] + this.width[10], y);
        y += dy;
        g.setColor(Color.white);
        for (i = 0; i < this.numColumns; ++i) {
            g.drawString(this.sTitles[12 + i], (colWidth[i] - this.width[12 + i]) / 2 + colStart[i], y);
        }
        g.setColor(Color.lightGray);
        String[] s = new String[this.numColumns];
        Iterator iter = this.obj.messages.iterator();
        int m = -1;
        TimelineMessage msg = null;
        TimelineMessage prev = null;
        while (iter.hasNext()) {
            prev = msg;
            msg = (TimelineMessage)iter.next();
            s[0] = new String("" + ++m);
            s[1] = new String("" + msg.MsgLen);
            s[2] = new String("" + msg.Time);
            s[3] = m > 0 ? new String("" + (int)(msg.Time - prev.Time)) : "-";
            s[4] = new String(MainWindow.runObject[this.myRun].getEntryNameByID(msg.Entry));
            y += dy;
            for (i = 0; i < this.numColumns; ++i) {
                g.drawString(s[i], (colWidth[i] - this.fm.stringWidth(s[i])) / 2 + colStart[i], y);
            }
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

