/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import projections.analysis.AsciiIntegerReader;
import projections.analysis.PointCapableReader;
import projections.analysis.ProjectionsReader;
import projections.gui.MainWindow;
import projections.misc.LogEntryData;

public class GenericLogReader
extends ProjectionsReader
implements PointCapableReader {
    static int myRun = 0;
    private AsciiIntegerReader reader;
    private double version;
    private boolean fakedEndComputation = false;
    private long lastRecordedTime = 0L;
    private LogEntryData lastBeginEvent = new LogEntryData();

    public GenericLogReader(String filename, double Nversion) {
        super(filename, String.valueOf(Nversion));
        this.lastBeginEvent.setValid(false);
        try {
            this.reader = new AsciiIntegerReader(new FileReader(filename));
            this.version = Nversion;
            this.reader.nextLine();
        }
        catch (IOException e) {
            System.err.println("Error reading file " + filename);
        }
    }

    public GenericLogReader(int peNum, double Nversion) {
        super(MainWindow.runObject[myRun].getLogName(peNum), String.valueOf(Nversion));
        this.lastBeginEvent.setValid(false);
        try {
            this.reader = new AsciiIntegerReader(new FileReader(this.sourceString));
            this.version = Nversion;
            this.reader.nextLine();
        }
        catch (IOException e) {
            System.err.println("Error reading file " + this.sourceString);
        }
    }

    protected boolean checkAvailable() {
        File sourceFile = new File(this.sourceString);
        return sourceFile.canRead();
    }

    public void readStaticData() {
    }

    public void reset() throws IOException {
        this.reader.close();
        this.reader = new AsciiIntegerReader(new FileReader(this.sourceString));
        this.reader.nextLine();
    }

    public void nextEvent(LogEntryData data) throws IOException, EOFException {
        try {
            data.type = this.reader.nextInt();
            switch (data.type) {
                case 14: {
                    this.lastBeginEvent.time = data.time = this.reader.nextLong();
                    this.lastBeginEvent.pe = data.pe = this.reader.nextInt();
                    this.lastBeginEvent.setValid(true);
                    this.reader.nextLine();
                    break;
                }
                case 15: {
                    data.time = this.reader.nextLong();
                    data.pe = this.reader.nextInt();
                    this.lastBeginEvent.setValid(false);
                    this.reader.nextLine();
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    data.time = this.reader.nextLong();
                    data.pe = this.reader.nextInt();
                    this.reader.nextLine();
                    break;
                }
                case 26: {
                    data.userSupplied = new Integer(this.reader.nextInt());
                    break;
                }
                case 27: {
                    data.memoryUsage = new Integer(this.reader.nextInt());
                    break;
                }
                case 1: {
                    data.mtype = this.reader.nextInt();
                    data.entry = this.reader.nextInt();
                    data.time = this.reader.nextLong();
                    data.event = this.reader.nextInt();
                    data.pe = this.reader.nextInt();
                    data.msglen = this.version >= 2.0 ? this.reader.nextInt() : -1;
                    if (!(this.version >= 5.0)) break;
                    data.sendTime = this.reader.nextLong();
                    break;
                }
                case 20: {
                    data.mtype = this.reader.nextInt();
                    data.entry = this.reader.nextInt();
                    data.time = this.reader.nextLong();
                    data.event = this.reader.nextInt();
                    data.pe = this.reader.nextInt();
                    data.msglen = this.version >= 2.0 ? this.reader.nextInt() : -1;
                    if (this.version >= 5.0) {
                        data.sendTime = this.reader.nextLong();
                    }
                    data.numPEs = this.reader.nextInt();
                    break;
                }
                case 21: {
                    data.mtype = this.reader.nextInt();
                    data.entry = this.reader.nextInt();
                    data.time = this.reader.nextLong();
                    data.event = this.reader.nextInt();
                    data.pe = this.reader.nextInt();
                    data.msglen = this.version >= 2.0 ? this.reader.nextInt() : -1;
                    if (this.version >= 5.0) {
                        data.sendTime = this.reader.nextLong();
                    }
                    data.numPEs = this.reader.nextInt();
                    data.destPEs = new int[data.numPEs];
                    for (int i = 0; i < data.numPEs; ++i) {
                        data.destPEs[i] = this.reader.nextInt();
                    }
                    break;
                }
                case 2: {
                    this.lastBeginEvent.mtype = data.mtype = this.reader.nextInt();
                    this.lastBeginEvent.entry = data.entry = this.reader.nextInt();
                    this.lastBeginEvent.time = data.time = this.reader.nextLong();
                    this.lastBeginEvent.event = data.event = this.reader.nextInt();
                    this.lastBeginEvent.pe = data.pe = this.reader.nextInt();
                    if (this.version >= 2.0) {
                        this.lastBeginEvent.msglen = data.msglen = this.reader.nextInt();
                    } else {
                        data.msglen = -1;
                        this.lastBeginEvent.msglen = -1;
                    }
                    if (this.version >= 4.0) {
                        this.lastBeginEvent.recvTime = data.recvTime = this.reader.nextLong();
                        this.lastBeginEvent.id[0] = data.id[0] = this.reader.nextInt();
                        this.lastBeginEvent.id[1] = data.id[1] = this.reader.nextInt();
                        this.lastBeginEvent.id[2] = data.id[2] = this.reader.nextInt();
                    }
                    if (this.version >= 7.0) {
                        this.lastBeginEvent.id[3] = data.id[3] = this.reader.nextInt();
                    }
                    if (this.version >= 6.5) {
                        this.lastBeginEvent.cpuStartTime = data.cpuStartTime = this.reader.nextLong();
                    }
                    if (this.version >= 6.6) {
                        this.lastBeginEvent.numPerfCounts = data.numPerfCounts = this.reader.nextInt();
                        this.lastBeginEvent.perfCounts = new long[data.numPerfCounts];
                        data.perfCounts = new long[data.numPerfCounts];
                        for (int i = 0; i < data.numPerfCounts; ++i) {
                            this.lastBeginEvent.perfCounts[i] = data.perfCounts[i] = this.reader.nextLong();
                        }
                    }
                    this.lastBeginEvent.setValid(true);
                    this.reader.nextLine();
                    break;
                }
                case 3: {
                    data.mtype = this.reader.nextInt();
                    data.entry = this.reader.nextInt();
                    data.time = this.reader.nextLong();
                    data.event = this.reader.nextInt();
                    data.pe = this.reader.nextInt();
                    data.msglen = this.version >= 2.0 ? this.reader.nextInt() : -1;
                    if (this.version >= 6.5) {
                        data.cpuEndTime = this.reader.nextLong();
                    }
                    if (this.version >= 6.6) {
                        data.numPerfCounts = this.reader.nextInt();
                        data.perfCounts = new long[data.numPerfCounts];
                        for (int i = 0; i < data.numPerfCounts; ++i) {
                            data.perfCounts[i] = this.reader.nextLong();
                        }
                    }
                    this.reader.nextLine();
                    break;
                }
                case 11: {
                    data.time = this.reader.nextLong();
                    this.lastBeginEvent.setValid(false);
                    this.reader.nextLine();
                    break;
                }
                case 12: {
                    data.time = this.reader.nextLong();
                    this.reader.nextLine();
                    break;
                }
                case 22: {
                    data.time = this.reader.nextLong();
                    data.entry = this.reader.nextInt();
                    data.lineNo = this.reader.nextInt();
                    data.funcName = this.reader.nextString();
                    this.reader.nextLine();
                    break;
                }
                case 23: {
                    data.time = this.reader.nextLong();
                    data.entry = this.reader.nextInt();
                    this.reader.nextLine();
                    break;
                }
                case 10: {
                    data.mtype = this.reader.nextInt();
                    data.time = this.reader.nextLong();
                    data.event = this.reader.nextInt();
                    data.pe = this.reader.nextInt();
                    data.msglen = this.reader.nextInt();
                    this.reader.nextLine();
                    break;
                }
                case 4: 
                case 5: {
                    data.mtype = this.reader.nextInt();
                    data.time = this.reader.nextLong();
                    data.event = this.reader.nextInt();
                    data.pe = this.reader.nextInt();
                    this.reader.nextLine();
                    break;
                }
                case 8: 
                case 9: {
                    data.time = this.reader.nextLong();
                    data.event = this.reader.nextInt();
                    data.pe = this.reader.nextInt();
                    this.reader.nextLine();
                    break;
                }
                case 6: 
                case 7: {
                    data.time = this.reader.nextLong();
                    this.reader.nextLine();
                    break;
                }
                case 13: {
                    data.entry = data.userEventID = this.reader.nextInt();
                    data.time = this.reader.nextLong();
                    data.event = this.reader.nextInt();
                    data.pe = this.reader.nextInt();
                    this.reader.nextLine();
                    break;
                }
                case 100: {
                    data.entry = data.userEventID = this.reader.nextInt();
                    data.time = this.reader.nextLong();
                    data.event = this.reader.nextInt();
                    data.pe = this.reader.nextInt();
                    this.reader.nextLine();
                    break;
                }
                default: {
                    data.type = -1;
                    this.reader.nextLine();
                }
            }
            this.lastRecordedTime = data.time;
        }
        catch (EOFException e) {
            if (this.fakedEndComputation || data.type == 7) {
                throw e;
            }
            this.fakedEndComputation = true;
            data.type = 7;
            data.time = this.lastRecordedTime;
            System.err.println("[" + this.sourceString + "] " + "WARNING: Partial or Corrupted " + "Projections log. Faked END_COMPUTATION " + "entry added for last recorded time of " + data.time);
        }
    }

    public void nextEventOnOrAfter(long timestamp, LogEntryData data) throws IOException, EOFException {
        this.seqLookForNextEventOnOrAfter(timestamp, data);
    }

    private void seqLookForNextEventOnOrAfter(long timestamp, LogEntryData data) throws IOException, EOFException {
        do {
            this.nextEvent(data);
            while (data.type == -1) {
                this.nextEvent(data);
            }
        } while (data.time < timestamp);
    }

    public void nextEventOfType(int eventType, LogEntryData data) throws IOException, EOFException {
        do {
            this.nextEvent(data);
        } while (data.type != eventType);
    }

    public void nextEventOfTypeOnOrAfter(int eventType, long timestamp, LogEntryData data) throws IOException, EOFException {
        do {
            this.nextEventOnOrAfter(timestamp, data);
        } while (data.type != eventType);
    }

    public void nextBeginEvent(LogEntryData data) throws IOException, EOFException {
        do {
            this.nextEvent(data);
        } while (!this.isBeginType(data));
    }

    public void nextEndEvent(LogEntryData data) throws IOException, EOFException {
        do {
            this.nextEvent(data);
        } while (!this.isEndType(data));
    }

    public void nextBeginEventOnOrAfter(long timestamp, LogEntryData data) throws IOException, EOFException {
        do {
            this.nextEventOnOrAfter(timestamp, data);
        } while (!this.isBeginType(data));
    }

    public void nextEndEventOnOrAfter(long timestamp, LogEntryData data) throws IOException, EOFException {
        do {
            this.nextEventOnOrAfter(timestamp, data);
        } while (!this.isEndType(data));
    }

    public LogEntryData getLastBE() {
        if (this.lastBeginEvent.isValid()) {
            return this.lastBeginEvent;
        }
        return null;
    }

    private boolean isBeginType(LogEntryData data) {
        return data.type == 14 || data.type == 16 || data.type == 18 || data.type == 2 || data.type == 11 || data.type == 22 || data.type == 8;
    }

    private boolean isEndType(LogEntryData data) {
        return data.type == 15 || data.type == 17 || data.type == 19 || data.type == 3 || data.type == 12 || data.type == 23 || data.type == 9;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public void skip(long offsetToBeginRecord) {
        try {
            this.reader.skip(offsetToBeginRecord);
        }
        catch (Exception E) {
            System.err.println("ERROR: error while seeking through a file");
        }
    }

    public void seek(long offset) {
        try {
            this.reader.seek(offset);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

