/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JColorChooser;
import projections.gui.ColorPanel;
import projections.gui.ColorWindowFrame;
import projections.gui.GraphData;
import projections.gui.GrayPanel;
import projections.gui.LWPanel;
import projections.gui.Util;
import projections.gui.ZItem;

public class GraphAttributesWindow
extends ColorWindowFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private GraphData data;
    private Checkbox[] cbSystemUsage;
    private ColorPanel[] cpSystemUsage;
    private ColorPanel[][] cpSystemMsgs;
    private ColorPanel[][] cpUserEntry;
    private Checkbox[][] cbSystemMsgs;
    private Checkbox[][] cbUserEntry;
    private ColorPanel selectedCP;
    private GrayPanel p1;
    private GrayPanel p2;
    private GrayPanel p4;
    private Button bAll;
    private Button bClear;
    private Button bApply;
    private Button bClose;

    public GraphAttributesWindow(Frame parent, GraphData data) {
        super(parent);
        this.data = data;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                GraphAttributesWindow.this.Close();
            }
        });
        this.setBackground(Color.lightGray);
        this.setTitle("Select Display Items");
        this.setLocation(0, 0);
        this.CreateLayout();
        this.pack();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof ColorPanel) {
            int t;
            this.selectedCP = (ColorPanel)evt.getSource();
            String s = "TEST";
            int a = 0;
            while (a < 3) {
                if (this.selectedCP == this.cpSystemUsage[a]) {
                    s = this.data.systemUsage[a].name;
                }
                ++a;
            }
            a = 0;
            while (a < 5) {
                t = 0;
                while (t < 2) {
                    if (this.selectedCP == this.cpSystemMsgs[a][t]) {
                        s = this.data.systemMsgs[a][t].name;
                        s = String.valueOf(s) + this.data.systemMsgs[a][t].type;
                    }
                    ++t;
                }
                ++a;
            }
            a = 0;
            while (a < this.data.numEntries) {
                t = 0;
                while (t < 2) {
                    if (this.selectedCP == this.cpUserEntry[a][t]) {
                        s = this.data.userEntry[a][t].name;
                        s = String.valueOf(s) + this.data.userEntry[a][t].type;
                    }
                    ++t;
                }
                ++a;
            }
            JColorChooser colorWindow = new JColorChooser();
            Color returnColor = JColorChooser.showDialog(this, s, this.selectedCP.getColor());
            if (returnColor != null) {
                this.selectedCP.setColor(returnColor);
            }
        } else if (evt.getSource() instanceof Button) {
            Button b = (Button)evt.getSource();
            if (b == this.bAll || b == this.bClear) {
                boolean dest = b == this.bAll;
                int a = 0;
                while (a < 3) {
                    if (this.cbSystemUsage[a] != null) {
                        this.cbSystemUsage[a].setState(dest);
                    }
                    ++a;
                }
                a = 0;
                while (a < 5) {
                    if (this.cbSystemMsgs[a][0] != null) {
                        this.cbSystemMsgs[a][0].setState(dest);
                        this.cbSystemMsgs[a][1].setState(dest);
                    }
                    ++a;
                }
                a = 0;
                while (a < this.data.numEntries) {
                    if (this.cbUserEntry[a][0] != null) {
                        this.cbUserEntry[a][0].setState(dest);
                        this.cbUserEntry[a][1].setState(dest);
                    }
                    ++a;
                }
            } else if (b == this.bClose) {
                this.Close();
            } else if (b == this.bApply) {
                int t;
                int t2;
                int numOnGraph = 0;
                int a = 0;
                while (a < 3) {
                    if (this.cbSystemUsage[a] != null) {
                        this.data.systemUsage[a].state = this.cbSystemUsage[a].getState();
                        this.data.systemUsage[a].color = this.cpSystemUsage[a].getColor();
                        if (this.data.systemUsage[a].state && this.data.systemUsage[a].exists) {
                            ++numOnGraph;
                        }
                    }
                    ++a;
                }
                a = 0;
                while (a < 5) {
                    if (this.cbSystemMsgs[a][0] != null) {
                        t2 = 0;
                        while (t2 < 3) {
                            if (t2 < 2) {
                                this.data.systemMsgs[a][t2].state = this.cbSystemMsgs[a][t2].getState();
                                this.data.systemMsgs[a][t2].color = this.cpSystemMsgs[a][t2].getColor();
                            } else {
                                this.data.systemMsgs[a][2].state = this.data.systemMsgs[a][0].state || this.data.systemMsgs[a][1].state;
                                this.data.systemMsgs[a][2].color = this.data.systemMsgs[a][0].color;
                            }
                            if (this.data.systemMsgs[a][t2].state && this.data.systemMsgs[a][t2].exists) {
                                ++numOnGraph;
                            }
                            ++t2;
                        }
                    }
                    ++a;
                }
                a = 0;
                while (a < this.data.numEntries) {
                    if (this.cbUserEntry[a][0] != null) {
                        t2 = 0;
                        while (t2 < 3) {
                            if (t2 < 2) {
                                this.data.userEntry[a][t2].state = this.cbUserEntry[a][t2].getState();
                                this.data.userEntry[a][t2].color = this.cpUserEntry[a][t2].getColor();
                            } else {
                                this.data.userEntry[a][2].state = this.data.userEntry[a][0].state || this.data.userEntry[a][1].state;
                                this.data.userEntry[a][2].color = this.data.userEntry[a][0].color;
                            }
                            if (this.data.userEntry[a][t2].state && this.data.userEntry[a][t2].exists) {
                                ++numOnGraph;
                            }
                            ++t2;
                        }
                    }
                    ++a;
                }
                this.data.onGraph = new ZItem[numOnGraph];
                int onGraphIndex = 0;
                int a2 = 0;
                while (a2 < 3) {
                    if (this.data.systemUsage[a2].exists && this.data.systemUsage[a2].state) {
                        this.data.onGraph[onGraphIndex++] = this.data.systemUsage[a2];
                    }
                    ++a2;
                }
                a2 = 0;
                while (a2 < 5) {
                    t = 0;
                    while (t < 3) {
                        if (this.data.systemMsgs[a2][t].exists && this.data.systemMsgs[a2][t].state) {
                            this.data.onGraph[onGraphIndex++] = this.data.systemMsgs[a2][t];
                        }
                        ++t;
                    }
                    ++a2;
                }
                a2 = 0;
                while (a2 < this.data.numEntries) {
                    t = 0;
                    while (t < 3) {
                        if (this.data.userEntry[a2][t].exists && this.data.userEntry[a2][t].state) {
                            this.data.onGraph[onGraphIndex++] = this.data.userEntry[a2][t];
                        }
                        ++t;
                    }
                    ++a2;
                }
                this.data.setData();
                this.data.legendPanel.UpdateLegend();
                this.data.displayPanel.setAllBounds();
                this.data.displayPanel.UpdateDisplay();
            }
        }
    }

    public void Close() {
        int t;
        this.setVisible(false);
        int a = 0;
        while (a < 3) {
            if (this.cbSystemUsage[a] != null) {
                this.cbSystemUsage[a].setState(this.data.systemUsage[a].state);
                this.cpSystemUsage[a].setColor(this.data.systemUsage[a].color);
            }
            ++a;
        }
        a = 0;
        while (a < 5) {
            if (this.cbSystemMsgs[a][0] != null) {
                t = 0;
                while (t < 2) {
                    this.cbSystemMsgs[a][t].setState(this.data.systemMsgs[a][t].state);
                    this.cpSystemMsgs[a][t].setColor(this.data.systemMsgs[a][t].color);
                    ++t;
                }
            }
            ++a;
        }
        a = 0;
        while (a < this.data.numEntries) {
            if (this.cbUserEntry[a][0] != null) {
                t = 0;
                while (t < 2) {
                    this.cbUserEntry[a][t].setState(this.data.userEntry[a][t].state);
                    this.cpUserEntry[a][t].setColor(this.data.userEntry[a][t].color);
                    ++t;
                }
            }
            ++a;
        }
    }

    private void CreateLayout() {
        Label l;
        int t;
        this.cbSystemUsage = new Checkbox[3];
        this.cpSystemUsage = new ColorPanel[3];
        int a = 0;
        while (a < 3) {
            if (this.data.systemUsage[a].exists) {
                this.cbSystemUsage[a] = new Checkbox();
                this.cbSystemUsage[a].setState(this.data.systemUsage[a].state);
                this.cpSystemUsage[a] = new ColorPanel(this.data.systemUsage[a].color);
                this.cpSystemUsage[a].addActionListener(this);
            }
            ++a;
        }
        this.cbSystemMsgs = new Checkbox[5][2];
        this.cpSystemMsgs = new ColorPanel[5][2];
        a = 0;
        while (a < 5) {
            t = 0;
            while (t < 2) {
                if (this.data.systemMsgs[a][0].exists || this.data.systemMsgs[a][1].exists) {
                    this.cbSystemMsgs[a][t] = new Checkbox();
                    this.cbSystemMsgs[a][t].setState(this.data.systemMsgs[a][t].state);
                    this.cpSystemMsgs[a][t] = new ColorPanel(this.data.systemMsgs[a][t].color);
                    this.cpSystemMsgs[a][t].addActionListener(this);
                }
                ++t;
            }
            ++a;
        }
        this.cbUserEntry = new Checkbox[this.data.numEntries][2];
        this.cpUserEntry = new ColorPanel[this.data.numEntries][2];
        a = 0;
        while (a < this.data.numEntries) {
            t = 0;
            while (t < 2) {
                if (this.data.userEntry[a][0].exists || this.data.userEntry[a][1].exists) {
                    this.cbUserEntry[a][t] = new Checkbox();
                    this.cbUserEntry[a][t].setState(this.data.userEntry[a][t].state);
                    this.cpUserEntry[a][t] = new ColorPanel(this.data.userEntry[a][t].color);
                    this.cpUserEntry[a][t].addActionListener(this);
                }
                ++t;
            }
            ++a;
        }
        Panel p = new Panel();
        this.add("Center", p);
        p.setBackground(Color.gray);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        p.setLayout(gbl);
        this.p1 = new GrayPanel();
        this.p2 = new GrayPanel();
        this.p4 = new GrayPanel();
        gbc.fill = 1;
        gbc.insets = new Insets(0, 2, 0, 2);
        Label lUsageA = new Label("SYSTEM USAGE", 0);
        lUsageA.setFont(new Font("SansSerif", 1, 12));
        this.p1.setLayout(gbl);
        Util.gblAdd(this.p1, lUsageA, gbc, 0, 0, 3, 1, 1, 0, 5, 5, 0, 5);
        int a2 = 0;
        while (a2 < 3) {
            if (this.data.systemUsage[a2].exists) {
                Label lUsage0 = new Label(this.data.systemUsage[a2].name, 2);
                Util.gblAdd(this.p1, lUsage0, gbc, 0, a2 + 1, 1, 1, 0, 0, 0, 5, 0, 5);
                Util.gblAdd(this.p1, this.cbSystemUsage[a2], gbc, 1, a2 + 1, 1, 1, 0, 0, 0, 0, 0, 0);
                Util.gblAdd(this.p1, this.cpSystemUsage[a2], gbc, 2, a2 + 1, 1, 1, 0, 0, 0, 0, 0, 5);
            }
            ++a2;
        }
        ScrollPane sp = new ScrollPane();
        Label lNote0 = new Label("* For a Y-Axis setting of Time:");
        Label lNote1 = new Label("- System Usage items will not be displayed.");
        Label lNote2 = new Label("- Selecting Creation AND/OR Processing will display the others.");
        lNote0.setFont(new Font("SansSerif", 0, 10));
        lNote1.setFont(new Font("SansSerif", 0, 10));
        lNote2.setFont(new Font("SansSerif", 0, 10));
        this.p2.setLayout(gbl);
        Util.gblAdd(this.p2, sp, gbc, 0, 0, 1, 1, 1, 1, 5, 5, 0, 5);
        Util.gblAdd(this.p2, lNote0, gbc, 0, 1, 1, 1, 1, 0, 0, 5, -1, 5);
        Util.gblAdd(this.p2, lNote1, gbc, 0, 2, 1, 1, 1, 0, 0, 5, -1, 5);
        Util.gblAdd(this.p2, lNote2, gbc, 0, 3, 1, 1, 1, 0, 0, 5, 5, 5);
        Label lhdr1 = new Label("SYSTEM MESSAGES", 0);
        Label lhdr2 = new Label("USER ENTRIES", 0);
        Label lC = new Label("Creation", 1);
        Label lP = new Label("Processing", 1);
        lhdr1.setFont(new Font("SansSerif", 1, 12));
        lhdr2.setFont(new Font("SansSerif", 1, 12));
        LWPanel p3 = new LWPanel();
        sp.add(p3);
        p3.setLayout(gbl);
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 2, 0, 2);
        Util.gblAdd(p3, lC, gbc, 1, 0, 2, 1, 1, 0);
        Util.gblAdd(p3, lP, gbc, 3, 0, 2, 1, 1, 0);
        Util.gblAdd(p3, lhdr1, gbc, 0, 1, 3, 1, 1, 0);
        int ypos = 2;
        int a3 = 0;
        while (a3 < 5) {
            if (this.data.systemMsgs[a3][0].exists) {
                l = new Label(this.data.systemMsgs[a3][0].name, 2);
                gbc.anchor = 10;
                gbc.fill = 1;
                Util.gblAdd(p3, l, gbc, 0, ypos, 1, 1, 1, 0, 0, 2, 0, 5);
                gbc.fill = 3;
                gbc.anchor = 13;
                Util.gblAdd(p3, this.cbSystemMsgs[a3][0], gbc, 1, ypos, 1, 1, 0, 0, 0, 0, 0, 0);
                Util.gblAdd(p3, this.cbSystemMsgs[a3][1], gbc, 3, ypos, 1, 1, 0, 0, 0, 0, 0, 0);
                gbc.anchor = 17;
                Util.gblAdd(p3, this.cpSystemMsgs[a3][0], gbc, 2, ypos, 1, 1, 0, 0, 0, 0, 0, 5);
                Util.gblAdd(p3, this.cpSystemMsgs[a3][1], gbc, 4, ypos++, 1, 1, 0, 0, 0, 0, 0, 5);
            }
            ++a3;
        }
        String chareName = new String();
        gbc.fill = 1;
        Util.gblAdd(p3, lhdr2, gbc, 0, ypos++, 1, 1, 1, 0);
        int a4 = 0;
        while (a4 < this.data.numEntries) {
            if (this.data.userEntry[a4][0].exists || this.data.userEntry[a4][1].exists) {
                gbc.anchor = 10;
                gbc.fill = 1;
                if (!this.data.userEntry[a4][0].parent.equals(chareName)) {
                    chareName = this.data.userEntry[a4][0].parent;
                    l = new Label(chareName, 0);
                    Util.gblAdd(p3, l, gbc, 0, ypos++, 3, 1, 1, 0);
                }
                l = new Label(this.data.userEntry[a4][0].name, 2);
                Util.gblAdd(p3, l, gbc, 0, ypos, 1, 1, 1, 0, 0, 2, 0, 5);
                gbc.fill = 3;
                gbc.anchor = 13;
                Util.gblAdd(p3, this.cbUserEntry[a4][0], gbc, 1, ypos, 1, 1, 0, 0, 0, 0, 0, 0);
                Util.gblAdd(p3, this.cbUserEntry[a4][1], gbc, 3, ypos, 1, 1, 0, 0, 0, 0, 0, 0);
                gbc.anchor = 17;
                Util.gblAdd(p3, this.cpUserEntry[a4][0], gbc, 2, ypos, 1, 1, 0, 0, 0, 0, 0, 5);
                Util.gblAdd(p3, this.cpUserEntry[a4][1], gbc, 4, ypos++, 1, 1, 0, 0, 0, 0, 0, 5);
            }
            ++a4;
        }
        sp.validate();
        this.p4.setLayout(new FlowLayout());
        this.bAll = new Button("Select All");
        this.bClear = new Button("Clear All");
        this.bApply = new Button("Apply");
        this.bClose = new Button("Close");
        this.bAll.addActionListener(this);
        this.bClear.addActionListener(this);
        this.bApply.addActionListener(this);
        this.bClose.addActionListener(this);
        this.p4.add(this.bAll);
        this.p4.add(this.bClear);
        this.p4.add(this.bApply);
        this.p4.add(this.bClose);
        gbc.fill = 1;
        Util.gblAdd(p, this.p1, gbc, 0, 0, 1, 1, 1, 0, 4, 4, 2, 4);
        Util.gblAdd(p, this.p2, gbc, 0, 1, 1, 1, 1, 1, 2, 4, 2, 4);
        Util.gblAdd(p, this.p4, gbc, 0, 2, 1, 1, 1, 0, 2, 4, 4, 4);
    }
}

