/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;

public class AnimationColorBarPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private float MAXHUE = 0.65f;
    private FontMetrics fm;
    private int textwidth0;
    private int textwidth100;
    private int textheight;

    public AnimationColorBarPanel() {
        this.setBackground(Color.black);
        this.setForeground(Color.white);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        int h = 60;
        int w = this.getSize().width;
        return new Dimension(w, h);
    }

    public void paint(Graphics g) {
        if (this.fm == null) {
            this.fm = g.getFontMetrics(g.getFont());
            this.textheight = this.fm.getHeight();
            this.textwidth0 = this.fm.stringWidth("0%");
            this.textwidth100 = this.fm.stringWidth("100%");
        }
        float H = this.MAXHUE;
        int width = this.getSize().width;
        int height = this.getSize().height;
        g.setColor(Color.white);
        g.drawString("0%", 20, (height + this.textheight) / 2);
        g.drawString("100%", width - 20 - this.textwidth100, (height + this.textheight) / 2);
        int cbwidth = width - this.textwidth0 - this.textwidth100 - 60;
        int cbheight = 20;
        float deltaH = H / (float)cbwidth;
        int leftoffset = 30 + this.textwidth0;
        int topoffset = (height - cbheight) / 2;
        for (int i = 0; i < cbwidth; ++i) {
            g.setColor(Color.getHSBColor(H, 0.7f, 1.0f));
            H -= deltaH;
            g.drawLine(leftoffset + i, topoffset, leftoffset + i, topoffset + cbheight);
        }
    }
}

