/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.image.ColorModel;

class ColorMap {
    int[] red = new int[256];
    int[] green = new int[256];
    int[] blue = new int[256];
    ColorModel cm;
    boolean cm_cached = false;

    ColorMap() {
    }

    public void addBreak(int sDex, int sRed, int sGreen, int sBlue, int eDex, int eRed, int eGreen, int eBlue) {
        this.cm_cached = false;
        eRed -= sRed;
        eGreen -= sGreen;
        eBlue -= sBlue;
        for (int i = sDex; i <= eDex; ++i) {
            float fac = (float)(i - sDex) / (float)(eDex - sDex);
            this.red[i] = (int)((float)sRed + fac * (float)eRed);
            this.green[i] = (int)((float)sGreen + fac * (float)eGreen);
            this.blue[i] = (int)((float)sBlue + fac * (float)eBlue);
        }
    }

    public void addBreaks(int[] dex, int[] r, int[] g, int[] b) {
        for (int i = 1; i < dex.length; ++i) {
            this.addBreak(dex[i - 1], r[i - 1], g[i - 1], b[i - 1], dex[i], r[i], g[i], b[i]);
        }
    }

    public int apply(int v) {
        return 0xFF000000 | this.red[v] << 16 | this.green[v] << 8 | this.blue[v] << 0;
    }

    public void initGrey() {
        this.cm_cached = false;
        for (int i = 0; i < 256; ++i) {
            byte by = (byte)(0xFF & i);
            this.blue[i] = by;
            this.green[i] = by;
            this.red[i] = by;
        }
    }
}

