/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import projections.analysis.ViewerEvent;
import projections.gui.MainWindow;
import projections.misc.LogLoadException;

public class LogFileViewerTextArea
extends JPanel {
    static int myRun = 0;
    JTextPane textPane;
    JScrollPane scrollPane;

    public LogFileViewerTextArea() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(800, 500));
        String text = new String("<html><body>Log Not Yet Loaded</body></html>");
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textPane.setContentType("text/html");
        this.textPane.setText(text);
        this.scrollPane = new JScrollPane(this.textPane);
        this.add((Component)this.scrollPane, "Center");
    }

    public void setPE(int PE, long startTime, long endTime) {
        Vector v;
        if (!MainWindow.runObject[myRun].hasLogData()) {
            this.textPane.setText("<h1>ERROR: Don't have any log data</h1>");
            return;
        }
        try {
            v = MainWindow.runObject[LogFileViewerTextArea.myRun].logLoader.view(PE);
        }
        catch (LogLoadException e) {
            this.textPane.setText("<h1>Failed to load Log files for PE " + PE + "</h1>");
            return;
        }
        if (v == null || v.size() == 0) {
            this.textPane.setText("<h1>Don't have log data for PE " + PE + "</h1>");
            return;
        }
        int length = v.size();
        StringBuilder htmlFormattedTable = new StringBuilder(length * 150);
        htmlFormattedTable.append("<html><body><font size=+2> All events in log for PE " + PE + " with times between " + startTime + " and " + endTime + "</font>");
        htmlFormattedTable.append("<table><tr><td><h2>Time</h2><td><h2>Event type and description</h2>");
        int i = 0;
        while (i < length) {
            ViewerEvent ve = (ViewerEvent)v.elementAt(i);
            if (ve.Time >= startTime && ve.Time <= endTime) {
                htmlFormattedTable.append("<tr><td>" + ve.Time + "<td>");
                switch (ve.EventType) {
                    case 1: {
                        htmlFormattedTable.append("<font size=+1 color=\"#660000\">CREATE</font> message to be sent to <em>" + ve.Dest + "</em>");
                        break;
                    }
                    case 20: {
                        if (ve.numDestPEs == MainWindow.runObject[myRun].getNumProcessors()) {
                            htmlFormattedTable.append("<font size=+1 color=\"#666600\">GROUP BROADCAST</font> (" + ve.numDestPEs + " processors)");
                            break;
                        }
                        htmlFormattedTable.append("<font size=+1 color=\"#666600\">NODEGROUP BROADCAST</font> (" + ve.numDestPEs + " processors)");
                        break;
                    }
                    case 21: {
                        htmlFormattedTable.append("<td><font size=+1 color=\"#666600\">MULTICAST</font> message sent to " + ve.numDestPEs + " processors");
                        break;
                    }
                    case 2: {
                        htmlFormattedTable.append("<font size=+1 color=\"#000088\">BEGIN PROCESSING</font> of message sent to <em>" + ve.Dest + "</em> from processor " + ve.SrcPe);
                        break;
                    }
                    case 3: {
                        htmlFormattedTable.append("<font size=+1 color=\"#000088\">END PROCESSING</font> of message sent to <em>" + ve.Dest + "</em> from processor " + ve.SrcPe);
                        htmlFormattedTable.append("<tr>");
                        break;
                    }
                    case 4: {
                        htmlFormattedTable.append("<font size=+1>ENQUEUEING</font> message received from processor " + ve.SrcPe + " destined for " + ve.Dest);
                        break;
                    }
                    case 14: {
                        htmlFormattedTable.append("<font size=+1 color=\"#333333\">IDLE begin</font>");
                        break;
                    }
                    case 15: {
                        htmlFormattedTable.append("<font size=+1 color=\"#333333\">IDLE end</font>");
                        htmlFormattedTable.append("<tr>");
                        break;
                    }
                    case 16: {
                        htmlFormattedTable.append("<font size=+1 color=\"#008800\">BEGIN PACKING</font> a message to be sent");
                        break;
                    }
                    case 17: {
                        htmlFormattedTable.append("<font size=+1 color=\"#008800\">FINISHED PACKING</font> a message to be sent");
                        break;
                    }
                    case 18: {
                        htmlFormattedTable.append("<font size=+1 color=\"#880000\">BEGIN UNPACKING</font> a received message");
                        break;
                    }
                    case 19: {
                        htmlFormattedTable.append("<font size=+1 color=\"#880000\">FINISHED UNPACKING</font> a received message");
                        break;
                    }
                    default: {
                        htmlFormattedTable.append("Unknown Event Type:" + ve.EventType + " !!!");
                    }
                }
            }
            ++i;
        }
        htmlFormattedTable.append("</table></body></html>");
        this.textPane.setText(htmlFormattedTable.toString());
        this.textPane.setSelectionStart(0);
        this.textPane.setSelectionEnd(0);
    }
}

