/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import projections.analysis.MultiRunDataAnalyzer;
import projections.gui.count.TableSorter;
import projections.misc.MultiRunTableModel;

public class MultiRunTables
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private MultiRunDataAnalyzer analysisModule;

    public MultiRunTables(int defaultDataType, MultiRunDataAnalyzer analysisModule) {
        this.analysisModule = analysisModule;
        String[] categories = analysisModule.getCategoryNames();
        for (int category = 0; category < categories.length; ++category) {
            this.makeTable(categories[category], null, Color.black, defaultDataType, category);
        }
    }

    public void setType(int dataType) {
        int numTables = this.getTabCount();
        for (int tableIdx = 0; tableIdx < numTables; ++tableIdx) {
            JTable table = (JTable)((JScrollPane)this.getComponentAt(tableIdx)).getViewport().getView();
            MultiRunTableModel model = (MultiRunTableModel)((TableSorter)table.getModel()).getModel();
            model.setType(dataType);
            table.repaint();
        }
    }

    public void makeTable(String name, String toolTip, Color color, int dataType, int category) {
        MultiRunTableModel tableModel = new MultiRunTableModel(name, this.analysisModule, dataType, category);
        TableSorter sorter = new TableSorter(tableModel);
        JTable table = new JTable(sorter);
        sorter.addMouseListenerToHeaderInTable(table);
        this.initColumnSizes(table);
        table.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(table);
        table.setPreferredScrollableViewportSize(new Dimension(500, 500));
        this.addTab(name, null, scrollPane, toolTip);
        this.setForegroundAt(this.indexOfComponent(scrollPane), color);
    }

    private void initColumnSizes(JTable table) {
        TableCellRenderer defaultHeaderRenderer = table.getTableHeader().getDefaultRenderer();
        for (int col = 0; col < table.getColumnCount(); ++col) {
            TableColumn column = table.getColumnModel().getColumn(col);
            column.setHeaderRenderer(defaultHeaderRenderer);
            Component comp = column.getHeaderRenderer().getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            int headerWidth = comp.getPreferredSize().width;
            column.setPreferredWidth(headerWidth);
        }
    }
}

