/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class MyButton
extends Component
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private String text;
    private FontMetrics fm;
    private boolean highlighted = false;
    private boolean pressed = false;
    private boolean enabled = true;
    private ActionListener actionListener = null;
    private Color border;

    public MyButton(String s, Color c) {
        this.text = s;
        this.border = c;
        this.addMouseListener(this);
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public Dimension getMinimumSize() {
        Graphics g;
        int w = 20;
        int h = 20;
        if (this.fm == null && (g = this.getGraphics()) != null) {
            this.fm = g.getFontMetrics();
        }
        if (this.fm != null) {
            w = this.fm.stringWidth(this.text) + 20;
            h = this.fm.getHeight() + 10;
        }
        return new Dimension(w, h);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void mouseClicked(MouseEvent evt) {
        if (this.enabled) {
            this.processActionEvent();
        }
    }

    public void mouseEntered(MouseEvent evt) {
        if (this.enabled && !this.highlighted) {
            this.highlighted = true;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent evt) {
        if (this.enabled && (this.highlighted || this.pressed)) {
            this.highlighted = false;
            this.pressed = false;
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent evt) {
        if (this.enabled) {
            this.pressed = true;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.enabled) {
            this.pressed = false;
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (this.fm == null) {
            this.fm = g.getFontMetrics();
        }
        g.setColor(this.border);
        g.drawRect(0, 0, w - 1, h - 1);
        if (!this.enabled) {
            g.setColor(Color.gray);
        } else if (this.pressed) {
            g.setColor(Color.red);
        } else if (this.highlighted) {
            g.setColor(Color.yellow);
        } else {
            g.setColor(Color.white);
        }
        g.drawString(this.text, 5, (h + this.fm.getHeight()) / 2 - 3);
        super.paint(g);
    }

    public void processActionEvent() {
        if (this.enabled && this.actionListener != null) {
            ActionEvent ae = new ActionEvent(this, 1001, "MyButton Action");
            this.actionListener.actionPerformed(ae);
        }
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

