/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import projections.gui.ProfileData;

public class ProfileAxisCanvas
extends Canvas {
    private static final long serialVersionUID = 1L;
    private ProfileData data;
    private Image offscreen;
    private FontMetrics fm;
    private int textheight;

    public ProfileAxisCanvas(ProfileData data) {
        this.data = data;
        this.setForeground(Color.white);
        this.setBackground(Color.black);
    }

    private void drawAxis(Graphics g) {
        int w = this.getSize().width;
        if (this.fm == null) {
            this.fm = g.getFontMetrics(g.getFont());
            this.textheight = this.fm.getHeight();
        }
        g.setColor(this.getForeground());
        g.drawLine(w - 1, this.data.offset, w - 1, this.data.dch);
        float deltay = (float)((double)(this.data.dch - this.data.offset) / 100.0);
        int labelincrement = (int)Math.ceil((float)this.textheight / deltay);
        int[] indices = new int[]{1, 2, 5, 25};
        int best = -1;
        for (int i = 0; i < indices.length; ++i) {
            int t = 0;
            int sum = 0;
            while ((sum = (int)((double)indices[i] * Math.pow(10.0, t))) < labelincrement) {
                ++t;
            }
            if (sum - labelincrement >= best - labelincrement && best >= 0) continue;
            best = sum;
        }
        labelincrement = best;
        for (int y = 0; y <= 100; ++y) {
            int cury = this.data.dch - (int)((float)y * deltay) - 1;
            if (y % labelincrement == 0) {
                String tmp = "" + y;
                g.drawLine(w - 10, cury, w, cury);
                cury += (int)(0.5 * (double)this.textheight);
                if (y == 0) continue;
                g.drawString(tmp, w - 15 - this.fm.stringWidth(tmp), cury);
                continue;
            }
            g.drawLine(w - 7, cury, w, cury);
        }
    }

    public void makeNewImage() {
        this.offscreen = null;
        if (this.data.plist == null) {
            return;
        }
        int w = this.getSize().width;
        if (w > 0 && this.data.dch > 0) {
            this.offscreen = this.createImage(w, this.data.dch + 30);
            if (this.offscreen == null) {
                return;
            }
            Graphics og = this.offscreen.getGraphics();
            og.setClip(0, 0, w, this.data.dch);
            this.drawAxis(og);
            og.dispose();
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        if (this.offscreen != null) {
            int y = this.data.profileWindow.getVSBValue();
            int w = this.getSize().width;
            g.drawImage(this.offscreen, 0, 0, w, this.data.vph, 0, y, w, this.data.vph + y, null);
        }
    }

    public void print(Graphics pg) {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        int vsbval = this.data.profileWindow.getVSBValue();
        pg.translate(0, -vsbval);
        this.drawAxis(pg);
        this.setBackground(Color.black);
        this.setForeground(Color.white);
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

