/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import projections.gui.Timeline.Data;
import projections.gui.Util;

public class AxisPanel
extends JPanel {
    private int smallTickHalfLength = 2;
    private int largeTickHalfLength = 5;
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private Data data;
    private DecimalFormat format_ = new DecimalFormat();

    private int totalHeight() {
        if (this.data.useMinimalView()) {
            return this.axispos() + this.largeTickHalfLength;
        }
        return 24 + this.axispos() + this.largeTickHalfLength;
    }

    private int axispos() {
        if (this.data.useMinimalView()) {
            return 2 + this.largeTickHalfLength + this.textpos();
        }
        return 5 + this.largeTickHalfLength + this.textpos();
    }

    public int axisLabelPositionY() {
        if (this.data.useMinimalView()) {
            return 0;
        }
        return 15;
    }

    private int textpos() {
        if (this.data.useMinimalView()) {
            return this.data.axisFont.getSize() + this.axisLabelPositionY();
        }
        return 5 + this.data.axisFont.getSize() + this.axisLabelPositionY();
    }

    public AxisPanel(Data data) {
        this.data = data;
        this.format_.setGroupingUsed(true);
    }

    public Dimension getPreferredSize() {
        int preferredWidth = 200;
        int preferredHeight = this.totalHeight();
        return new Dimension(preferredWidth, preferredHeight);
    }

    public int calcHSBOffset(double startTime) {
        double percentOffset = (startTime - (double)this.data.beginTime()) / (double)this.data.totalTime();
        double actualOffset = percentOffset * (double)(this.getWidth() - this.data.leftOffset() - this.data.rightOffset());
        return (int)(actualOffset + (double)this.data.leftOffset() + 0.5);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setFont(this.data.axisFont);
        FontMetrics fm = g.getFontMetrics();
        g.setColor(this.data.getBackgroundColor());
        Rectangle clipBounds = g.getClipBounds();
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        int maxx = this.getWidth();
        g.setColor(this.data.getForegroundColor());
        g.drawLine(this.data.offset(), this.axispos(), maxx - this.data.offset(), this.axispos());
        int x = 0;
        while (x < this.numIntervals()) {
            int curx = this.data.leftOffset() + (int)((double)x * this.pixelsPerTickMark());
            if (curx > maxx) break;
            if (x % this.labelIncrement() == 0) {
                String tmp = this.format_.format(this.data.screenToTime(curx));
                g.drawLine(curx, this.axispos() - this.largeTickHalfLength, curx, this.axispos() + this.largeTickHalfLength);
                g.drawString(tmp, curx - fm.stringWidth(tmp) / 2, this.textpos());
            } else {
                g.drawLine(curx, this.axispos() - this.smallTickHalfLength, curx, this.axispos() + this.smallTickHalfLength);
            }
            ++x;
        }
        g.drawString(this.axisLabel(), this.getWidth() / 2 - fm.stringWidth(this.axisLabel()) / 2, this.axisLabelPositionY());
    }

    public String axisLabel() {
        return "Time In Microseconds";
    }

    public int numIntervals() {
        return (int)Math.ceil(this.data.totalTime() / (long)this.timeIncrement(this.getWidth())) + 1;
    }

    public int labelIncrement() {
        return Util.getBestIncrement((int)Math.ceil((double)this.data.maxLabelLen() / this.pixelsPerTickMark()));
    }

    public int timeIncrement(int actualDisplayWidth) {
        return Util.getBestIncrement((int)Math.ceil(5.0 / ((double)this.data.lineWidth(actualDisplayWidth) / (double)this.data.totalTime())));
    }

    public double pixelsPerTickMark() {
        return (double)this.data.lineWidth(this.getWidth()) / (double)this.numIntervals();
    }
}

