/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class SaveImage {
    private static final long serialVersionUID = 1L;
    private JPanel view;
    private BufferedImage image;

    public SaveImage(JPanel view_) {
        this.view = view_;
    }

    private void generateImage() {
        int width = this.view.getWidth();
        int height = this.view.getHeight();
        System.out.println("Saving timeline image of size " + width + "x" + height);
        this.image = new BufferedImage(width, height, 1);
        Graphics2D g = this.image.createGraphics();
        this.view.paint(g);
        g.dispose();
    }

    public Image getImage() {
        this.generateImage();
        return this.image;
    }

    public void saveImagePNG(String filename) {
        this.generateImage();
        try {
            ImageIO.write((RenderedImage)this.image, "png", new File(filename));
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    public void saveImageJPEG(String filename) {
        this.generateImage();
        try {
            ImageIO.write((RenderedImage)this.image, "jpg", new File(filename));
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }
}

