/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import projections.gui.Util;

public class LegendCanvas
extends Canvas
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private String[] labels = null;
    private Color[] colorMap = null;
    private int[] sortMap = null;
    private int[] reverseMap = null;
    private boolean[] selection;
    private boolean[] showFilter = null;
    private FontMetrics fm;
    private int textheight;
    private int maxTextWidth;
    private int posx;
    private int posy;

    public LegendCanvas() {
        this.setSize(this.getPreferredSize());
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.addMouseListener(this);
    }

    public void paint(Graphics g) {
        if (this.labels == null) {
            return;
        }
        this.fm = g.getFontMetrics(g.getFont());
        this.textheight = this.fm.getHeight();
        this.maxTextWidth = 10;
        this.posx = 10;
        this.posy = 10;
        int linecount = 0;
        for (int i = 0; i < this.labels.length; ++i) {
            if (!this.showFilter[this.sortMap[i]]) continue;
            this.reverseMap[linecount] = this.sortMap[i];
            ++linecount;
            if (this.selection[this.sortMap[i]]) {
                this.paintSelected(g, this.labels[this.sortMap[i]], this.colorMap[this.sortMap[i]]);
                continue;
            }
            this.paintLabel(g, this.labels[this.sortMap[i]], this.colorMap[this.sortMap[i]]);
        }
        this.setSize(new Dimension(this.maxTextWidth, this.posy));
    }

    public void setColors(Color[] NcolorMap) {
        this.colorMap = NcolorMap;
        this.repaint();
    }

    public void setFilter(boolean[] NshowFilter) {
        this.showFilter = NshowFilter;
        if (this.showFilter == null) {
            this.defaultShowFilter(this.labels.length);
        }
        this.repaint();
    }

    public void setSort(int[] NsortMap) {
        this.sortMap = NsortMap;
        if (this.sortMap == null) {
            this.defaultSortMap(this.labels.length);
        }
        this.repaint();
    }

    public void setData(String[] Nlabels, Color[] NcolorMap, boolean[] NshowFilter, int[] NsortMap) {
        this.labels = Nlabels;
        this.selection = new boolean[this.labels.length];
        this.reverseMap = new int[this.labels.length];
        this.colorMap = NcolorMap;
        if (NshowFilter == null) {
            this.defaultShowFilter(this.labels.length);
        } else {
            this.showFilter = NshowFilter;
        }
        if (NsortMap == null) {
            this.defaultSortMap(this.labels.length);
        } else {
            this.sortMap = NsortMap;
        }
        this.repaint();
    }

    public boolean[] getSelection() {
        return Util.andFilters(this.selection, this.showFilter);
    }

    public int[] getSort() {
        return this.sortMap;
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 200);
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 400);
    }

    private void paintLabel(Graphics g, String label, Color color) {
        Color originalColor = g.getColor();
        g.setColor(color);
        g.fillRect(this.posx, this.posy, this.textheight * 2, this.textheight);
        g.drawString(label, this.posx + this.textheight * 3, this.posy + this.textheight);
        if (this.posx + this.textheight * 3 + this.fm.stringWidth(label) > this.maxTextWidth) {
            this.maxTextWidth = this.posx + this.textheight * 3 + this.fm.stringWidth(label);
        }
        g.setColor(this.getBackground());
        g.drawRect(this.posx + 1, this.posy + 1, (this.textheight - 1) * 2 - 1, this.textheight - 2 - 1);
        this.posy += this.textheight * 3 / 2;
        g.setColor(originalColor);
    }

    private void paintSelected(Graphics g, String label, Color color) {
        Color originalColor = g.getColor();
        g.setColor(color.brighter());
        g.drawRect(this.posx, this.posy, this.textheight * 2, this.textheight);
        g.drawLine(this.posx, this.posy, this.posx + this.textheight * 2, this.posy + this.textheight);
        g.drawLine(this.posx + this.textheight * 2, this.posy, this.posx, this.posy + this.textheight);
        g.drawString(label, this.posx + this.textheight * 3, this.posy + this.textheight);
        if (this.posx + this.textheight * 3 + this.fm.stringWidth(label) > this.maxTextWidth) {
            this.maxTextWidth = this.posx + this.textheight * 3 + this.fm.stringWidth(label);
        }
        this.posy += this.textheight * 3 / 2;
        g.setColor(originalColor);
    }

    private int yPixelToLineNum(int yPixel) {
        int offset = 10;
        int lineBlock = (yPixel - offset) / (this.textheight * 3 / 2);
        if (yPixel - offset > lineBlock * (this.textheight * 3 / 2) + this.textheight) {
            return -1;
        }
        return lineBlock;
    }

    private void defaultShowFilter(int length) {
        this.showFilter = new boolean[length];
        for (int i = 0; i < length; ++i) {
            this.showFilter[i] = true;
        }
    }

    private void defaultSortMap(int length) {
        this.sortMap = new int[length];
        for (int i = 0; i < length; ++i) {
            this.sortMap[i] = i;
        }
    }

    public void actionPerformed(ActionEvent evt) {
        String actionCommand = evt.getActionCommand();
        if (actionCommand.equals("select")) {
            for (int i = 0; i < this.selection.length; ++i) {
                this.selection[i] = true;
            }
            this.repaint();
        } else if (actionCommand.equals("unselect")) {
            for (int i = 0; i < this.selection.length; ++i) {
                this.selection[i] = false;
            }
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent evt) {
        int lineNumber = this.yPixelToLineNum(evt.getY());
        if (lineNumber != -1) {
            this.selection[this.reverseMap[lineNumber]] = !this.selection[this.reverseMap[lineNumber]];
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }
}

