/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.ccs.CcsServer;
import charm.debug.ParDebug;
import charm.debug.PasswordDialog;
import charm.debug.preference.Execution;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.SwingUtilities;

public abstract class ServThread
extends Thread {
    String hostName = null;
    String portno = null;
    ParDebug mainThread = null;
    volatile int flag;
    static final int maxChunk = 51200;
    public FileWriter debugOutput;
    public static String infoStr;

    public ServThread(ParDebug d) {
        this.mainThread = d;
        this.flag = 0;
    }

    abstract String getNextOutput(StringBuffer var1) throws Exception;

    @Override
    public void run() {
        try {
            System.out.println("ServThread started");
            try {
                String outline;
                do {
                    StringBuffer outlinechunk = new StringBuffer();
                    outline = this.getNextOutput(outlinechunk);
                    this.process(outlinechunk);
                } while (outline != null);
                System.out.println("ServThread terminated");
                this.flag = 2;
            }
            catch (Exception e) {
                System.out.println("Failed to print");
                e.printStackTrace();
            }
            System.out.println("Finished running parallel program");
            Runnable doWorkRunnable = new Runnable(){

                @Override
                public void run() {
                    ServThread.this.mainThread.quitProgram();
                }
            };
            SwingUtilities.invokeLater(doWorkRunnable);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("error in ServThread. Exception caught");
        }
    }

    void process(StringBuffer outlinechunk) {
        int cpdStart;
        while ((cpdStart = outlinechunk.indexOf("CPD: ")) != -1) {
            Notify doWorkRunnable;
            int cpdEnd = outlinechunk.indexOf("\n", cpdStart + 1);
            String outline = outlinechunk.substring(cpdStart + 5, cpdEnd);
            outlinechunk.delete(cpdStart, cpdEnd + 1);
            if (outline.indexOf("Break point reached", 0) != -1) {
                this.mainThread.setStatusMessage(outline);
                doWorkRunnable = new Notify(outline){

                    @Override
                    public void run() {
                        ServThread.this.mainThread.notifyBreakpoint(this.text);
                    }
                };
                SwingUtilities.invokeLater(doWorkRunnable);
                continue;
            }
            if (outline.indexOf("Frozen processor") != -1) {
                this.mainThread.setStatusMessage(outline);
                doWorkRunnable = new Notify(outline){

                    @Override
                    public void run() {
                        ServThread.this.mainThread.notifyFreeze(this.text);
                    }
                };
                SwingUtilities.invokeLater(doWorkRunnable);
                continue;
            }
            if (outline.indexOf("CmiAbort called") != -1) {
                this.mainThread.setStatusMessage(outline.substring(5));
                doWorkRunnable = new Notify(outline){

                    @Override
                    public void run() {
                        ServThread.this.mainThread.notifyAbort(this.text);
                    }
                };
                SwingUtilities.invokeLater(doWorkRunnable);
                continue;
            }
            if (outline.indexOf("Signal received") != -1) {
                this.mainThread.setStatusMessage(outline.substring(5));
                doWorkRunnable = new Notify(outline){

                    @Override
                    public void run() {
                        ServThread.this.mainThread.notifySignal(this.text);
                    }
                };
                SwingUtilities.invokeLater(doWorkRunnable);
                continue;
            }
            System.out.println("ServThread: error while processing string '" + outline + "'");
        }
        if (outlinechunk.length() > 0) {
            System.out.println("Parallel program printed: " + outlinechunk.toString());
            this.mainThread.displayProgramOutput(outlinechunk.toString());
        }
    }

    public int getFlag() {
        return this.flag;
    }

    public abstract class Notify
    implements Runnable {
        public String text;

        public Notify(String txt) {
            this.text = txt;
        }
    }

    public static class File
    extends ServThread {
        BufferedReader prout;

        public File(ParDebug d, java.io.File f) {
            super(d);
            try {
                this.prout = new BufferedReader(new FileReader(f));
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not open file " + f);
            }
        }

        @Override
        String getNextOutput(StringBuffer outlinechunk) throws Exception {
            String outline;
            boolean foundPort = false;
            while ((outline = this.prout.readLine()) != null) {
                if (!foundPort) {
                    if (outline.indexOf("ccs: Server IP =", 0) != -1) {
                        int nameStart = outline.indexOf("Server IP = ", 0);
                        int nameEnd = outline.indexOf(",", nameStart += 12);
                        this.hostName = outline.substring(nameStart, nameEnd);
                        int portStart = outline.indexOf("Server port = ", 0);
                        int portEnd = outline.indexOf("$", 0);
                        this.portno = outline.substring(portStart += 14, portEnd - 1);
                        foundPort = true;
                        this.flag = 1;
                    }
                    if (outline.indexOf("Password:", 0) != -1) {
                        System.out.println("Password requested");
                        char[] passwd = null;
                        new PasswordDialog(passwd);
                        System.out.println(passwd);
                    }
                }
                outlinechunk.append(outline + "\n");
                if (this.prout.ready() && outlinechunk.length() < 51200) continue;
            }
            return outline;
        }
    }

    public static class CCS
    extends ServThread {
        CcsServer server;

        public CCS(ParDebug d, Execution e) {
            super(d);
            String[] args = new String[]{e.hostname, e.port};
            this.server = CcsServer.create(args, false);
            System.out.println("Created CCSserver");
            try {
                this.server.sendRequest("redirect stdio", 0);
            }
            catch (IOException e1) {
                System.out.println("redirect stdio request failed");
            }
        }

        @Override
        String getNextOutput(StringBuffer outlinechunk) {
            try {
                CcsServer.Request r = this.server.sendRequest("fetch stdio", 0);
                byte[] resp = this.server.recvResponse(r);
                System.out.println("reply fetch stdio: " + new String(resp));
                if (resp != null) {
                    outlinechunk.append(new String(resp));
                    return new String(resp);
                }
                return null;
            }
            catch (IOException e) {
                System.out.println("Exception while fetching stdio");
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class Charmrun
    extends ServThread {
        Process p = null;
        BufferedReader prout;
        BufferedReader prerr;

        public Charmrun(ParDebug d, Process par) {
            super(d);
            this.p = par;
            this.prout = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
            this.prerr = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
        }

        @Override
        String getNextOutput(StringBuffer outlinechunk) throws Exception {
            String outline;
            boolean foundPort = false;
            while ((outline = this.prout.readLine()) != null) {
                if (!foundPort) {
                    if (outline.indexOf("ccs: Server IP =", 0) != -1) {
                        int nameStart = outline.indexOf("Server IP = ", 0);
                        int nameEnd = outline.indexOf(",", nameStart += 12);
                        this.hostName = outline.substring(nameStart, nameEnd);
                        int portStart = outline.indexOf("Server port = ", 0);
                        int portEnd = outline.indexOf("$", 0);
                        this.portno = outline.substring(portStart += 14, portEnd - 1);
                        foundPort = true;
                        this.flag = 1;
                    }
                    if (outline.indexOf("Password:", 0) != -1) {
                        System.out.println("Password requested");
                        char[] passwd = null;
                        new PasswordDialog(passwd);
                        System.out.println(passwd);
                    }
                }
                outlinechunk.append(outline + "\n");
                if (this.prout.ready() && outlinechunk.length() < 51200) continue;
            }
            return outline;
        }
    }
}

