/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import projections.gui.GraphAttributesWindow;
import projections.gui.GraphData;
import projections.gui.MainWindow;
import projections.gui.Util;

public class GraphLegendPanel
extends Panel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private Frame parent;
    private GridBagConstraints gbc;
    private Button bSelect;
    private LegendCanvas listPanel;
    private ScrollPane sp;
    GraphData data = null;
    private GraphAttributesWindow attributesWindow;
    PrintJob pjob;

    public GraphLegendPanel(Frame parent) {
        this.parent = parent;
        this.setBackground(Color.lightGray);
        this.sp = new ScrollPane();
        this.listPanel = new LegendCanvas(this.sp);
        this.bSelect = new Button("Select Display Items");
        this.sp.add(this.listPanel);
        this.sp.setBackground(Color.lightGray);
        this.bSelect.addActionListener(this);
        GridBagLayout gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.setLayout(gbl);
        this.gbc.fill = 1;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        Util.gblAdd(this, new Label("LEGEND", 1), this.gbc, 0, 0, 1, 1, 1, 0);
        Util.gblAdd(this, this.sp, this.gbc, 0, 1, 1, 1, 1, 10);
        Util.gblAdd(this, this.bSelect, this.gbc, 0, 2, 1, 1, 1, 0);
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.data == null) {
            return;
        }
        Button b = (Button)evt.getSource();
        if (b == this.bSelect) {
            if (this.attributesWindow == null) {
                this.attributesWindow = new GraphAttributesWindow(this.parent, this.data);
            }
            this.attributesWindow.setVisible(true);
        }
    }

    public void closeAttributesWindow() {
        if (this.attributesWindow != null) {
            this.attributesWindow.setVisible(false);
            this.attributesWindow.dispose();
            this.attributesWindow = null;
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(80, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(140, 200);
    }

    public void paint(Graphics g) {
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        super.paint(g);
    }

    public void PrintLegend(Graphics pg, PrintJob pjob) {
        this.pjob = pjob;
        this.listPanel.printAll(pg);
    }

    public void setGraphData(GraphData data) {
        this.data = data;
    }

    public void UpdateLegend() {
        this.listPanel.repaint();
        this.sp.validate();
    }

    private class LegendCanvas
    extends Canvas {
        private static final long serialVersionUID = 1L;
        private FontMetrics fm;
        private int textheight;
        private ScrollPane sp;
        private int width;
        private int height;

        public LegendCanvas(ScrollPane sp) {
            this.sp = sp;
            this.setBackground(Color.black);
        }

        public void print(Graphics pg) {
            int marginTop;
            int marginLeft;
            if (GraphLegendPanel.this.data == null) {
                return;
            }
            this.setBackground(Color.white);
            pg.clearRect(0, 0, this.getSize().width, this.getSize().height);
            Dimension d = GraphLegendPanel.this.pjob.getPageDimension();
            if (d.width < d.height) {
                marginLeft = (int)(0.7 * (double)d.width / 8.5);
                marginTop = (int)(0.7 * (double)d.height / 11.0);
            } else {
                marginLeft = (int)(0.7 * (double)d.width / 11.0);
                marginTop = (int)(0.7 * (double)d.height / 8.5);
            }
            int printWidth = d.width - 2 * marginLeft;
            int printHeight = d.height - 2 * marginTop;
            pg.translate(marginLeft, marginTop);
            if (this.fm == null) {
                this.fm = pg.getFontMetrics(pg.getFont());
                this.textheight = this.fm.getHeight() + 2;
            }
            this.height = this.textheight;
            pg.setColor(Color.black);
            String s = "LEGEND";
            pg.drawString(s, (printWidth - this.fm.stringWidth(s)) / 2, this.height);
            this.height += this.textheight;
            this.width = 0;
            int a = 0;
            while (a < GraphLegendPanel.this.data.onGraph.length) {
                if (GraphLegendPanel.this.data.ymode == 11 && GraphLegendPanel.this.data.onGraph[a].ymode != 10 || GraphLegendPanel.this.data.ymode == 10 && GraphLegendPanel.this.data.onGraph[a].ymode != 11) {
                    pg.setColor(GraphLegendPanel.this.data.onGraph[a].color);
                    s = GraphLegendPanel.this.data.onGraph[a].name;
                    if (!GraphLegendPanel.this.data.onGraph[a].type.equals("%") && !GraphLegendPanel.this.data.onGraph[a].type.equals("Msgs")) {
                        s = String.valueOf(s) + " " + GraphLegendPanel.this.data.onGraph[a].type;
                    }
                    if (GraphLegendPanel.this.data.onGraph[a].parent != null) {
                        s = String.valueOf(s) + "(" + GraphLegendPanel.this.data.onGraph[a].parent + ")";
                    }
                    pg.drawString(s, this.width, this.height);
                    this.height += this.textheight;
                    if (this.height > printHeight) {
                        if (this.width == 0) {
                            this.height = 2 * this.textheight;
                            this.width = printWidth / 2;
                        } else {
                            pg.dispose();
                            pg = null;
                            pg = GraphLegendPanel.this.pjob.getGraphics();
                            pg.translate(marginLeft, marginTop);
                            this.height = this.textheight;
                            this.width = 0;
                        }
                    }
                }
                ++a;
            }
            this.setBackground(Color.black);
        }

        public void paint(Graphics g) {
            if (GraphLegendPanel.this.data == null) {
                return;
            }
            if (this.fm == null) {
                this.fm = g.getFontMetrics(g.getFont());
                this.textheight = this.fm.getHeight() + 2;
            }
            this.height = this.textheight;
            this.width = 0;
            g.setColor(MainWindow.runObject[GraphLegendPanel.this.myRun].background);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            int a = 0;
            while (a < GraphLegendPanel.this.data.onGraph.length) {
                if (GraphLegendPanel.this.data.ymode == 11 && GraphLegendPanel.this.data.onGraph[a].ymode != 10 || GraphLegendPanel.this.data.ymode == 10 && GraphLegendPanel.this.data.onGraph[a].ymode != 11) {
                    g.setColor(GraphLegendPanel.this.data.onGraph[a].color);
                    String s = GraphLegendPanel.this.data.onGraph[a].name;
                    if (!GraphLegendPanel.this.data.onGraph[a].type.equals("%") && !GraphLegendPanel.this.data.onGraph[a].type.equals("Msgs")) {
                        s = String.valueOf(s) + " " + GraphLegendPanel.this.data.onGraph[a].type;
                    }
                    if (GraphLegendPanel.this.data.onGraph[a].parent != null) {
                        s = String.valueOf(s) + "(" + GraphLegendPanel.this.data.onGraph[a].parent + ")";
                    }
                    g.drawString(s, 0, this.height);
                    this.height += this.textheight;
                    if (this.fm.stringWidth(s) > this.width) {
                        this.width = this.fm.stringWidth(s);
                    }
                }
                ++a;
            }
            if (this.sp.getViewportSize().width > this.width) {
                this.width = this.sp.getViewportSize().width;
            }
            if (this.sp.getViewportSize().height > this.height) {
                this.height = this.sp.getViewportSize().height;
            }
        }
    }
}

