/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import projections.gui.Bubble;
import projections.gui.MainWindow;

public class PieChartWindow
extends Frame {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private MainWindow mainWindow;
    MyPanel displayPanel;
    float[] data;
    int dataLen;
    float thresh;
    int[][] arc;
    int numArcs;
    Color[] colors;
    int leftBuf;
    private int rightBuf;
    int topBuf;
    private int bottomBuf;
    String[][] names;
    int diameter;
    int centerX;
    int centerY;
    int numEntries;
    int outOfRadius;
    int hasChanged;
    int currX;
    int currY;
    int dist;
    int degree;
    int currArcIndex;
    Bubble bubble;
    String[] bString;

    public PieChartWindow(MainWindow mainWindow, float[] data, int dataLen, float thresh, Color[] colors) {
        this.mainWindow = mainWindow;
        this.data = data;
        this.dataLen = dataLen;
        this.thresh = thresh;
        this.colors = colors;
        this.bString = new String[3];
        this.bString[0] = " ";
        this.bString[1] = " ";
        this.bString[2] = "AVERAGE";
        this.bubble = null;
        this.currArcIndex = -1;
        this.bottomBuf = 25;
        this.topBuf = 25;
        this.rightBuf = 25;
        this.leftBuf = 25;
        this.arc = null;
        this.outOfRadius = 1;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PieChartWindow.this.close();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                PieChartWindow.this.setCursor(new Cursor(3));
                PieChartWindow.this.setSizes();
                PieChartWindow.this.setCursor(new Cursor(0));
            }
        });
        this.setTitle("Projections Pie Chart");
        this.createLayout();
        this.pack();
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
        this.mainWindow.closeChildWindow(0);
        this.dispose();
    }

    public void setSizes() {
        int width = this.displayPanel.getSize().width;
        int height = this.displayPanel.getSize().height;
        this.diameter = width < height ? width - this.leftBuf - this.rightBuf : height - this.topBuf - this.bottomBuf;
        this.centerX = this.leftBuf + this.diameter / 2;
        this.centerY = this.topBuf + this.diameter / 2;
    }

    private void createLayout() {
        this.displayPanel = new MyPanel(this);
        this.displayPanel.setLayout(null);
        this.displayPanel.setBackground(Color.black);
        this.add(this.displayPanel);
    }

    public class MyPanel
    extends Panel
    implements MouseMotionListener {
        private static final long serialVersionUID = 1L;
        private PieChartWindow pcw;

        public MyPanel(PieChartWindow pcw) {
            this.addMouseMotionListener(this);
            this.pcw = pcw;
        }

        public void paint(Graphics g) {
            int k;
            int arcPos = 0;
            PieChartWindow.this.numArcs = 0;
            int count = 0;
            for (k = 0; k < PieChartWindow.this.dataLen - 1; ++k) {
                if (!(PieChartWindow.this.data[k] >= PieChartWindow.this.thresh)) continue;
                ++PieChartWindow.this.numArcs;
            }
            PieChartWindow.this.arc = new int[PieChartWindow.this.numArcs][];
            for (k = 0; k < PieChartWindow.this.numArcs; ++k) {
                PieChartWindow.this.arc[k] = new int[3];
            }
            for (k = 0; k < PieChartWindow.this.dataLen - 1; ++k) {
                if (PieChartWindow.this.data[k] < PieChartWindow.this.thresh) continue;
                g.setColor(PieChartWindow.this.colors[k]);
                g.fillArc(PieChartWindow.this.leftBuf, PieChartWindow.this.topBuf, PieChartWindow.this.diameter, PieChartWindow.this.diameter, arcPos, (int)((double)PieChartWindow.this.data[k] * 3.6));
                PieChartWindow.this.arc[count][0] = arcPos;
                PieChartWindow.this.arc[count][1] = arcPos += (int)((double)PieChartWindow.this.data[k] * 3.6);
                PieChartWindow.this.arc[count][2] = k;
                ++count;
            }
            g.setColor(Color.gray);
            g.drawOval(PieChartWindow.this.leftBuf, PieChartWindow.this.topBuf, PieChartWindow.this.diameter, PieChartWindow.this.diameter);
        }

        public void mouseMoved(MouseEvent e) {
            PieChartWindow.this.currX = e.getX();
            PieChartWindow.this.currY = e.getY();
            double dX = Math.abs((double)(PieChartWindow.this.currX - PieChartWindow.this.centerX));
            double dY = Math.abs((double)(PieChartWindow.this.currY - PieChartWindow.this.centerY));
            PieChartWindow.this.dist = (int)Math.sqrt(Math.pow(dX, 2.0) + Math.pow(dY, 2.0));
            if (PieChartWindow.this.dist <= PieChartWindow.this.diameter / 2) {
                if (PieChartWindow.this.outOfRadius == 1) {
                    PieChartWindow.this.hasChanged = 1;
                    PieChartWindow.this.outOfRadius = 0;
                }
                PieChartWindow.this.degree = (int)Math.toDegrees(Math.atan(dY / dX));
                if (PieChartWindow.this.currX < PieChartWindow.this.centerX && PieChartWindow.this.currY <= PieChartWindow.this.centerY) {
                    PieChartWindow.this.degree = 180 - PieChartWindow.this.degree;
                } else if (PieChartWindow.this.currX < PieChartWindow.this.centerX && PieChartWindow.this.currY > PieChartWindow.this.centerY) {
                    PieChartWindow.this.degree += 180;
                } else if (PieChartWindow.this.currX > PieChartWindow.this.centerX && PieChartWindow.this.currY >= PieChartWindow.this.centerY) {
                    PieChartWindow.this.degree = 360 - PieChartWindow.this.degree;
                }
                boolean inArc = false;
                for (int k = 0; k < PieChartWindow.this.numArcs; ++k) {
                    if (PieChartWindow.this.degree < PieChartWindow.this.arc[k][0] || PieChartWindow.this.degree >= PieChartWindow.this.arc[k][1]) continue;
                    inArc = true;
                    if (PieChartWindow.this.currArcIndex != PieChartWindow.this.arc[k][2]) {
                        PieChartWindow.this.hasChanged = 1;
                        PieChartWindow.this.currArcIndex = PieChartWindow.this.arc[k][2];
                        break;
                    }
                    if (PieChartWindow.this.bubble == null) break;
                    PieChartWindow.this.bubble.setLocation(PieChartWindow.this.currX + 20 + this.pcw.getBounds().x, PieChartWindow.this.currY + 40 + this.pcw.getBounds().y);
                    break;
                }
                if (!inArc) {
                    if (PieChartWindow.this.bubble != null) {
                        PieChartWindow.this.bubble.setVisible(false);
                        PieChartWindow.this.bubble.dispose();
                        PieChartWindow.this.bubble = null;
                    }
                    PieChartWindow.this.hasChanged = 0;
                    PieChartWindow.this.currArcIndex = -1;
                }
                if (PieChartWindow.this.hasChanged == 1) {
                    if (PieChartWindow.this.bubble != null) {
                        PieChartWindow.this.bubble.setVisible(false);
                        PieChartWindow.this.bubble.dispose();
                        PieChartWindow.this.bubble = null;
                    }
                    PieChartWindow.this.numEntries = MainWindow.runObject[PieChartWindow.this.myRun].getNumUserEntries();
                    PieChartWindow.this.degree = (int)Math.toRadians(PieChartWindow.this.degree);
                    int x = PieChartWindow.this.currX + 20 + this.pcw.getBounds().x;
                    int y = PieChartWindow.this.currY + 40 + this.pcw.getBounds().y;
                    if (PieChartWindow.this.currArcIndex < PieChartWindow.this.numEntries) {
                        PieChartWindow.this.bString[0] = PieChartWindow.this.names[PieChartWindow.this.currArcIndex][1] + "::" + PieChartWindow.this.names[PieChartWindow.this.currArcIndex][0];
                    } else if (PieChartWindow.this.currArcIndex == PieChartWindow.this.numEntries) {
                        PieChartWindow.this.bString[0] = "PACKING";
                    } else if (PieChartWindow.this.currArcIndex == PieChartWindow.this.numEntries + 1) {
                        PieChartWindow.this.bString[0] = "UNPACKING";
                    } else if (PieChartWindow.this.currArcIndex == PieChartWindow.this.numEntries + 2) {
                        PieChartWindow.this.bString[0] = "IDLE";
                    }
                    PieChartWindow.this.bString[1] = "usage: " + PieChartWindow.this.data[PieChartWindow.this.currArcIndex] + "%";
                    PieChartWindow.this.bubble = new Bubble(PieChartWindow.this.displayPanel, PieChartWindow.this.bString);
                    PieChartWindow.this.bubble.setLocation(new Point(x, y));
                    PieChartWindow.this.bubble.setVisible(true);
                    PieChartWindow.this.hasChanged = 0;
                }
            } else {
                PieChartWindow.this.outOfRadius = 1;
                if (PieChartWindow.this.bubble != null) {
                    PieChartWindow.this.bubble.setVisible(false);
                    PieChartWindow.this.bubble.dispose();
                    PieChartWindow.this.bubble = null;
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            this.mouseMoved(e);
        }

        public Dimension getPreferredSize() {
            return new Dimension(500, 500);
        }
    }
}

