/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import projections.gui.Timeline.Data;

public class LabelPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private Data data;
    int clickedOnPE;
    Point mouseLast;

    public LabelPanel(Data data) {
        this.setOpaque(true);
        this.data = data;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.clickedOnPE = -1;
    }

    private int preferredWidth() {
        if (this.data.useMinimalView()) {
            return 60;
        }
        return 90;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredWidth(), this.data.screenHeight());
    }

    protected void paintComponent(Graphics g) {
        g.setFont(this.data.labelFont);
        FontMetrics fm = g.getFontMetrics();
        g.setColor(this.data.getBackgroundColor());
        Rectangle clipBounds = g.getClipBounds();
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        int verticalPosition = 0;
        while (verticalPosition < this.data.numPs()) {
            g.setColor(this.data.getForegroundColor());
            int pe = this.data.whichPE(verticalPosition);
            if (pe > -1) {
                String peString;
                if (this.data.useMinimalView() || this.data.useCompactView()) {
                    if (this.clickedOnPE != pe) {
                        if (this.clickedOnPE >= 0 && verticalPosition == this.mouseLast.y / this.data.singleTimelineHeight()) {
                            g.setColor(Color.red);
                            peString = "PE " + this.clickedOnPE;
                            int stringWidth = fm.stringWidth(peString);
                            g.drawString(peString, this.preferredWidth() - stringWidth, fm.getHeight() / 2 + this.data.singleTimelineHeight() / 2 + verticalPosition * this.data.singleTimelineHeight());
                        } else {
                            peString = "PE " + pe;
                            int stringWidth = fm.stringWidth(peString);
                            g.drawString(peString, this.preferredWidth() - stringWidth, fm.getHeight() / 2 + this.data.singleTimelineHeight() / 2 + verticalPosition * this.data.singleTimelineHeight());
                        }
                    }
                } else if (this.clickedOnPE != pe) {
                    if (this.clickedOnPE >= 0 && verticalPosition == this.mouseLast.y / this.data.singleTimelineHeight()) {
                        g.setColor(Color.red);
                        peString = "PE " + this.clickedOnPE;
                        g.drawString(peString, 10, this.data.singleTimelineHeight() / 2 + verticalPosition * this.data.singleTimelineHeight());
                        String percentString = "(" + (int)(100.0f - this.data.idleUsage[this.clickedOnPE]) + ", " + (int)this.data.processorUsage[this.clickedOnPE] + ")";
                        g.drawString(percentString, 15, this.data.singleTimelineHeight() / 2 + verticalPosition * this.data.singleTimelineHeight() + fm.getHeight() + 2);
                    } else {
                        g.setColor(this.data.getForegroundColor());
                        peString = "PE " + pe;
                        g.drawString(peString, 10, this.data.singleTimelineHeight() / 2 + verticalPosition * this.data.singleTimelineHeight());
                        String percentString = "(" + (int)(100.0f - this.data.idleUsage[pe]) + ", " + (int)this.data.processorUsage[pe] + ")";
                        g.drawString(percentString, 15, this.data.singleTimelineHeight() / 2 + verticalPosition * this.data.singleTimelineHeight() + fm.getHeight() + 2);
                    }
                }
            }
            ++verticalPosition;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.mouseLast = e.getPoint();
        int whichLine = this.mouseLast.y / this.data.singleTimelineHeight();
        this.clickedOnPE = this.data.whichPE(whichLine);
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        int whichLine = e.getPoint().y / this.data.singleTimelineHeight();
        this.data.movePEToLine(this.clickedOnPE, whichLine);
        this.clickedOnPE = -1;
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseLast = e.getPoint();
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }
}

