/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

public class U {
    private U() {
    }

    public static long fromT(String t) {
        double mantissa;
        double conv = 1.0;
        int tr = 0;
        if (t.endsWith("s")) {
            tr = 1;
            conv = 1000000.0;
        }
        if (t.endsWith("ms")) {
            tr = 2;
            conv = 1000.0;
        }
        if (t.endsWith("us")) {
            tr = 2;
            conv = 1.0;
        }
        if (t.endsWith("ns")) {
            tr = 2;
            conv = 0.001;
        }
        if (t.endsWith("ps")) {
            tr = 2;
            conv = 1.0E-6;
        }
        if (tr != 0) {
            t = t.substring(0, t.length() - tr);
        }
        try {
            mantissa = Double.valueOf(t.trim());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
        return (long)(mantissa * conv);
    }

    public static long makeEven(long i) {
        if (i > 1000L) {
            return i / 1000L * 1000L;
        }
        if (i > 10L) {
            return i / 10L * 10L;
        }
        return i;
    }

    private static final String printDecimals(double d, int nDec) {
        StringBuffer ret = new StringBuffer();
        d -= (double)((int)d);
        d += 1.0E-9;
        for (int i = 0; i < nDec; ++i) {
            int digit = (int)(d *= 10.0);
            ret.append((char)(digit + 48));
            d -= (double)digit;
        }
        return ret.toString();
    }

    public static String t(long us) {
        return U.t(us, 3);
    }

    public static String t(long us, int places) {
        if (us < 0L) {
            return us + "us";
        }
        if (us == 0L) {
            return "0";
        }
        if (us < 1000L) {
            return "0." + U.printDecimals((double)us * 0.001, places) + "ms";
        }
        if (us < 1000000L) {
            return (int)(us / 1000L) + "." + U.printDecimals((double)us * 0.001, places) + "ms";
        }
        return (int)(us / 1000000L) + "." + U.printDecimals((double)us * 1.0E-6, places) + "s";
    }

    public static int bestNumPlaces(long start, long skip, int num) {
        return 0;
    }

    public static int numUselessZeros(long number) {
        int count = 0;
        while (number % 10L <= 0L) {
            ++count;
            number /= 10L;
        }
        return count;
    }

    public static void main(String[] args) {
        System.out.println(U.numUselessZeros(2345800L));
        System.out.println(U.numUselessZeros(20034L));
        System.out.println(U.numUselessZeros(234580L));
    }
}

